/*
 * Decompiled with CFR 0.152.
 */
package top.seraphjack.simplelogin.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.GameType;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import top.seraphjack.simplelogin.command.arguments.ArgumentTypeEntryName;
import top.seraphjack.simplelogin.command.arguments.ArgumentTypeHandlerPlugin;
import top.seraphjack.simplelogin.server.SLRegistries;
import top.seraphjack.simplelogin.server.handler.PlayerLoginHandler;
import top.seraphjack.simplelogin.server.storage.SLStorage;

public class SLCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"simplelogin").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"save").requires(c -> c.m_6761_(3))).executes(SLCommand::save))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"unregister").requires(c -> c.m_6761_(3))).then(Commands.m_82129_((String)"entry", (ArgumentType)ArgumentTypeEntryName.entryName()).executes(SLCommand::unregister)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"setDefaultGameType").requires(c -> c.m_6761_(3))).then(Commands.m_82129_((String)"entry", (ArgumentType)ArgumentTypeEntryName.entryName()).then(Commands.m_82129_((String)"mode", (ArgumentType)IntegerArgumentType.integer((int)0, (int)3)).executes(SLCommand::setDefaultGamemode))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"plugin").requires(c -> c.m_6761_(3))).then(Commands.m_82127_((String)"load").then(Commands.m_82129_((String)"plugin", (ArgumentType)ArgumentTypeHandlerPlugin.unloadedPlugins()).executes(SLCommand::loadPlugin)))).then(Commands.m_82127_((String)"unload").then(Commands.m_82129_((String)"plugin", (ArgumentType)ArgumentTypeHandlerPlugin.loadedPlugins()).executes(SLCommand::unloadPlugin)))).then(Commands.m_82127_((String)"available").executes(SLCommand::listAvailablePlugins))).then(Commands.m_82127_((String)"loaded").executes(SLCommand::listLoadedPlugins)))).then(Commands.m_82127_((String)"about").executes(SLCommand::about));
        dispatcher.register(command);
    }

    private static int save(CommandContext<CommandSourceStack> ctx) {
        try {
            long start = System.currentTimeMillis();
            SLStorage.instance().storageProvider.save();
            long cost = System.currentTimeMillis() - start;
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Done. Took " + cost + " ms.")), true);
        }
        catch (IOException e) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Error during saving entries, see log for details"), false);
        }
        return 1;
    }

    private static int unregister(CommandContext<CommandSourceStack> ctx) {
        SLStorage.instance().storageProvider.unregister(ArgumentTypeEntryName.getEntryName(ctx, "entry"));
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Successfully unregistered."), false);
        return 1;
    }

    private static int setDefaultGamemode(CommandContext<CommandSourceStack> ctx) {
        GameType gameType = GameType.m_46393_((int)((Integer)ctx.getArgument("mode", Integer.class)));
        SLStorage.instance().storageProvider.setGameType(ArgumentTypeEntryName.getEntryName(ctx, "entry"), gameType);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Successfully set entry default game type to " + gameType.m_46405_() + ".")), false);
        return 1;
    }

    private static int about(CommandContext<CommandSourceStack> ctx) {
        ModInfo info = FMLLoader.getLoadingModList().getMods().stream().filter(modInfo -> modInfo.getModId().equals("simplelogin")).findAny().get();
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"simplelogin.command.about.info", (Object[])new Object[]{info.getVersion().toString()}), false);
        return 1;
    }

    private static int loadPlugin(CommandContext<CommandSourceStack> ctx) {
        ResourceLocation plugin = ArgumentTypeHandlerPlugin.getPlugin(ctx, "plugin");
        if (SLRegistries.PLUGINS.get(plugin).isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"simplelogin.command.plugin.not_found", (Object[])new Object[]{plugin.toString()}), true);
            return 1;
        }
        if (PlayerLoginHandler.instance().listPlugins().contains(plugin)) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"simplelogin.command.plugin.already_loaded", (Object[])new Object[]{plugin.toString()}), true);
            return 1;
        }
        PlayerLoginHandler.instance().loadPlugin(plugin);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"simplelogin.command.plugin.load_success", (Object[])new Object[]{plugin.toString()}), true);
        return 1;
    }

    private static int unloadPlugin(CommandContext<CommandSourceStack> ctx) {
        ResourceLocation plugin = ArgumentTypeHandlerPlugin.getPlugin(ctx, "plugin");
        if (SLRegistries.PLUGINS.get(plugin).isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"simplelogin.command.plugin.not_found", (Object[])new Object[]{plugin.toString()}), true);
            return 1;
        }
        if (!PlayerLoginHandler.instance().listPlugins().contains(plugin)) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"simplelogin.command.plugin.not_loaded", (Object[])new Object[]{plugin.toString()}), true);
            return 1;
        }
        PlayerLoginHandler.instance().unloadPlugin(plugin);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"simplelogin.command.plugin.unload_success", (Object[])new Object[]{plugin.toString()}), true);
        return 1;
    }

    private static int listAvailablePlugins(CommandContext<CommandSourceStack> ctx) {
        Set<ResourceLocation> plugins = SLRegistries.PLUGINS.list();
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"simplelogin.command.plugin.available_plugin_header"), false);
        for (ResourceLocation plugin : plugins) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"simplelogin.command.plugin.list_member", (Object[])new Object[]{plugin.toString()}), false);
        }
        return 1;
    }

    private static int listLoadedPlugins(CommandContext<CommandSourceStack> ctx) {
        Collection<ResourceLocation> plugins = PlayerLoginHandler.instance().listPlugins();
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"simplelogin.command.plugin.loaded_plugin_header"), false);
        for (ResourceLocation plugin : plugins) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"simplelogin.command.plugin.list_member", (Object[])new Object[]{plugin.toString()}), false);
        }
        return 1;
    }
}

