/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.api.internal;

import com.seibel.distanthorizons.api.DhApi;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiDebugRendering;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiRenderPass;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiRendererMode;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiAfterRenderEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeDeferredRenderEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeRenderEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiLevelLoadEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiLevelUnloadEvent;
import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiRenderParam;
import com.seibel.distanthorizons.core.api.internal.ClientPluginChannelApi;
import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.level.IServerKeyedClientLevel;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import com.seibel.distanthorizons.core.logging.ConfigBasedSpamLogger;
import com.seibel.distanthorizons.core.logging.SpamReducedLogger;
import com.seibel.distanthorizons.core.network.messages.AbstractNetworkMessage;
import com.seibel.distanthorizons.core.network.session.NetworkSession;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.render.DhApiRenderProxy;
import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import com.seibel.distanthorizons.core.render.renderer.TestRenderer;
import com.seibel.distanthorizons.core.util.RenderUtil;
import com.seibel.distanthorizons.core.util.TimerUtil;
import com.seibel.distanthorizons.core.util.math.Mat4f;
import com.seibel.distanthorizons.core.util.objects.Pair;
import com.seibel.distanthorizons.core.world.AbstractDhWorld;
import com.seibel.distanthorizons.core.world.DhClientServerWorld;
import com.seibel.distanthorizons.core.world.DhClientWorld;
import com.seibel.distanthorizons.core.world.IDhClientWorld;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IProfilerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.coreapi.DependencyInjection.ApiEventInjector;
import com.seibel.distanthorizons.coreapi.ModInfo;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ClientApi {
    private static final Logger LOGGER = LogManager.getLogger();
    public static boolean prefLoggerEnabled = false;
    public static final ClientApi INSTANCE = new ClientApi();
    public static final TestRenderer TEST_RENDERER = new TestRenderer();
    private static final IMinecraftClientWrapper MC_CLIENT = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    public static final long SPAM_LOGGER_FLUSH_NS = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS);
    private boolean configOverrideReminderPrinted = false;
    private boolean lowMemoryWarningPrinted = false;
    private final Queue<String> chatMessageQueueForNextFrame = new LinkedBlockingQueue<String>();
    public boolean rendererDisabledBecauseOfExceptions = false;
    private long lastFlushNanoTime = 0L;
    private final ClientPluginChannelApi pluginChannelApi = new ClientPluginChannelApi(this::clientLevelLoadEvent, this::clientLevelUnloadEvent);
    private Timer firstLevelLoadTimer;
    private static final long FIRST_LEVEL_LOAD_DELAY_IN_MS = 1000L;
    public final HashSet<IClientLevelWrapper> waitingClientLevels = new HashSet();
    public final HashMap<Pair<IClientLevelWrapper, DhChunkPos>, IChunkWrapper> waitingChunkByClientLevelAndPos = new HashMap();
    private boolean renderingCancelledForThisFrame;

    private ClientApi() {
    }

    public synchronized void onClientOnlyConnected() {
        boolean connectedToServer = MC_CLIENT.clientConnectedToDedicatedServer();
        boolean connectedToReplay = MC_CLIENT.connectedToReplay();
        if (connectedToServer || connectedToReplay) {
            if (connectedToServer) {
                LOGGER.info("Client on ClientOnly mode connecting.");
            } else {
                LOGGER.info("Replay on ClientServer mode connecting.");
                if (Config.Client.Advanced.Logging.showReplayWarningOnStartup.get().booleanValue()) {
                    MC_CLIENT.sendChatMessage("\u00a76Distant Horizons: Replay detected.\u00a7r");
                    MC_CLIENT.sendChatMessage("DH may behave strangely or have missing functionality.");
                    MC_CLIENT.sendChatMessage("In order to use pre-generated LODs, put your DH database(s) in:");
                    MC_CLIENT.sendChatMessage("\u00a77.Minecraft" + File.separator + "Distant_Horizons_server_data" + File.separator + "REPLAY" + File.separator + "DIMENSION_NAME\u00a7r");
                    MC_CLIENT.sendChatMessage("This can be disabled in DH's config under Advanced -> Logging.");
                    MC_CLIENT.sendChatMessage("");
                }
            }
            DhClientWorld world = new DhClientWorld();
            SharedApi.setDhWorld(world);
            this.pluginChannelApi.onJoinServer(world.networkState.getSession());
            world.networkState.sendConfigMessage();
            LOGGER.info("Loading [" + this.waitingClientLevels.size() + "] waiting client level wrappers.");
            for (IClientLevelWrapper level : this.waitingClientLevels) {
                this.clientLevelLoadEvent(level);
            }
            this.waitingClientLevels.clear();
        }
    }

    public synchronized void onClientOnlyDisconnected() {
        AbstractDhWorld world;
        if (this.firstLevelLoadTimer != null) {
            this.firstLevelLoadTimer.cancel();
            this.firstLevelLoadTimer = null;
        }
        if ((world = SharedApi.getAbstractDhWorld()) != null) {
            LOGGER.info("Client on ClientOnly mode disconnecting.");
            world.close();
            SharedApi.setDhWorld(null);
        }
        this.pluginChannelApi.reset();
        this.waitingChunkByClientLevelAndPos.clear();
        this.waitingClientLevels.clear();
    }

    public void clientLevelUnloadEvent(IClientLevelWrapper level) {
        try {
            AbstractDhWorld world;
            LOGGER.info("Unloading client level [" + level + "]-[" + level.getDimensionName() + "].");
            if (level instanceof IServerKeyedClientLevel) {
                this.pluginChannelApi.onClientLevelUnload();
            }
            if ((world = SharedApi.getAbstractDhWorld()) != null) {
                world.unloadLevel(level);
                ApiEventInjector.INSTANCE.fireAllEvents(DhApiLevelUnloadEvent.class, new DhApiLevelUnloadEvent.EventParam(level));
            } else {
                this.waitingClientLevels.remove(level);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error in ClientApi.clientLevelUnloadEvent(), error: " + e.getMessage(), (Throwable)e);
        }
    }

    public void clientLevelLoadEvent(final IClientLevelWrapper level) {
        if (MC_CLIENT.clientConnectedToDedicatedServer()) {
            if (this.firstLevelLoadTimer == null) {
                this.firstLevelLoadTimer = TimerUtil.CreateTimer("FirstLevelLoadTimer");
                this.firstLevelLoadTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        ClientApi.this.clientLevelLoadEvent(level);
                    }
                }, 1000L);
                return;
            }
            this.firstLevelLoadTimer.cancel();
        }
        try {
            LOGGER.info("Loading client level [" + level + "]-[" + level.getDimensionName() + "].");
            AbstractDhWorld world = SharedApi.getAbstractDhWorld();
            if (world != null) {
                if (!this.pluginChannelApi.allowLevelLoading(level)) {
                    LOGGER.info("Levels in this connection are managed by the server, skipping auto-load.");
                    ((DhClientWorld)world).networkState.sendConfigMessage();
                    return;
                }
                world.getOrLoadLevel(level);
                ApiEventInjector.INSTANCE.fireAllEvents(DhApiLevelLoadEvent.class, new DhApiLevelLoadEvent.EventParam(level));
                this.loadWaitingChunksForLevel(level);
            } else {
                this.waitingClientLevels.add(level);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error in ClientApi.clientLevelLoadEvent(), error: " + e.getMessage(), (Throwable)e);
        }
    }

    private void loadWaitingChunksForLevel(IClientLevelWrapper level) {
        HashSet<Pair<IClientLevelWrapper, DhChunkPos>> keysToRemove = new HashSet<Pair<IClientLevelWrapper, DhChunkPos>>();
        for (Pair<IClientLevelWrapper, DhChunkPos> levelChunkPair : this.waitingChunkByClientLevelAndPos.keySet()) {
            IClientLevelWrapper levelWrapper = (IClientLevelWrapper)levelChunkPair.first;
            if (!levelWrapper.equals(level)) continue;
            IChunkWrapper chunkWrapper = this.waitingChunkByClientLevelAndPos.get(levelChunkPair);
            SharedApi.INSTANCE.chunkLoadEvent(chunkWrapper, levelWrapper);
            keysToRemove.add(levelChunkPair);
        }
        LOGGER.info("Loaded [" + keysToRemove.size() + "] waiting chunk wrappers.");
        for (Pair<IClientLevelWrapper, DhChunkPos> keyToRemove : keysToRemove) {
            this.waitingChunkByClientLevelAndPos.remove(keyToRemove);
        }
    }

    public void rendererShutdownEvent() {
        LOGGER.info("Renderer shutting down.");
        IProfilerWrapper profiler = MC_CLIENT.getProfiler();
        profiler.push("DH-RendererShutdown");
        profiler.pop();
    }

    public void rendererStartupEvent() {
        LOGGER.info("Renderer starting up.");
        IProfilerWrapper profiler = MC_CLIENT.getProfiler();
        profiler.push("DH-RendererStartup");
        GLProxy.getInstance();
        profiler.pop();
    }

    public void clientTickEvent() {
        IProfilerWrapper profiler = MC_CLIENT.getProfiler();
        profiler.push("DH-ClientTick");
        try {
            boolean doFlush;
            boolean bl = doFlush = System.nanoTime() - this.lastFlushNanoTime >= SPAM_LOGGER_FLUSH_NS;
            if (doFlush) {
                this.lastFlushNanoTime = System.nanoTime();
                SpamReducedLogger.flushAll();
            }
            ConfigBasedLogger.updateAll();
            ConfigBasedSpamLogger.updateAll(doFlush);
            IDhClientWorld clientWorld = SharedApi.getIDhClientWorld();
            if (clientWorld != null) {
                clientWorld.clientTick();
                if (!(clientWorld instanceof DhClientServerWorld)) {
                    SharedApi.worldGenTick(clientWorld::worldGenTick);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error in ClientApi.clientTickEvent(), error: " + e.getMessage(), (Throwable)e);
        }
        profiler.pop();
    }

    public void pluginMessageReceived(@NotNull AbstractNetworkMessage message) {
        NetworkSession networkSession = this.pluginChannelApi.networkSession;
        if (networkSession != null) {
            networkSession.tryHandleMessage(message);
        }
    }

    public void renderLods(IClientLevelWrapper levelWrapper, Mat4f mcModelViewMatrix, Mat4f mcProjectionMatrix, float partialTicks) {
        this.renderLodLayer(levelWrapper, mcModelViewMatrix, mcProjectionMatrix, partialTicks, false);
    }

    public void renderDeferredLods(IClientLevelWrapper levelWrapper, Mat4f mcModelViewMatrix, Mat4f mcProjectionMatrix, float partialTicks) {
        this.renderLodLayer(levelWrapper, mcModelViewMatrix, mcProjectionMatrix, partialTicks, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderLodLayer(IClientLevelWrapper levelWrapper, Mat4f mcModelViewMatrix, Mat4f mcProjectionMatrix, float partialTicks, boolean renderingDeferredLayer) {
        this.sendQueuedChatMessages();
        IProfilerWrapper profiler = MC_CLIENT.getProfiler();
        profiler.pop();
        profiler.push("DH-RenderLevel");
        EDhApiRenderPass renderPass = DhApiRenderProxy.INSTANCE.getDeferTransparentRendering() ? (renderingDeferredLayer ? EDhApiRenderPass.TRANSPARENT : EDhApiRenderPass.OPAQUE) : EDhApiRenderPass.OPAQUE_AND_TRANSPARENT;
        DhApiRenderParam renderEventParam = new DhApiRenderParam(renderPass, partialTicks, RenderUtil.getNearClipPlaneDistanceInBlocks(partialTicks), RenderUtil.getFarClipPlaneDistanceInBlocks(), mcProjectionMatrix, mcModelViewMatrix, RenderUtil.createLodProjectionMatrix(mcProjectionMatrix, partialTicks), RenderUtil.createLodModelViewMatrix(mcModelViewMatrix), levelWrapper.getMinHeight());
        try {
            if (!RenderUtil.shouldLodsRender(levelWrapper)) {
                return;
            }
            IDhClientWorld dhClientWorld = SharedApi.getIDhClientWorld();
            if (dhClientWorld == null) {
                return;
            }
            IDhClientLevel level = (IDhClientLevel)dhClientWorld.getLevel(levelWrapper);
            if (level == null) {
                return;
            }
            if (this.rendererDisabledBecauseOfExceptions) {
                if (!Config.Client.quickEnableRendering.get().booleanValue()) {
                    LOGGER.info("DH Renderer re-enabled after exception. Some rendering issues may occur. Please reboot Minecraft if you see any rendering issues.");
                    this.rendererDisabledBecauseOfExceptions = false;
                    Config.Client.quickEnableRendering.set(true);
                }
                return;
            }
            if (!renderingDeferredLayer) {
                if (Config.Client.Advanced.Debugging.rendererMode.get() == EDhApiRendererMode.DEFAULT) {
                    this.renderingCancelledForThisFrame = ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeRenderEvent.class, renderEventParam);
                    if (!this.renderingCancelledForThisFrame) {
                        level.render(renderEventParam, profiler);
                    }
                    if (!DhApi.Delayed.renderProxy.getDeferTransparentRendering()) {
                        ApiEventInjector.INSTANCE.fireAllEvents(DhApiAfterRenderEvent.class, null);
                    }
                } else if (Config.Client.Advanced.Debugging.rendererMode.get() == EDhApiRendererMode.DEBUG) {
                    profiler.push("Render Debug");
                    TEST_RENDERER.render();
                    profiler.pop();
                }
            } else {
                boolean renderingCancelled = ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeDeferredRenderEvent.class, renderEventParam);
                if (!renderingCancelled) {
                    level.renderDeferred(renderEventParam, profiler);
                }
                if (DhApi.Delayed.renderProxy.getDeferTransparentRendering()) {
                    ApiEventInjector.INSTANCE.fireAllEvents(DhApiAfterRenderEvent.class, null);
                }
            }
        }
        catch (Exception e) {
            this.rendererDisabledBecauseOfExceptions = true;
            LOGGER.error("Unexpected Renderer error in render pass [" + (Object)((Object)renderPass) + "]. Error: " + e.getMessage(), (Throwable)e);
            MC_CLIENT.sendChatMessage("\u00a74\u00a7l\u00a7uERROR: Distant Horizons renderer has encountered an exception!");
            MC_CLIENT.sendChatMessage("\u00a74Renderer disabled to try preventing GL state corruption.");
            MC_CLIENT.sendChatMessage("\u00a74Toggle DH rendering via the config UI to re-activate DH rendering.");
            MC_CLIENT.sendChatMessage("\u00a74Error: " + e);
        }
        finally {
            try {
                GLProxy.getInstance().runRenderThreadTasks();
            }
            catch (Exception e) {
                LOGGER.error("Unexpected issue running render thread tasks.", (Throwable)e);
            }
            profiler.pop();
            profiler.push("terrain");
        }
    }

    public void keyPressedEvent(int glfwKey) {
        if (!Config.Client.Advanced.Debugging.enableDebugKeybindings.get().booleanValue()) {
            return;
        }
        if (glfwKey == 297) {
            Config.Client.Advanced.Debugging.debugRendering.set(EDhApiDebugRendering.next(Config.Client.Advanced.Debugging.debugRendering.get()));
            MC_CLIENT.sendChatMessage("F8: Set debug mode to " + (Object)((Object)Config.Client.Advanced.Debugging.debugRendering.get()));
        } else if (glfwKey == 295) {
            Config.Client.Advanced.Debugging.rendererMode.set(EDhApiRendererMode.next(Config.Client.Advanced.Debugging.rendererMode.get()));
            MC_CLIENT.sendChatMessage("F6: Set rendering to " + (Object)((Object)Config.Client.Advanced.Debugging.rendererMode.get()));
        } else if (glfwKey == 80) {
            prefLoggerEnabled = !prefLoggerEnabled;
            MC_CLIENT.sendChatMessage("P: Debug Pref Logger is " + (prefLoggerEnabled ? "enabled" : "disabled"));
        }
    }

    private void sendQueuedChatMessages() {
        String message;
        if (ModInfo.IS_DEV_BUILD && !this.configOverrideReminderPrinted && MC_CLIENT.playerExists()) {
            this.configOverrideReminderPrinted = true;
            message = "\u00a72Distant Horizons: nightly/unstable build, version: [2.3.0-a-dev].\u00a7r\nIssues may occur with this version.\nHere be dragons!\n";
            MC_CLIENT.sendChatMessage(message);
        }
        if (!this.lowMemoryWarningPrinted && Config.Client.Advanced.Logging.showLowMemoryWarningOnStartup.get().booleanValue()) {
            this.lowMemoryWarningPrinted = true;
            long minimumRecommendedMemoryInBytes = 4000000000L;
            long maxMemoryInBytes = Runtime.getRuntime().maxMemory();
            if (maxMemoryInBytes < minimumRecommendedMemoryInBytes) {
                String message2 = "\u00a76Distant Horizons: Low memory detected.\u00a7r \nStuttering or low FPS may occur. \nPlease increase Minecraft's available memory to 4 gigabytes. \nThis warning can be disabled in DH's config under Advanced -> Logging. \n";
                MC_CLIENT.sendChatMessage(message2);
            }
        }
        while (!this.chatMessageQueueForNextFrame.isEmpty()) {
            message = this.chatMessageQueueForNextFrame.poll();
            if (message == null) {
                message = "";
            }
            MC_CLIENT.sendChatMessage(message);
        }
    }

    public void showChatMessageNextFrame(String chatMessage) {
        this.chatMessageQueueForNextFrame.add(chatMessage);
    }
}

