/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.api.internal;

import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiWorldLoadEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiWorldUnloadEvent;
import com.seibel.distanthorizons.core.Initializer;
import com.seibel.distanthorizons.core.api.internal.ClientApi;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.generation.DhLightingEngine;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.logging.f3.F3Screen;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.sql.repo.AbstractDhRepo;
import com.seibel.distanthorizons.core.util.objects.Pair;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import com.seibel.distanthorizons.core.world.AbstractDhWorld;
import com.seibel.distanthorizons.core.world.DhApiWorldProxy;
import com.seibel.distanthorizons.core.world.DhClientServerWorld;
import com.seibel.distanthorizons.core.world.EWorldEnvironment;
import com.seibel.distanthorizons.core.world.IDhClientWorld;
import com.seibel.distanthorizons.core.world.IDhServerWorld;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.coreapi.DependencyInjection.ApiEventInjector;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.PriorityQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class SharedApi {
    public static final SharedApi INSTANCE = new SharedApi();
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);
    private static final IMinecraftClientWrapper MC_CLIENT = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static final UpdateChunkPosManager UPDATE_POS_MANAGER = new UpdateChunkPosManager();
    private static final int MAX_UPDATING_CHUNK_COUNT_PER_THREAD = 500;
    private static AbstractDhWorld currentWorld;
    private static int lastWorldGenTickDelta;

    private SharedApi() {
    }

    public static void init() {
        Initializer.init();
    }

    public static EWorldEnvironment getEnvironment() {
        return currentWorld == null ? null : SharedApi.currentWorld.environment;
    }

    public static void setDhWorld(AbstractDhWorld newWorld) {
        currentWorld = newWorld;
        if (currentWorld != null) {
            ThreadPoolUtil.setupThreadPools();
            ApiEventInjector.INSTANCE.fireAllEvents(DhApiWorldLoadEvent.class, new DhApiWorldLoadEvent.EventParam());
        } else {
            ThreadPoolUtil.shutdownThreadPools();
            DebugRenderer.clearRenderables();
            MC_RENDER.clearTargetFrameBuffer();
            AbstractDhRepo.closeAllConnections();
            UPDATE_POS_MANAGER.clear();
            System.gc();
            ApiEventInjector.INSTANCE.fireAllEvents(DhApiWorldUnloadEvent.class, new DhApiWorldUnloadEvent.EventParam());
            DhApiWorldProxy.INSTANCE.setReadOnly(false, false);
        }
    }

    public static void worldGenTick(Runnable worldGenRunnable) {
        if (--lastWorldGenTickDelta <= 0) {
            worldGenRunnable.run();
            lastWorldGenTickDelta = 20;
        }
    }

    public static AbstractDhWorld getAbstractDhWorld() {
        return currentWorld;
    }

    public static DhClientServerWorld getDhClientServerWorld() {
        return currentWorld instanceof DhClientServerWorld ? (DhClientServerWorld)currentWorld : null;
    }

    public static IDhClientWorld getIDhClientWorld() {
        return currentWorld instanceof IDhClientWorld ? (IDhClientWorld)((Object)currentWorld) : null;
    }

    public static IDhServerWorld getIDhServerWorld() {
        return currentWorld instanceof IDhServerWorld ? (IDhServerWorld)((Object)currentWorld) : null;
    }

    public static boolean isChunkAtBlockPosAlreadyUpdating(int blockPosX, int blockPosZ) {
        return UPDATE_POS_MANAGER.contains(new DhChunkPos(new DhBlockPos2D(blockPosX, blockPosZ)));
    }

    public static boolean isChunkAtChunkPosAlreadyUpdating(int chunkPosX, int chunkPosZ) {
        return UPDATE_POS_MANAGER.contains(new DhChunkPos(chunkPosX, chunkPosZ));
    }

    public void chunkBlockChangedEvent(IChunkWrapper chunk, ILevelWrapper level) {
        this.applyChunkUpdate(chunk, level, true);
    }

    public void chunkLoadEvent(IChunkWrapper chunk, ILevelWrapper level) {
        this.applyChunkUpdate(chunk, level, false);
    }

    public void applyChunkUpdate(IChunkWrapper chunkWrapper, ILevelWrapper level, boolean updateNeighborChunks) {
        if (chunkWrapper == null) {
            return;
        }
        AbstractDhWorld dhWorld = SharedApi.getAbstractDhWorld();
        if (dhWorld == null) {
            if (level instanceof IClientLevelWrapper) {
                IClientLevelWrapper clientLevel = (IClientLevelWrapper)level;
                ClientApi.INSTANCE.waitingChunkByClientLevelAndPos.replace(new Pair<IClientLevelWrapper, DhChunkPos>(clientLevel, chunkWrapper.getChunkPos()), chunkWrapper);
            }
            return;
        }
        if (DhApiWorldProxy.INSTANCE.getReadOnly()) {
            return;
        }
        IDhLevel dhLevel = dhWorld.getLevel(level);
        if (dhLevel == null) {
            if (level instanceof IClientLevelWrapper) {
                IClientLevelWrapper clientLevel = (IClientLevelWrapper)level;
                ClientApi.INSTANCE.waitingChunkByClientLevelAndPos.replace(new Pair<IClientLevelWrapper, DhChunkPos>(clientLevel, chunkWrapper.getChunkPos()), chunkWrapper);
            }
            return;
        }
        if (!updateNeighborChunks) {
            SharedApi.queueChunkUpdate(chunkWrapper, null, dhLevel);
        } else {
            ArrayList<IChunkWrapper> neighbourChunkList = new ArrayList<IChunkWrapper>(9);
            for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                    if (xOffset == 0 && zOffset == 0) {
                        neighbourChunkList.add(chunkWrapper);
                        continue;
                    }
                    DhChunkPos neighbourPos = new DhChunkPos(chunkWrapper.getChunkPos().getX() + xOffset, chunkWrapper.getChunkPos().getZ() + zOffset);
                    IChunkWrapper neighbourChunk = dhLevel.getLevelWrapper().tryGetChunk(neighbourPos);
                    if (neighbourChunk == null) continue;
                    neighbourChunkList.add(neighbourChunk);
                }
            }
            for (IChunkWrapper litChunk : neighbourChunkList) {
                SharedApi.queueChunkUpdate(litChunk, neighbourChunkList, dhLevel);
            }
        }
    }

    private static void queueChunkUpdate(IChunkWrapper chunkWrapper, @Nullable ArrayList<IChunkWrapper> neighbourChunkList, IDhLevel dhLevel) {
        if (MC_CLIENT != null && MC_CLIENT.playerExists()) {
            UPDATE_POS_MANAGER.setCenter(MC_CLIENT.getPlayerChunkPos());
            UPDATE_POS_MANAGER.maxSize = 500 * Config.Client.Advanced.MultiThreading.numberOfLodBuilderThreads.get();
        }
        UpdateChunkData updateData = new UpdateChunkData(chunkWrapper, neighbourChunkList, dhLevel);
        UPDATE_POS_MANAGER.addItem(chunkWrapper.getChunkPos(), updateData);
        ThreadPoolExecutor executor = ThreadPoolUtil.getChunkToLodBuilderExecutor();
        if (executor != null && executor.getQueue().size() < executor.getCorePoolSize()) {
            try {
                executor.execute(SharedApi::processQueuedChunkUpdate);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processQueuedChunkUpdate() {
        UpdateChunkData updateData = UPDATE_POS_MANAGER.popClosest();
        if (updateData == null) {
            return;
        }
        IChunkWrapper chunkWrapper = updateData.chunkWrapper;
        @Nullable ArrayList<IChunkWrapper> neighbourChunkList = updateData.neighbourChunkList;
        IDhLevel dhLevel = updateData.dhLevel;
        try {
            ArrayList<IChunkWrapper> nearbyChunkList;
            boolean checkChunkHash = Config.Client.Advanced.LodBuilding.disableUnchangedChunkCheck.get() == false;
            int oldChunkHash = dhLevel.getChunkHash(chunkWrapper.getChunkPos());
            int newChunkHash = chunkWrapper.getBlockBiomeHashCode();
            if (checkChunkHash && oldChunkHash == newChunkHash) {
                return;
            }
            if (neighbourChunkList != null) {
                nearbyChunkList = neighbourChunkList;
            } else {
                nearbyChunkList = new ArrayList(1);
                nearbyChunkList.add(chunkWrapper);
            }
            DhLightingEngine.INSTANCE.bakeChunkBlockLighting(chunkWrapper, nearbyChunkList, dhLevel.hasSkyLight() ? 15 : 0);
            dhLevel.updateBeaconBeamsForChunk(chunkWrapper, nearbyChunkList);
            dhLevel.updateChunkAsync(chunkWrapper, newChunkHash);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error when updating chunk at pos: [" + chunkWrapper.getChunkPos() + "]", (Throwable)e);
        }
        finally {
            ThreadPoolExecutor executor = ThreadPoolUtil.getChunkToLodBuilderExecutor();
            if (executor != null && !UPDATE_POS_MANAGER.positionMap.isEmpty()) {
                try {
                    executor.execute(SharedApi::processQueuedChunkUpdate);
                }
                catch (RejectedExecutionException rejectedExecutionException) {}
            }
        }
    }

    public String getDebugMenuString() {
        String updatingCountStr = F3Screen.NUMBER_FORMAT.format(UPDATE_POS_MANAGER.closestQueue.size());
        String maxUpdateCountStr = F3Screen.NUMBER_FORMAT.format(UPDATE_POS_MANAGER.maxSize);
        return "Queued chunk updates: " + updatingCountStr + " / " + maxUpdateCountStr;
    }

    static {
        lastWorldGenTickDelta = 0;
    }

    private static class UpdateChunkPosManager {
        private final PriorityQueue<DhChunkPos> closestQueue;
        private final PriorityQueue<DhChunkPos> furthestQueue;
        private final HashMap<DhChunkPos, UpdateChunkData> positionMap;
        private final ReentrantLock lock = new ReentrantLock();
        private DhChunkPos center;
        private int maxSize = 500;

        public UpdateChunkPosManager() {
            this.closestQueue = new PriorityQueue<DhChunkPos>(Comparator.comparingDouble(pos -> pos.squaredDistance(this.center)));
            this.furthestQueue = new PriorityQueue<Object>(Comparator.comparingDouble(pos -> ((DhChunkPos)pos).squaredDistance(this.center)).reversed());
            this.positionMap = new HashMap();
            this.center = new DhChunkPos(0, 0);
        }

        public boolean contains(DhChunkPos pos) {
            try {
                this.lock.lock();
                boolean bl = this.positionMap.containsKey(pos);
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        public void clear() {
            try {
                this.lock.lock();
                this.positionMap.clear();
                this.closestQueue.clear();
                this.furthestQueue.clear();
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addItem(DhChunkPos pos, UpdateChunkData updateData) {
            try {
                this.lock.lock();
                if (this.positionMap.containsKey(pos)) {
                    return;
                }
                if (this.positionMap.size() >= this.maxSize) {
                    DhChunkPos furthest = this.furthestQueue.poll();
                    this.closestQueue.remove(furthest);
                    this.positionMap.remove(furthest);
                }
                this.positionMap.put(pos, updateData);
                this.closestQueue.add(pos);
                this.furthestQueue.add(pos);
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCenter(DhChunkPos newCenter) {
            if (newCenter.equals(this.center)) {
                return;
            }
            try {
                this.lock.lock();
                this.center = newCenter;
                this.closestQueue.clear();
                this.furthestQueue.clear();
                for (DhChunkPos pos : this.positionMap.keySet()) {
                    this.closestQueue.add(pos);
                    this.furthestQueue.add(pos);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public UpdateChunkData popClosest() {
            if (this.closestQueue.isEmpty()) {
                return null;
            }
            try {
                this.lock.lock();
                DhChunkPos closest = this.closestQueue.poll();
                this.furthestQueue.remove(closest);
                UpdateChunkData updateChunkData = this.positionMap.remove(closest);
                return updateChunkData;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private static class UpdateChunkData {
        public IChunkWrapper chunkWrapper;
        @Nullable
        public ArrayList<IChunkWrapper> neighbourChunkList;
        public IDhLevel dhLevel;

        public UpdateChunkData(IChunkWrapper chunkWrapper, @Nullable ArrayList<IChunkWrapper> neighbourChunkList, IDhLevel dhLevel) {
            this.chunkWrapper = chunkWrapper;
            this.neighbourChunkList = neighbourChunkList;
            this.dhLevel = dhLevel;
        }
    }
}

