/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.config;

import com.seibel.distanthorizons.api.DhApi;
import com.seibel.distanthorizons.api.enums.config.EDhApiBlocksToAvoid;
import com.seibel.distanthorizons.api.enums.config.EDhApiDataCompressionMode;
import com.seibel.distanthorizons.api.enums.config.EDhApiGLErrorHandlingMode;
import com.seibel.distanthorizons.api.enums.config.EDhApiGlProfileMode;
import com.seibel.distanthorizons.api.enums.config.EDhApiGrassSideRendering;
import com.seibel.distanthorizons.api.enums.config.EDhApiHorizontalQuality;
import com.seibel.distanthorizons.api.enums.config.EDhApiLodShading;
import com.seibel.distanthorizons.api.enums.config.EDhApiLoggerMode;
import com.seibel.distanthorizons.api.enums.config.EDhApiMaxHorizontalResolution;
import com.seibel.distanthorizons.api.enums.config.EDhApiServerFolderNameMode;
import com.seibel.distanthorizons.api.enums.config.EDhApiUpdateBranch;
import com.seibel.distanthorizons.api.enums.config.EDhApiVerticalQuality;
import com.seibel.distanthorizons.api.enums.config.EDhApiWorldCompressionMode;
import com.seibel.distanthorizons.api.enums.config.quickOptions.EDhApiQualityPreset;
import com.seibel.distanthorizons.api.enums.config.quickOptions.EDhApiThreadPreset;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiDebugRendering;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiFogColorMode;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiFogDrawMode;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiFogFalloff;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiHeightFogMixMode;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiHeightFogMode;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiRendererMode;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiTransparency;
import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiDistantGeneratorMode;
import com.seibel.distanthorizons.core.config.eventHandlers.QuickRenderToggleConfigEventHandler;
import com.seibel.distanthorizons.core.config.eventHandlers.ReloadLodsConfigEventHandler;
import com.seibel.distanthorizons.core.config.eventHandlers.RenderCacheConfigEventHandler;
import com.seibel.distanthorizons.core.config.eventHandlers.UnsafeValuesConfigListener;
import com.seibel.distanthorizons.core.config.eventHandlers.WorldCurvatureConfigEventHandler;
import com.seibel.distanthorizons.core.config.eventHandlers.presets.RenderQualityPresetConfigEventHandler;
import com.seibel.distanthorizons.core.config.eventHandlers.presets.ThreadPresetConfigEventHandler;
import com.seibel.distanthorizons.core.config.listeners.ConfigChangeListener;
import com.seibel.distanthorizons.core.config.types.ConfigCategory;
import com.seibel.distanthorizons.core.config.types.ConfigEntry;
import com.seibel.distanthorizons.core.config.types.ConfigLinkedEntry;
import com.seibel.distanthorizons.core.config.types.ConfigUIButton;
import com.seibel.distanthorizons.core.config.types.ConfigUIComment;
import com.seibel.distanthorizons.core.config.types.enums.EConfigEntryAppearance;
import com.seibel.distanthorizons.core.config.types.enums.EConfigEntryPerformance;
import com.seibel.distanthorizons.core.config.types.enums.EConfigEntryRelevantSide;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftSharedWrapper;
import com.seibel.distanthorizons.coreapi.ModInfo;
import com.seibel.distanthorizons.coreapi.util.StringUtil;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.swing.JOptionPane;
import org.apache.logging.log4j.Logger;

public class Config {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static ConfigCategory client = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Client.class)).build();
    private static boolean complicatedListenerSetupComplete = false;

    public static void completeDelayedSetup() {
        if (!complicatedListenerSetupComplete) {
            complicatedListenerSetupComplete = true;
            try {
                ThreadPresetConfigEventHandler.INSTANCE.setUiOnlyConfigValues();
                RenderQualityPresetConfigEventHandler.INSTANCE.setUiOnlyConfigValues();
                QuickRenderToggleConfigEventHandler.INSTANCE.setUiOnlyConfigValues();
                RenderCacheConfigEventHandler.getInstance();
            }
            catch (Exception e) {
                LOGGER.error("Unexpected exception when running config delayed UI setup. Error: [" + e.getMessage() + "].", (Throwable)e);
            }
        }
    }

    private static String getDefaultLevelKeyPrefix() {
        IMinecraftSharedWrapper mcWrapper = SingletonInjector.INSTANCE.get(IMinecraftSharedWrapper.class);
        if (!mcWrapper.isDedicatedServer() || mcWrapper.isWorldNew()) {
            return "";
        }
        return "server" + ThreadLocalRandom.current().nextInt(1, 1000);
    }

    static /* synthetic */ String access$200() {
        return Config.getDefaultLevelKeyPrefix();
    }

    public static class Client {
        public static ConfigEntry<Boolean> quickEnableRendering = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("If true, Distant Horizons will render LODs beyond the vanilla render distance.").setAppearance(EConfigEntryAppearance.ONLY_IN_GUI)).build();
        public static ConfigLinkedEntry quickLodChunkRenderDistance = new ConfigLinkedEntry(Advanced.Graphics.Quality.lodChunkRenderDistanceRadius);
        public static ConfigEntry<EDhApiQualityPreset> qualityPresetSetting = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiQualityPreset.MEDIUM)).comment("Changing this setting will modify a number of different settings that will change the \nvisual fidelity of the rendered LODs.\n\nHigher settings will improve the graphical quality while increasing GPU and memory use.\n").setAppearance(EConfigEntryAppearance.ONLY_IN_GUI)).addListener(RenderQualityPresetConfigEventHandler.INSTANCE).build();
        public static ConfigEntry<EDhApiThreadPreset> threadPresetSetting = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiThreadPreset.LOW_IMPACT)).comment("Changing this setting will modify a number of different settings that will change \nthe load that Distant Horizons is allowed to put on your CPU. \n\nHigher options will improve LOD generation and loading speed, \nbut will increase CPU load and may introduce stuttering.\n\nNote: on CPUs with 4 cores or less these settings will be less effective \n      and some settings will give similar results. \n").setAppearance(EConfigEntryAppearance.ONLY_IN_GUI)).addListener(ThreadPresetConfigEventHandler.INSTANCE).build();
        public static ConfigLinkedEntry quickEnableWorldGenerator = new ConfigLinkedEntry(Advanced.WorldGenerator.enableDistantGeneration);
        public static ConfigLinkedEntry quickLodCloudRendering = new ConfigLinkedEntry(Advanced.Graphics.GenericRendering.enableCloudRendering);
        public static ConfigEntry<Boolean> optionsButton = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).setAppearance(EConfigEntryAppearance.ONLY_IN_FILE)).comment("Should Distant Horizon's config button appear in the options screen next to fov slider?").build();
        public static ConfigCategory advanced = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Advanced.class)).build();

        public static class Advanced {
            public static ConfigCategory graphics = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Graphics.class)).build();
            public static ConfigCategory worldGenerator = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(WorldGenerator.class)).build();
            public static ConfigCategory multiplayer = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Multiplayer.class)).build();
            public static ConfigCategory lodBuilding = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(LodBuilding.class)).build();
            public static ConfigCategory multiThreading = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(MultiThreading.class)).build();
            public static ConfigCategory autoUpdater = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(AutoUpdater.class)).build();
            public static ConfigCategory logging = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Logging.class)).build();
            public static ConfigCategory debugging = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Debugging.class)).build();

            public static class Graphics {
                public static ConfigCategory quality = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Quality.class)).build();
                public static ConfigCategory fog = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Fog.class)).build();
                public static ConfigCategory ssao = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Ssao.class)).build();
                public static ConfigCategory noiseTextureSettings = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(NoiseTextureSettings.class)).build();
                public static ConfigCategory genericRendering = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(GenericRendering.class)).build();
                public static ConfigCategory advancedGraphics = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(AdvancedGraphics.class)).build();

                public static class Quality {
                    public static ConfigEntry<EDhApiMaxHorizontalResolution> maxHorizontalResolution = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiMaxHorizontalResolution.BLOCK)).comment("What is the maximum detail LODs should be drawn at? \nHigher settings will increase memory and GPU usage. \n\n" + (Object)((Object)EDhApiMaxHorizontalResolution.CHUNK) + ": render 1 LOD for each Chunk. \n" + (Object)((Object)EDhApiMaxHorizontalResolution.HALF_CHUNK) + ": render 4 LODs for each Chunk. \n" + (Object)((Object)EDhApiMaxHorizontalResolution.FOUR_BLOCKS) + ": render 16 LODs for each Chunk. \n" + (Object)((Object)EDhApiMaxHorizontalResolution.TWO_BLOCKS) + ": render 64 LODs for each Chunk. \n" + (Object)((Object)EDhApiMaxHorizontalResolution.BLOCK) + ": render 256 LODs for each Chunk (width of one block). \n\nLowest Quality: " + (Object)((Object)EDhApiMaxHorizontalResolution.CHUNK) + "\nHighest Quality: " + (Object)((Object)EDhApiMaxHorizontalResolution.BLOCK)).setPerformance(EConfigEntryPerformance.MEDIUM).build();
                    public static ConfigEntry<Integer> lodChunkRenderDistanceRadius = new ConfigEntry.Builder().setServersideShortName("renderDistanceRadius").setMinDefaultMax(32, 128, 4096).comment("The radius of the mod's render distance. (measured in chunks)\nOn server changes the distance players will receive real-time updates for, if enabled.\nNote for servers:\nThis setting does not prevent players from generating farther out.\nIf you want to limit performance impact, change rate limits\nand thread count/runtime ratio settings instead.\nIt also does not affect the visuals on clients.").setPerformance(EConfigEntryPerformance.HIGH).setSide(EConfigEntryRelevantSide.BOTH).build();
                    public static ConfigEntry<EDhApiVerticalQuality> verticalQuality = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiVerticalQuality.MEDIUM)).comment("This indicates how well LODs will represent \noverhangs, caves, floating islands, etc. \nHigher options will make the world more accurate, butwill increase memory and GPU usage. \n\nLowest Quality: " + (Object)((Object)EDhApiVerticalQuality.HEIGHT_MAP) + "\nHighest Quality: " + (Object)((Object)EDhApiVerticalQuality.EXTREME)).setPerformance(EConfigEntryPerformance.VERY_HIGH).addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                    @Deprecated
                    public static ConfigEntry<String> customVerticalQualityCsv = ((ConfigEntry.Builder)new ConfigEntry.Builder().set("16,8,4,3,3,3,3,3,3,3,1")).comment(" Each CSV value represents a single horizontal quality drop \nIE: \n- value 1 = detail level 0 \n- value 2 = detail level 1 \nThe last value will be used for all subsequent \ndetail levels. \nIf parsing fails this defaults to 1 (IE " + (Object)((Object)EDhApiVerticalQuality.HEIGHT_MAP) + "). \n").setPerformance(EConfigEntryPerformance.VERY_HIGH).addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                    public static ConfigEntry<EDhApiHorizontalQuality> horizontalQuality = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiHorizontalQuality.MEDIUM)).comment("This indicates how quickly LODs decrease in quality the further away they are. \nHigher settings will render higher quality fake chunks farther away, \nbut will increase memory and GPU usage.").setPerformance(EConfigEntryPerformance.MEDIUM).build();
                    public static ConfigEntry<EDhApiTransparency> transparency = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiTransparency.COMPLETE)).comment("How should LOD transparency be handled. \n\n" + (Object)((Object)EDhApiTransparency.COMPLETE) + ": LODs will render transparent. \n" + (Object)((Object)EDhApiTransparency.FAKE) + ": LODs will be opaque, but shaded to match the blocks underneath. \n" + (Object)((Object)EDhApiTransparency.DISABLED) + ": LODs will be opaque. \n").setPerformance(EConfigEntryPerformance.MEDIUM).addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                    public static ConfigEntry<EDhApiBlocksToAvoid> blocksToIgnore = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiBlocksToAvoid.NON_COLLIDING)).comment("What blocks shouldn't be rendered as LODs? \n\n" + (Object)((Object)EDhApiBlocksToAvoid.NONE) + ": Represent all blocks in the LODs \n" + (Object)((Object)EDhApiBlocksToAvoid.NON_COLLIDING) + ": Only represent solid blocks in the LODs (tall grass, torches, etc. won't count for a LOD's height) \n").setPerformance(EConfigEntryPerformance.NONE).addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                    public static ConfigEntry<Boolean> tintWithAvoidedBlocks = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("Should the blocks underneath avoided blocks gain the color of the avoided block? \n\nTrue: a red flower will tint the grass below it red. \nFalse: skipped blocks will not change color of surface below them. ").setPerformance(EConfigEntryPerformance.NONE).addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                }

                public static class Fog {
                    public static ConfigEntry<EDhApiFogDrawMode> drawMode = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiFogDrawMode.FOG_ENABLED)).comment("When should fog be drawn? \n\n" + (Object)((Object)EDhApiFogDrawMode.USE_OPTIFINE_SETTING) + ": Use whatever Fog setting Optifine is using.\nIf Optifine isn't installed this defaults to " + (Object)((Object)EDhApiFogDrawMode.FOG_ENABLED) + ". \n" + (Object)((Object)EDhApiFogDrawMode.FOG_ENABLED) + ": Never draw fog on the LODs \n" + (Object)((Object)EDhApiFogDrawMode.FOG_DISABLED) + ": Always draw fast fog on the LODs \n\nDisabling fog will improve GPU performance.").setPerformance(EConfigEntryPerformance.VERY_LOW).build();
                    public static ConfigEntry<EDhApiFogColorMode> colorMode = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiFogColorMode.USE_WORLD_FOG_COLOR)).comment("What color should fog use? \n\n" + (Object)((Object)EDhApiFogColorMode.USE_WORLD_FOG_COLOR) + ": Use the world's fog color. \n" + (Object)((Object)EDhApiFogColorMode.USE_SKY_COLOR) + ": Use the sky's color.").setPerformance(EConfigEntryPerformance.NONE).build();
                    public static ConfigEntry<Boolean> disableVanillaFog = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("Should Minecraft's fog be disabled? \n\nNote: Other mods may conflict with this setting.").build();
                    public static ConfigCategory advancedFog = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(AdvancedFog.class)).build();

                    public static class AdvancedFog {
                        private static final Double FOG_RANGE_MIN = 0.0;
                        private static final Double FOG_RANGE_MAX = Math.sqrt(2.0);
                        public static ConfigEntry<Double> farFogStart = new ConfigEntry.Builder<Double>().setMinDefaultMax(FOG_RANGE_MIN, 0.4, FOG_RANGE_MAX).comment("At what distance should the far fog start? \n\n0.0: Fog starts at the player's position. \n1.0: Fog starts at the closest edge of the vanilla render distance. \n1.414: Fog starts at the corner of the vanilla render distance.").build();
                        public static ConfigEntry<Double> farFogEnd = new ConfigEntry.Builder<Double>().setMinDefaultMax(FOG_RANGE_MIN, 1.0, FOG_RANGE_MAX).comment("Where should the far fog end? \n\n0.0: Fog ends at player's position.\n1.0: Fog ends at the closest edge of the vanilla render distance. \n1.414: Fog ends at the corner of the vanilla render distance.").build();
                        public static ConfigEntry<Double> farFogMin = new ConfigEntry.Builder<Double>().setMinDefaultMax(-5.0, 0.0, FOG_RANGE_MAX).comment("What is the minimum fog thickness? \n\n0.0: No fog. \n1.0: Fully opaque fog.").build();
                        public static ConfigEntry<Double> farFogMax = new ConfigEntry.Builder<Double>().setMinDefaultMax(FOG_RANGE_MIN, 1.0, 5.0).comment("What is the maximum fog thickness? \n\n0.0: No fog. \n1.0: Fully opaque fog.").build();
                        public static ConfigEntry<EDhApiFogFalloff> farFogFalloff = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiFogFalloff.EXPONENTIAL_SQUARED)).comment("How should the fog thickness should be calculated? \n\n" + (Object)((Object)EDhApiFogFalloff.LINEAR) + ": Linear based on distance (will ignore 'density')\n" + (Object)((Object)EDhApiFogFalloff.EXPONENTIAL) + ": 1/(e^(distance*density)) \n" + (Object)((Object)EDhApiFogFalloff.EXPONENTIAL_SQUARED) + ": 1/(e^((distance*density)^2)").build();
                        public static ConfigEntry<Double> farFogDensity = new ConfigEntry.Builder<Double>().setMinDefaultMax(0.01, 2.5, 50.0).comment("Used in conjunction with the Fog Falloff.").build();
                        public static ConfigCategory heightFog = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(HeightFog.class)).build();

                        static /* synthetic */ Double access$000() {
                            return FOG_RANGE_MIN;
                        }

                        static /* synthetic */ Double access$100() {
                            return FOG_RANGE_MAX;
                        }

                        public static class HeightFog {
                            public static ConfigEntry<EDhApiHeightFogMixMode> heightFogMixMode = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiHeightFogMixMode.BASIC)).comment("How should height effect the fog thickness? \nNote: height fog is combined with the other fog settings. \n\n" + (Object)((Object)EDhApiHeightFogMixMode.BASIC) + ": No special height fog effect. Fog is calculated based on camera distance \n" + (Object)((Object)EDhApiHeightFogMixMode.IGNORE_HEIGHT) + ": Ignore height completely. Fog is only calculated with horizontal distance \n" + (Object)((Object)EDhApiHeightFogMixMode.ADDITION) + ": heightFog + farFog \n" + (Object)((Object)EDhApiHeightFogMixMode.MAX) + ": max(heightFog, farFog) \n" + (Object)((Object)EDhApiHeightFogMixMode.MULTIPLY) + ": heightFog * farFog \n" + (Object)((Object)EDhApiHeightFogMixMode.INVERSE_MULTIPLY) + ": 1 - (1-heightFog) * (1-farFog) \n" + (Object)((Object)EDhApiHeightFogMixMode.LIMITED_ADDITION) + ": farFog + max(farFog, heightFog) \n" + (Object)((Object)EDhApiHeightFogMixMode.MULTIPLY_ADDITION) + ": farFog + farFog * heightFog \n" + (Object)((Object)EDhApiHeightFogMixMode.INVERSE_MULTIPLY_ADDITION) + ": farFog + 1 - (1-heightFog) * (1-farFog) \n" + (Object)((Object)EDhApiHeightFogMixMode.AVERAGE) + ": farFog*0.5 + heightFog*0.5 \n\nNote: height fog settings are ignored if '" + (Object)((Object)EDhApiHeightFogMixMode.BASIC) + "' or '" + (Object)((Object)EDhApiHeightFogMixMode.IGNORE_HEIGHT) + "' are selected.").build();
                            public static ConfigEntry<EDhApiHeightFogMode> heightFogMode = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiHeightFogMode.ABOVE_AND_BELOW_CAMERA)).comment("Where should the height fog start? \n\n" + (Object)((Object)EDhApiHeightFogMode.ABOVE_CAMERA) + ": Height fog starts at the camera and goes towards the sky \n" + (Object)((Object)EDhApiHeightFogMode.BELOW_CAMERA) + ": Height fog starts at the camera and goes towards the void \n" + (Object)((Object)EDhApiHeightFogMode.ABOVE_AND_BELOW_CAMERA) + ": Height fog starts from the camera to goes towards both the sky and void \n" + (Object)((Object)EDhApiHeightFogMode.ABOVE_SET_HEIGHT) + ": Height fog starts from a set height and goes towards the sky \n" + (Object)((Object)EDhApiHeightFogMode.BELOW_SET_HEIGHT) + ": Height fog starts from a set height and goes towards the void \n" + (Object)((Object)EDhApiHeightFogMode.ABOVE_AND_BELOW_SET_HEIGHT) + ": Height fog starts from a set height and goes towards both the sky and void").build();
                            public static ConfigEntry<Double> heightFogBaseHeight = new ConfigEntry.Builder<Double>().setMinDefaultMax(-4096.0, 70.0, 4096.0).comment("If the height fog is calculated around a set height, what is that height position?").build();
                            public static ConfigEntry<Double> heightFogStart = new ConfigEntry.Builder<Double>().setMinDefaultMax(AdvancedFog.access$000(), 0.0, AdvancedFog.access$100()).comment("Should the start of the height fog be offset? \n\n0.0: Fog start with no offset.\n1.0: Fog start with offset of the entire world's height. (Includes depth)").build();
                            public static ConfigEntry<Double> heightFogEnd = new ConfigEntry.Builder<Double>().setMinDefaultMax(AdvancedFog.access$000(), 1.0, AdvancedFog.access$100()).comment("Should the end of the height fog be offset? \n\n0.0: Fog end with no offset.\n1.0: Fog end with offset of the entire world's height. (Include depth)").build();
                            public static ConfigEntry<Double> heightFogMin = new ConfigEntry.Builder<Double>().setMinDefaultMax(-5.0, 0.0, AdvancedFog.access$100()).comment("What is the minimum fog thickness? \n\n0.0: No fog. \n1.0: Fully opaque fog.").build();
                            public static ConfigEntry<Double> heightFogMax = new ConfigEntry.Builder<Double>().setMinDefaultMax(AdvancedFog.access$000(), 1.0, 5.0).comment("What is the maximum fog thickness? \n\n0.0: No fog. \n1.0: Fully opaque fog.").build();
                            public static ConfigEntry<EDhApiFogFalloff> heightFogFalloff = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiFogFalloff.EXPONENTIAL_SQUARED)).comment("How should the height fog thickness should be calculated? \n\n" + (Object)((Object)EDhApiFogFalloff.LINEAR) + ": Linear based on height (will ignore 'density')\n" + (Object)((Object)EDhApiFogFalloff.EXPONENTIAL) + ": 1/(e^(height*density)) \n" + (Object)((Object)EDhApiFogFalloff.EXPONENTIAL_SQUARED) + ": 1/(e^((height*density)^2)").build();
                            public static ConfigEntry<Double> heightFogDensity = new ConfigEntry.Builder<Double>().setMinDefaultMax(0.01, 2.5, 50.0).comment("What is the height fog's density?").build();
                        }
                    }
                }

                public static class Ssao {
                    public static ConfigEntry<Boolean> enabled = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("Enable Screen Space Ambient Occlusion").setPerformance(EConfigEntryPerformance.MEDIUM).build();
                    public static ConfigEntry<Integer> sampleCount = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)6)).comment("Determines how many points in space are sampled for the occlusion test. \nHigher numbers will improve quality and reduce banding, but will increase GPU load.").setPerformance(EConfigEntryPerformance.MEDIUM).build();
                    public static ConfigEntry<Double> radius = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)4.0)).comment("Determines the radius Screen Space Ambient Occlusion is applied, measured in blocks.").setPerformance(EConfigEntryPerformance.NONE).build();
                    public static ConfigEntry<Double> strength = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)0.2)).comment("Determines how dark the Screen Space Ambient Occlusion effect will be.").setPerformance(EConfigEntryPerformance.NONE).build();
                    public static ConfigEntry<Double> bias = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)0.02)).comment("Increasing the value can reduce banding at the cost of reducing the strength of the effect.").setPerformance(EConfigEntryPerformance.NONE).build();
                    public static ConfigEntry<Double> minLight = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)0.25)).comment("Determines how dark the occlusion shadows can be. \n0 = totally black at the corners \n1 = no shadow").setPerformance(EConfigEntryPerformance.NONE).build();
                    public static ConfigEntry<Integer> blurRadius = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)2)).comment("The radius, measured in pixels, that blurring is calculated for the SSAO. \nHigher numbers will reduce banding at the cost of GPU performance.").setPerformance(EConfigEntryPerformance.HIGH).build();
                }

                public static class NoiseTextureSettings {
                    public static ConfigEntry<Boolean> noiseEnabled = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("Should a noise texture be applied to LODs? \n\nThis is done to simulate textures and make the LODs appear more detailed. \n").build();
                    public static ConfigEntry<Integer> noiseSteps = new ConfigEntry.Builder<Integer>().setMinDefaultMax(1, 4, null).comment("How many steps of noise should be applied to LODs?").build();
                    public static ConfigEntry<Double> noiseIntensity = new ConfigEntry.Builder<Double>().setMinDefaultMax(0.0, 5.0, 100.0).comment("How intense should the noise should be?").build();
                    public static ConfigEntry<Integer> noiseDropoff = new ConfigEntry.Builder<Integer>().setMinDefaultMax(0, 1024, null).comment("Defines how far should the noise texture render before it fades away. (in blocks) \nSet to 0 to disable noise from fading away \n").build();
                }

                public static class GenericRendering {
                    public static ConfigEntry<Boolean> enableRendering = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("If true non terrain objects will be rendered in DH's terrain. \nThis includes beacon beams and clouds. \n").build();
                    public static ConfigEntry<Boolean> enableBeaconRendering = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("If true LOD beacon beams will be rendered. \n").build();
                    public static ConfigEntry<Boolean> enableCloudRendering = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("If true LOD clouds will be rendered. \n").build();
                    public static ConfigEntry<Boolean> enableInstancedRendering = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("Can be disabled to use much slower but more compatible direct rendering. \nDisabling this can be used to fix some crashes on Mac. \n").build();
                }

                public static class AdvancedGraphics {
                    public static ConfigEntry<Double> overdrawPrevention = new ConfigEntry.Builder<Double>().setMinDefaultMax(0.0, 0.4, 1.0).comment("Determines how far from the camera Distant Horizons will start rendering. \nMeasured as a percentage of the vanilla render distance.\n\nHigher values will prevent LODs from rendering behind vanilla blocks at a higher distance,\nbut may cause holes to appear in the LODs. \nHoles are most likely to appear when flying through unloaded terrain. \n\nIncreasing the vanilla render distance increases the effectiveness of this setting.").setPerformance(EConfigEntryPerformance.NONE).build();
                    public static ConfigEntry<Double> brightnessMultiplier = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)1.0)).comment("How bright LOD colors are. \n\n0 = black \n1 = normal \n2 = near white").addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                    public static ConfigEntry<Double> saturationMultiplier = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)1.0)).comment("How saturated LOD colors are. \n\n0 = black and white \n1 = normal \n2 = very saturated").addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                    public static ConfigEntry<Boolean> enableCaveCulling = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("If enabled caves will be culled \n\nNOTE: This feature is under development and \n it is VERY experimental! Please don't report \n any issues related to this feature. \n\nAdditional Info: Currently this cull all faces \n with skylight value of 0 in dimensions that \n does not have a ceiling.").addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                    public static ConfigEntry<Integer> caveCullingHeight = new ConfigEntry.Builder<Integer>().setMinDefaultMax(-4096, 60, 4096).comment("At what Y value should cave culling start? \nLower this value if you get walls for areas with 0 light.").addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                    public static ConfigEntry<Integer> earthCurveRatio = new ConfigEntry.Builder<Integer>().setMinDefaultMax(0, 0, 5000).comment("This is the earth size ratio when applying the curvature shader effect. \nNote: Enabling this feature may cause rendering bugs. \n\n0 = flat/disabled \n1 = 1 to 1 (6,371,000 blocks) \n100 = 1 to 100 (63,710 blocks) \n10000 = 1 to 10000 (637.1 blocks) \n\nNote: Due to current limitations, the min value is 50 \nand the max value is 5000. Any values outside this range \nwill be set to 0 (disabled).").addListener(WorldCurvatureConfigEventHandler.INSTANCE).build();
                    public static ConfigEntry<Double> lodBias = new ConfigEntry.Builder<Double>().setMinDefaultMax(0.0, 0.0, null).comment("What the value should vanilla Minecraft's texture LodBias be? \nIf set to 0 the mod wont overwrite vanilla's default (which so happens to also be 0)").build();
                    public static ConfigEntry<EDhApiLodShading> lodShading = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiLodShading.AUTO)).comment("How should LODs be shaded? \n\n" + (Object)((Object)EDhApiLodShading.AUTO) + ": Uses the same side shading as vanilla Minecraft blocks. \n" + (Object)((Object)EDhApiLodShading.ENABLED) + ": Simulates Minecraft's block shading for LODs. \n              Can be used to force LOD shading when using some shaders. \n" + (Object)((Object)EDhApiLodShading.DISABLED) + ": All LOD sides will be rendered with the same brightness. \n").setPerformance(EConfigEntryPerformance.NONE).addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                    public static ConfigEntry<Boolean> disableFrustumCulling = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("If false LODs outside the player's camera \naren't drawn, increasing GPU performance. \n\nIf true all LODs are drawn, even those behind \nthe player's camera, decreasing GPU performance. \n\nDisable this if you see LODs disappearing at the corners of your vision.").build();
                    public static ConfigEntry<Boolean> disableShadowPassFrustumCulling = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("Identical to the other frustum culling option\nonly used when a shader mod is present using the DH API\nand the shadow pass is being rendered.\n\nDisable this if shadows render incorrectly.").build();
                    public static ConfigEntry<EDhApiGrassSideRendering> grassSideRendering = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiGrassSideRendering.FADE_TO_DIRT)).comment("How should the sides and bottom of grass block LODs render? \n\n" + (Object)((Object)EDhApiGrassSideRendering.AS_GRASS) + ": all sides of dirt LOD's render using the top (green) color. \n" + (Object)((Object)EDhApiGrassSideRendering.FADE_TO_DIRT) + ": sides fade from grass to dirt. \n" + (Object)((Object)EDhApiGrassSideRendering.AS_DIRT) + ": sides render entirely as dirt. \n").setPerformance(EConfigEntryPerformance.NONE).addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                    public static ConfigEntry<Boolean> disableBeaconDistanceCulling = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("If true all beacons near the camera won't be drawn to prevent vanilla overdraw. \nIf false all beacons will be rendered. \n\nGenerally this should be left as false. It's main purpose is for debugging\nbeacon updating/rendering.\n").build();
                }
            }

            public static class WorldGenerator {
                public static ConfigEntry<Boolean> enableDistantGeneration = ((ConfigEntry.Builder)new ConfigEntry.Builder().setServersideShortName("enableDistantGeneration").set((Object)true)).comment(" Should Distant Horizons slowly generate LODs \n outside the vanilla render distance?").setSide(EConfigEntryRelevantSide.BOTH).build();
                public static ConfigEntry<EDhApiDistantGeneratorMode> distantGeneratorMode = ((ConfigEntry.Builder)new ConfigEntry.Builder().setServersideShortName("distantGeneratorMode").set((Object)EDhApiDistantGeneratorMode.FEATURES)).comment("How detailed should LODs be generated outside the vanilla render distance? \n\n" + (Object)((Object)EDhApiDistantGeneratorMode.PRE_EXISTING_ONLY) + " \nOnly create LOD data for already generated chunks. \n\n\n" + (Object)((Object)EDhApiDistantGeneratorMode.SURFACE) + " \nGenerate the world surface, \nthis does NOT include trees, \nor structures. \n\n" + (Object)((Object)EDhApiDistantGeneratorMode.FEATURES) + " \nGenerate everything except structures. \nWARNING: This may cause world generator bugs or instability when paired with certain world generator mods. \n").setSide(EConfigEntryRelevantSide.BOTH).build();
                public static ConfigEntry<Integer> worldGenerationTimeoutLengthInSeconds = new ConfigEntry.Builder().setServersideShortName("worldGenerationTimeout").setMinDefaultMax(5, 180, 600).comment("How long should a world generator thread run for before timing out? \nNote: If you are experiencing timeout errors it is better to lower your CPU usage first \nvia the thread config before changing this value. \n").setSide(EConfigEntryRelevantSide.BOTH).build();
            }

            public static class Multiplayer {
                public static ConfigEntry<EDhApiServerFolderNameMode> serverFolderNameMode = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiServerFolderNameMode.NAME_ONLY)).comment("How should multiplayer save folders should be named? \n\n" + (Object)((Object)EDhApiServerFolderNameMode.NAME_ONLY) + ": Example: \"Minecraft Server\" \n" + (Object)((Object)EDhApiServerFolderNameMode.IP_ONLY) + ": Example: \"192.168.1.40\" \n" + (Object)((Object)EDhApiServerFolderNameMode.NAME_IP) + ": Example: \"Minecraft Server IP 192.168.1.40\" \n" + (Object)((Object)EDhApiServerFolderNameMode.NAME_IP_PORT) + ": Example: \"Minecraft Server IP 192.168.1.40:25565\"" + (Object)((Object)EDhApiServerFolderNameMode.NAME_IP_PORT_MC_VERSION) + ": Example: \"Minecraft Server IP 192.168.1.40:25565 GameVersion 1.16.5\"").build();
                public static ConfigEntry<Double> multiverseSimilarityRequiredPercent = new ConfigEntry.Builder<Double>().setMinDefaultMax(0.0, 0.0, 1.0).comment("AKA: Multiverse support. \n\nWhen matching levels (dimensions) of the same type (overworld, nether, etc.) the \nloaded chunks must be at least this percent the same \nin order to be considered the same world. \n\nNote: If you use portals to enter a dimension at two \ndifferent locations the system will think the dimension \nit is two different levels. \n\n1.0 (100%) the chunks must be identical. \n0.5 (50%)  the chunks must be half the same. \n0.0 (0%)   disables multi-dimension support, \n            only one world will be used per dimension. \n\nIf multiverse support is needed start with a value of 0.2 \nand tweak the sensitivity from there.Lower values mean the matching is less strict.\nHigher values mean the matching is more strict.\n").build();
                public static ConfigCategory serverNetworking = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(ServerNetworking.class)).build();

                public static class ServerNetworking {
                    public static ConfigUIComment generalSectionNote = new ConfigUIComment();
                    public static ConfigEntry<Boolean> enableServerNetworking = ((ConfigEntry.Builder)new ConfigEntry.Builder().setServersideShortName("enableServerNetworking").set((Object)true)).comment("WARNING!\nServer-client networking is not yet fully implemented!\nBoth the server and client must be running the server-side fork with this option enabled\nfor Distant Horizons data to be transceived.\n\nIf true, the server and client will attempt to communicate to transceive Distant Horizons data.\nThis allows for further distant generation and LOD updates on all clients.\n\nThis should only be used on trusted servers with trusted players!\n").setSide(EConfigEntryRelevantSide.BOTH).build();
                    public static ConfigEntry<Boolean> sendLevelKeys = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().setServersideShortName("sendLevelKeys").setAppearance(EConfigEntryAppearance.ONLY_IN_FILE)).set((Object)true)).comment("Makes the server send level keys for each world.\nDisable this if you use alternative ways to send level keys.\n").setSide(EConfigEntryRelevantSide.BOTH).build();
                    public static ConfigEntry<String> levelKeyPrefix = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().setServersideShortName("levelKeyPrefix").setAppearance(EConfigEntryAppearance.ONLY_IN_FILE)).set(Config.access$200())).comment("Prefix of the level keys sent to the clients.\nShould be set to a unique value for each backend server behind a proxy,\nor empty if you don't use a proxy.\n").setSide(EConfigEntryRelevantSide.BOTH).build();
                    public static ConfigUIComment generationSectionNote = new ConfigUIComment();
                    public static ConfigEntry<Integer> generationRequestRateLimit = new ConfigEntry.Builder().setServersideShortName("generationRequestRateLimit").setMinDefaultMax(1, 20, 100).comment("How many LOD generation requests per second should a client send? \nAlso limits the amount of player's requests allowed to stay in the server's queue.").setSide(EConfigEntryRelevantSide.BOTH).build();
                    public static ConfigUIComment realTimeUpdatesSectionNote = new ConfigUIComment();
                    public static ConfigEntry<Boolean> enableRealTimeUpdates = ((ConfigEntry.Builder)new ConfigEntry.Builder().setServersideShortName("enableRealTimeUpdates").set((Object)false)).comment("If true, the client will receive real-time LOD updates for chunks outside the client's render distance.").setSide(EConfigEntryRelevantSide.BOTH).build();
                    public static ConfigUIComment syncOnLoginSectionNote = new ConfigUIComment();
                    public static ConfigEntry<Boolean> synchronizeOnLogin = ((ConfigEntry.Builder)new ConfigEntry.Builder().setServersideShortName("synchronizeOnLogin").set((Object)false)).comment("If true, clients will receive updated LODs on join if any changes occurred since last join.").setSide(EConfigEntryRelevantSide.BOTH).build();
                    public static ConfigEntry<Integer> syncOnLoginRateLimit = new ConfigEntry.Builder().setServersideShortName("syncOnLoginRateLimit").setMinDefaultMax(1, 50, 100).comment("How many LOD sync requests per second should a client send? \nAlso limits the amount of player's requests allowed to stay in the server's queue.").setSide(EConfigEntryRelevantSide.BOTH).build();
                }
            }

            public static class LodBuilding {
                @Deprecated
                public static ConfigEntry<Integer> minTimeBetweenChunkUpdatesInSeconds = ((ConfigEntry.Builder)new ConfigEntry.Builder().setServersideShortName("minTimeBetweenChunkUpdates").setMinDefaultMax(0, 1, 60).setAppearance(EConfigEntryAppearance.ONLY_IN_API)).comment("Determines how long must pass between LOD chunk updates before another. \nupdate can occur\n\nIncreasing this value will reduce CPU load but may may cause \nLODs to become outdated more frequently or for longer. \n").build();
                public static ConfigEntry<Boolean> disableUnchangedChunkCheck = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("Normally DH will attempt to skip creating LODs for chunks it's already seen\nand that haven't changed.\n\nHowever sometimes that logic incorrecly prevents LODs from being updated.\nDisabling this check may fix issues where LODs aren't updated after\nblocks have been changed.\n").build();
                @Deprecated
                public static ConfigEntry<Boolean> onlyUseDhLightingEngine = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).setAppearance(EConfigEntryAppearance.ONLY_IN_API)).comment("If false LODs will be lit by Minecraft's lighting engine when possible \nand fall back to the DH lighting engine only when necessary. \n\nIf true LODs will only be lit using Distant Horizons' lighting engine. \n\nGenerally it is best to leave this disabled and should only be enabled \nif there are lighting issues or for debugging. \n").build();
                public static ConfigEntry<Boolean> pullLightingForPregeneratedChunks = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("If true LOD generation for pre-existing chunks will attempt to pull the lighting data \nsaved in Minecraft's Region files. \nIf false DH will pull in chunks without lighting and re-light them. \n \nSetting this to true will result in faster LOD generation \nfor already generated worlds, but is broken by most lighting mods. \n \nSet this to false if LODs are black. \n").build();
                public static ConfigEntry<EDhApiDataCompressionMode> dataCompression = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiDataCompressionMode.LZMA2)).comment("What algorithm should be used to compress new LOD data? \nThis setting will only affect new or updated LOD data, \nany data already generated when this setting is changed will be\nunaffected until it needs to be re-written to the database.\n\n" + (Object)((Object)EDhApiDataCompressionMode.UNCOMPRESSED) + " \nShould only be used for testing, is worse in every way vs [" + (Object)((Object)EDhApiDataCompressionMode.LZ4) + "].\nExpected Compression Ratio: 1.0\nEstimated average DTO read speed: 1.64 milliseconds\nEstimated average DTO write speed: 12.44 milliseconds\n\n" + (Object)((Object)EDhApiDataCompressionMode.LZ4) + " \nA good option if you're CPU limited and have plenty of hard drive space.\nExpected Compression Ratio: 0.36\nEstimated average DTO read speed: 1.85 ms\nEstimated average DTO write speed: 9.46 ms\n\n" + (Object)((Object)EDhApiDataCompressionMode.LZMA2) + " \nSlow but very good compression.\nExpected Compression Ratio: 0.14\nEstimated average DTO read speed: 11.89 ms\nEstimated average DTO write speed: 192.01 ms\n").build();
                public static ConfigEntry<EDhApiWorldCompressionMode> worldCompression = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiWorldCompressionMode.VISUALLY_EQUAL)).comment("How should block data be compressed when creating LOD data? \nThis setting will only affect new or updated LOD data, \nany data already generated when this setting is changed will be\nunaffected until it is modified or re-loaded.\n\n" + (Object)((Object)EDhApiWorldCompressionMode.MERGE_SAME_BLOCKS) + " \nEvery block/biome change is recorded in the database. \nThis is what DH 2.0 and 2.0.1 all used by default and will store a lot of data. \nExpected Compression Ratio: 1.0\n\n" + (Object)((Object)EDhApiWorldCompressionMode.VISUALLY_EQUAL) + " \nOnly visible block/biome changes are recorded in the database. \nHidden blocks (IE ores) are ignored.  \nExpected Compression Ratio: 0.7\n").build();
                public static ConfigEntry<String> ignoredRenderBlockCsv = ((ConfigEntry.Builder)new ConfigEntry.Builder().set("minecraft:barrier,minecraft:structure_void,minecraft:light,minecraft:tripwire,minecraft:brown_mushroom")).comment("A comma separated list of block resource locations that won't be rendered by DH. \nNote: air is always included in this list. \n").build();
                public static ConfigEntry<String> ignoredRenderCaveBlockCsv = ((ConfigEntry.Builder)new ConfigEntry.Builder().set("minecraft:glow_lichen,minecraft:rail,minecraft:water,minecraft:lava,minecraft:bubble_column")).comment("A comma separated list of block resource locations that shouldn't be rendered \nif they are in a 0 sky light underground area. \nNote: air is always included in this list. \n").build();

                static {
                    ignoredRenderBlockCsv.addListener(new ConfigChangeListener<String>(ignoredRenderBlockCsv, blockCsv -> {
                        IWrapperFactory wrapperFactory = SingletonInjector.INSTANCE.get(IWrapperFactory.class);
                        if (wrapperFactory != null) {
                            wrapperFactory.resetRendererIgnoredBlocksSet();
                            DhApi.Delayed.renderProxy.clearRenderDataCache();
                        }
                    }));
                    ignoredRenderCaveBlockCsv.addListener(new ConfigChangeListener<String>(ignoredRenderCaveBlockCsv, blockCsv -> {
                        IWrapperFactory wrapperFactory = SingletonInjector.INSTANCE.get(IWrapperFactory.class);
                        if (wrapperFactory != null) {
                            wrapperFactory.resetRendererIgnoredCaveBlocks();
                            DhApi.Delayed.renderProxy.clearRenderDataCache();
                        }
                    }));
                }
            }

            public static class MultiThreading {
                public static final String THREAD_NOTE = "Multi-threading Note: \nIf the total thread count in Distant Horizon's config is more threads than your CPU has cores, \nCPU performance may suffer if Distant Horizons has a lot to load or generate. \nThis can be an issue when first loading into a world, when flying, and/or when generating new terrain.";
                public static final String THREAD_RUN_TIME_RATIO_NOTE = "If this value is less than 1.0, it will be treated as a percentage \nof time each thread can run before going idle. \n\nThis can be used to reduce CPU usage if the thread count \nis already set to 1 for the given option, or more finely \ntune CPU performance.";
                public static final ConfigEntry<Integer> numberOfWorldGenerationThreads = new ConfigEntry.Builder().setServersideShortName("numberOfWorldGenerationThreads").setMinDefaultMax(1, ThreadPresetConfigEventHandler.getWorldGenDefaultThreadCount(), Runtime.getRuntime().availableProcessors()).comment("How many threads should be used when generating LOD \nchunks outside the normal render distance? \n\nIf you experience stuttering when generating distant LODs, \ndecrease this number. \nIf you want to increase LOD \ngeneration speed, increase this number. \n\nMulti-threading Note: \nIf the total thread count in Distant Horizon's config is more threads than your CPU has cores, \nCPU performance may suffer if Distant Horizons has a lot to load or generate. \nThis can be an issue when first loading into a world, when flying, and/or when generating new terrain.").setSide(EConfigEntryRelevantSide.BOTH).build();
                public static final ConfigEntry<Double> runTimeRatioForWorldGenerationThreads = new ConfigEntry.Builder().setServersideShortName("runTimeRatioForWorldGenerationThreads").setMinDefaultMax(0.01, ThreadPresetConfigEventHandler.getWorldGenDefaultRunTimeRatio(), 1.0).comment("If this value is less than 1.0, it will be treated as a percentage \nof time each thread can run before going idle. \n\nThis can be used to reduce CPU usage if the thread count \nis already set to 1 for the given option, or more finely \ntune CPU performance.").setSide(EConfigEntryRelevantSide.BOTH).build();
                public static final ConfigEntry<Integer> numberOfFileHandlerThreads = new ConfigEntry.Builder().setServersideShortName("numberOfFileHandlerThreads").setMinDefaultMax(1, ThreadPresetConfigEventHandler.getFileHandlerDefaultThreadCount(), Runtime.getRuntime().availableProcessors()).comment("How many threads should be used when reading/writing LOD data to/from disk? \n\nIncreasing this number will cause LODs to load in faster, \nbut may cause lag when loading a new world or when \nquickly flying through existing LODs. \n\nMulti-threading Note: \nIf the total thread count in Distant Horizon's config is more threads than your CPU has cores, \nCPU performance may suffer if Distant Horizons has a lot to load or generate. \nThis can be an issue when first loading into a world, when flying, and/or when generating new terrain.").setSide(EConfigEntryRelevantSide.BOTH).build();
                public static final ConfigEntry<Double> runTimeRatioForFileHandlerThreads = new ConfigEntry.Builder().setServersideShortName("runTimeRatioForFileHandlerThreads").setMinDefaultMax(0.01, ThreadPresetConfigEventHandler.getFileHandlerDefaultRunTimeRatio(), 1.0).comment("If this value is less than 1.0, it will be treated as a percentage \nof time each thread can run before going idle. \n\nThis can be used to reduce CPU usage if the thread count \nis already set to 1 for the given option, or more finely \ntune CPU performance.").setSide(EConfigEntryRelevantSide.BOTH).build();
                public static final ConfigEntry<Integer> numberOfUpdatePropagatorThreads = new ConfigEntry.Builder<Integer>().setMinDefaultMax(1, ThreadPresetConfigEventHandler.getUpdatePropagatorDefaultThreadCount(), Runtime.getRuntime().availableProcessors()).comment("How many threads should be used when applying LOD updates? \nAn LOD update is the operation of down-sampling a high detail LOD \ninto a lower detail one.\n\nThis config can have a much higher number of threads \nassigned and much lower run time ratio vs other thread pools \nbecause the amount of time any particular thread may run is relatively low.\n\nThis is because LOD updating only only partially thread safe, \nso between 40% and 60% of the time a given thread may end up \nwaiting on another thread to finish updating the same LOD it also wants\nto work on.\n\nMulti-threading Note: \nIf the total thread count in Distant Horizon's config is more threads than your CPU has cores, \nCPU performance may suffer if Distant Horizons has a lot to load or generate. \nThis can be an issue when first loading into a world, when flying, and/or when generating new terrain.").build();
                public static final ConfigEntry<Double> runTimeRatioForUpdatePropagatorThreads = new ConfigEntry.Builder<Double>().setMinDefaultMax(0.01, ThreadPresetConfigEventHandler.getUpdatePropagatorDefaultRunTimeRatio(), 1.0).comment("If this value is less than 1.0, it will be treated as a percentage \nof time each thread can run before going idle. \n\nThis can be used to reduce CPU usage if the thread count \nis already set to 1 for the given option, or more finely \ntune CPU performance.").build();
                public static final ConfigEntry<Integer> numberOfLodBuilderThreads = new ConfigEntry.Builder().setServersideShortName("numberOfLodBuilderThreads").setMinDefaultMax(1, ThreadPresetConfigEventHandler.getLodBuilderDefaultThreadCount(), Runtime.getRuntime().availableProcessors()).comment("How many threads should be used when building LODs? \n\nThese threads run when terrain is generated, when\ncertain graphics settings are changed, and when moving around the world. \n\nMulti-threading Note: \nIf the total thread count in Distant Horizon's config is more threads than your CPU has cores, \nCPU performance may suffer if Distant Horizons has a lot to load or generate. \nThis can be an issue when first loading into a world, when flying, and/or when generating new terrain.").setSide(EConfigEntryRelevantSide.BOTH).build();
                public static final ConfigEntry<Double> runTimeRatioForLodBuilderThreads = new ConfigEntry.Builder().setServersideShortName("runTimeRatioForLodBuilderThreads").setMinDefaultMax(0.01, ThreadPresetConfigEventHandler.getLodBuilderDefaultRunTimeRatio(), 1.0).comment("If this value is less than 1.0, it will be treated as a percentage \nof time each thread can run before going idle. \n\nThis can be used to reduce CPU usage if the thread count \nis already set to 1 for the given option, or more finely \ntune CPU performance.").setSide(EConfigEntryRelevantSide.BOTH).build();
                public static final ConfigEntry<Boolean> enableLodBuilderThreadLimiting = ((ConfigEntry.Builder)new ConfigEntry.Builder().setServersideShortName("enableLodBuilderThreadLimiting").set((Object)true)).comment("Should only be disabled if deadlock occurs and LODs refuse to update. \nThis will cause CPU usage to drastically increase for the Lod Builder threads. \n\nNote that if deadlock did occur restarting MC may be necessary to stop the locked threads. \n").setSide(EConfigEntryRelevantSide.BOTH).build();
                public static final ConfigEntry<Integer> numberOfNetworkCompressionThreads = new ConfigEntry.Builder().setServersideShortName("numberOfNetworkCompressionThreads").setMinDefaultMax(1, ThreadPresetConfigEventHandler.getNetworkCompressionDefaultThreadCount(), Runtime.getRuntime().availableProcessors()).comment("How many threads should be used when (de)compressing LODs \nthat are received/sent over the network?\n\nThis pool doesn't do anything in singleplayer or when connected \nto a server that doesn't support DH networking. \n\nMulti-threading Note: \nIf the total thread count in Distant Horizon's config is more threads than your CPU has cores, \nCPU performance may suffer if Distant Horizons has a lot to load or generate. \nThis can be an issue when first loading into a world, when flying, and/or when generating new terrain.").setSide(EConfigEntryRelevantSide.BOTH).build();
                public static final ConfigEntry<Double> runTimeRatioForNetworkCompressionThreads = new ConfigEntry.Builder().setServersideShortName("runTimeRatioForNetworkCompressionThreads").setMinDefaultMax(0.01, ThreadPresetConfigEventHandler.getNetworkCompressionDefaultRunTimeRatio(), 1.0).comment("If this value is less than 1.0, it will be treated as a percentage \nof time each thread can run before going idle. \n\nThis can be used to reduce CPU usage if the thread count \nis already set to 1 for the given option, or more finely \ntune CPU performance.").build();
            }

            public static class AutoUpdater {
                public static ConfigEntry<Boolean> enableAutoUpdater = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)(!SingletonInjector.INSTANCE.get(IMinecraftSharedWrapper.class).getInstallationDirectory().getName().equals("run") ? 1 : 0))).comment("Automatically check for updates on game launch?").build();
                public static ConfigEntry<Boolean> enableSilentUpdates = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("Should Distant Horizons silently, automatically download and install new versions?").build();
                public static ConfigEntry<EDhApiUpdateBranch> updateBranch = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiUpdateBranch.AUTO)).comment("If DH should use the nightly (provided by Gitlab), or stable (provided by Modrinth) build. \nIf [" + (Object)((Object)EDhApiUpdateBranch.AUTO) + "] is selected DH will update to new stable releases if the current jar is a stable jar \nand will update to new nightly builds if the current jar is a nightly jar (IE the version number ends in '-dev').").build();
            }

            public static class Logging {
                public static ConfigEntry<EDhApiLoggerMode> logWorldGenEvent = ((ConfigEntry.Builder)new ConfigEntry.Builder().setServersideShortName("logWorldGenEvent").set((Object)EDhApiLoggerMode.LOG_ERROR_TO_CHAT_AND_INFO_TO_FILE)).comment("If enabled, the mod will log information about the world generation process. \nThis can be useful for debugging.").setSide(EConfigEntryRelevantSide.BOTH).build();
                public static ConfigEntry<EDhApiLoggerMode> logWorldGenPerformance = ((ConfigEntry.Builder)new ConfigEntry.Builder().setServersideShortName("logWorldGenPerformance").set((Object)EDhApiLoggerMode.LOG_ERROR_TO_CHAT_AND_INFO_TO_FILE)).comment("If enabled, the mod will log performance about the world generation process. \nThis can be useful for debugging.").setSide(EConfigEntryRelevantSide.BOTH).build();
                public static ConfigEntry<EDhApiLoggerMode> logWorldGenLoadEvent = ((ConfigEntry.Builder)new ConfigEntry.Builder().setServersideShortName("logWorldGenPerformance").set((Object)EDhApiLoggerMode.LOG_ERROR_TO_CHAT_AND_INFO_TO_FILE)).comment("If enabled, the mod will log information about the world generation process. \nThis can be useful for debugging.").setSide(EConfigEntryRelevantSide.BOTH).build();
                public static ConfigEntry<EDhApiLoggerMode> logLodBuilderEvent = ((ConfigEntry.Builder)new ConfigEntry.Builder().setServersideShortName("logLodBuilderEvent").set((Object)EDhApiLoggerMode.LOG_ERROR_TO_CHAT_AND_INFO_TO_FILE)).comment("If enabled, the mod will log information about the LOD generation process. \nThis can be useful for debugging.").setSide(EConfigEntryRelevantSide.BOTH).build();
                public static ConfigEntry<EDhApiLoggerMode> logRendererBufferEvent = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiLoggerMode.LOG_ERROR_TO_CHAT_AND_INFO_TO_FILE)).comment("If enabled, the mod will log information about the renderer buffer process. \nThis can be useful for debugging.").build();
                public static ConfigEntry<EDhApiLoggerMode> logRendererGLEvent = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiLoggerMode.LOG_ERROR_TO_CHAT_AND_INFO_TO_FILE)).comment("If enabled, the mod will log information about the renderer OpenGL process. \nThis can be useful for debugging.").build();
                public static ConfigEntry<EDhApiLoggerMode> logFileReadWriteEvent = ((ConfigEntry.Builder)new ConfigEntry.Builder().setServersideShortName("logFileReadWriteEvent").set((Object)EDhApiLoggerMode.LOG_ERROR_TO_CHAT_AND_INFO_TO_FILE)).comment("If enabled, the mod will log information about file read/write operations. \nThis can be useful for debugging.").setSide(EConfigEntryRelevantSide.BOTH).build();
                public static ConfigEntry<EDhApiLoggerMode> logFileSubDimEvent = ((ConfigEntry.Builder)new ConfigEntry.Builder().setServersideShortName("logFileSubDimEvent").set((Object)EDhApiLoggerMode.LOG_ERROR_TO_CHAT_AND_INFO_TO_FILE)).comment("If enabled, the mod will log information about file sub-dimension operations. \nThis can be useful for debugging.").setSide(EConfigEntryRelevantSide.BOTH).build();
                public static ConfigEntry<EDhApiLoggerMode> logNetworkEvent = ((ConfigEntry.Builder)new ConfigEntry.Builder().setServersideShortName("logNetworkEvent").set((Object)EDhApiLoggerMode.LOG_ERROR_TO_CHAT_AND_INFO_TO_FILE)).comment("If enabled, the mod will log information about network operations. \nThis can be useful for debugging.").setSide(EConfigEntryRelevantSide.BOTH).build();
                public static ConfigEntry<Boolean> showLowMemoryWarningOnStartup = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("If enabled, a chat message will be displayed if Java doesn't have enough \nmemory allocated to run DH well.").build();
                public static ConfigEntry<Boolean> showReplayWarningOnStartup = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("If enabled, a chat message will be displayed when a replay is started \ngiving some basic information about how DH will function.").build();
                public static ConfigEntry<Boolean> showModCompatibilityWarningsOnStartup = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("If enabled, a chat message will be displayed when a potentially problematic \nmod is installed alongside DH.").build();
            }

            public static class Debugging {
                public static ConfigEntry<EDhApiRendererMode> rendererMode = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiRendererMode.DEFAULT)).comment("What renderer is active? \n\n" + (Object)((Object)EDhApiRendererMode.DEFAULT) + ": Default lod renderer \n" + (Object)((Object)EDhApiRendererMode.DEBUG) + ": Debug testing renderer \n" + (Object)((Object)EDhApiRendererMode.DISABLED) + ": Disable rendering").build();
                public static ConfigEntry<EDhApiDebugRendering> debugRendering = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiDebugRendering.OFF)).comment("Should specialized colors/rendering modes be used? \n\n" + (Object)((Object)EDhApiDebugRendering.OFF) + ": LODs will be drawn with their normal colors. \n" + (Object)((Object)EDhApiDebugRendering.SHOW_DETAIL) + ": LODs' color will be based on their detail level. \n" + (Object)((Object)EDhApiDebugRendering.SHOW_BLOCK_MATERIAL) + ": LODs' color will be based on their material. \n" + (Object)((Object)EDhApiDebugRendering.SHOW_OVERLAPPING_QUADS) + ": LODs will be drawn with total white, but overlapping quads will be drawn with red. \n").build();
                public static ConfigEntry<Boolean> renderWireframe = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("If enabled the LODs will render as wireframe.").build();
                public static ConfigEntry<Boolean> enableDebugKeybindings = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("If true the F8 key can be used to cycle through the different debug modes. \nand the F6 key can be used to enable and disable LOD rendering.").build();
                public static ConfigEntry<Boolean> lodOnlyMode = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("If enabled this will disable (most) vanilla Minecraft rendering. \n\nNOTE: Do not report any issues when this mode is on! \n   This setting is only for fun and debugging. \n   Mod compatibility is not guaranteed.").build();
                public static ConfigEntry<Boolean> enableWhiteWorld = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("Stops vertex colors from being passed. \nUseful for debugging shaders").build();
                public static ConfigEntry<Boolean> showOverlappingQuadErrors = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("If true overlapping quads will be rendered as bright red for easy identification. \nIf false the quads will be rendered normally. \n").build();
                public static ConfigEntry<Boolean> logBufferGarbageCollection = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("If true OpenGL Buffer garbage collection will be logged \nthis also includes the number of live buffers. \n").build();
                public static ConfigEntry<Boolean> allowUnsafeValues = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).setAppearance(EConfigEntryAppearance.ONLY_IN_GUI)).addListener(UnsafeValuesConfigListener.INSTANCE).build();
                public static ConfigEntry<Boolean> columnBuilderDebugEnable = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).setAppearance(EConfigEntryAppearance.ONLY_IN_GUI)).addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                public static ConfigEntry<Integer> columnBuilderDebugDetailLevel = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)6)).setAppearance(EConfigEntryAppearance.ONLY_IN_GUI)).addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                public static ConfigEntry<Integer> columnBuilderDebugXPos = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)0)).setAppearance(EConfigEntryAppearance.ONLY_IN_GUI)).addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                public static ConfigEntry<Integer> columnBuilderDebugZPos = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)0)).setAppearance(EConfigEntryAppearance.ONLY_IN_GUI)).addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                public static ConfigEntry<Integer> columnBuilderDebugXRow = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)-1)).setAppearance(EConfigEntryAppearance.ONLY_IN_GUI)).addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                public static ConfigEntry<Integer> columnBuilderDebugZRow = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)-1)).setAppearance(EConfigEntryAppearance.ONLY_IN_GUI)).addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                public static ConfigEntry<Integer> columnBuilderDebugColumnIndex = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)-1)).setAppearance(EConfigEntryAppearance.ONLY_IN_GUI)).addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                public static ConfigCategory debugWireframe = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(DebugWireframe.class)).build();
                public static ConfigCategory openGl = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(OpenGl.class)).build();
                public static ConfigCategory exampleConfigScreen = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(ExampleConfigScreen.class)).build();

                public static class DebugWireframe {
                    public static ConfigEntry<Boolean> enableRendering = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("If enabled, various wireframes for debugging internal functions will be drawn. \n\nNOTE: There WILL be performance hit! \n   Additionally, only stuff that's loaded after you enable this \n   will render their debug wireframes.").build();
                    public static ConfigEntry<Boolean> showWorldGenQueue = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("Render queued world gen tasks?").build();
                    public static ConfigEntry<Boolean> showRenderSectionStatus = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("Render LOD section status?").build();
                    public static ConfigEntry<Boolean> showQuadTreeRenderStatus = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("Render Quad Tree Rendering status?").build();
                    public static ConfigEntry<Boolean> showFullDataUpdateStatus = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("Render full data update/lock status?").build();
                }

                public static class OpenGl {
                    public static ConfigEntry<Boolean> overrideVanillaGLLogger = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)ModInfo.IS_DEV_BUILD)).comment("Requires a reboot to change. \n").build();
                    public static ConfigEntry<EDhApiGLErrorHandlingMode> glErrorHandlingMode = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)(ModInfo.IS_DEV_BUILD ? EDhApiGLErrorHandlingMode.LOG : EDhApiGLErrorHandlingMode.IGNORE))).comment("Defines how OpenGL errors are handled. \nMay incorrectly catch OpenGL errors thrown by other mods. \n\n" + (Object)((Object)EDhApiGLErrorHandlingMode.IGNORE) + ": Do nothing. \n" + (Object)((Object)EDhApiGLErrorHandlingMode.LOG) + ": write an error to the log. \n" + (Object)((Object)EDhApiGLErrorHandlingMode.LOG_THROW) + ": write to the log and throw an exception. \n           Warning: this should only be enabled when debugging the LOD renderer \n           as it may break Minecraft's renderer when an exception is thrown. \n").build();
                    public static ConfigEntry<Integer> glContextMajorVersion = new ConfigEntry.Builder<Integer>().setMinDefaultMax(0, 0, 4).comment("Can be changed if you experience crashing when loading into a world.\nNote: setting to an invalid version may also cause the game to crash.\n\nLeaving this value at causes DH to try all supported GL versions. \n\nDefines the requested OpenGL context major version Distant Horizons will create. \nPossible values (DH requires 3.2 or higher at minimum): \n4.6, 4.5, 4.4, 4.3, 4.2, 4.1, 4.0 \n3.3, 3.2 \n").build();
                    public static ConfigEntry<Integer> glContextMinorVersion = new ConfigEntry.Builder<Integer>().setMinDefaultMax(0, 0, 6).comment("Can be changed if you experience crashing when loading into a world.\nNote: setting to an invalid version may also cause the game to crash.\n\nDefines the requested OpenGL context major version Distant Horizons will create. \nPossible values (DH requires 3.2 or higher at minimum): \n4.6, 4.5, 4.4, 4.3, 4.2, 4.1, 4.0 \n3.3, 3.2 \n").build();
                    public static ConfigEntry<EDhApiGlProfileMode> glProfileMode = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiGlProfileMode.CORE)).comment("Can be changed if you experience crashing when loading into a world.\n\nDefines the OpenGL context type Distant Horizon's will create. \nGenerally this should be left as [" + (Object)((Object)EDhApiGlProfileMode.CORE) + "] unless there is an issue with your GPU driver. \nPossible values: [" + StringUtil.join("],[", EDhApiGlProfileMode.values()) + "] \n").build();
                    public static ConfigEntry<Boolean> enableGlForwardCompatibilityMode = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("Can be changed if you experience crashing when loading into a world.\n\nIf true Distant Horizon's OpenGL contexts will be created with legacy OpenGL methods disabled. \nDistant Horizons doesn't use any legacy OpenGL methods so normally this should be disabled. \n").build();
                    public static ConfigEntry<Boolean> enableGlDebugContext = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)ModInfo.IS_DEV_BUILD)).comment("Can be changed if you experience crashing when loading into a world.\n\nIf true Distant Horizon's OpenGL contexts will be created with debugging enabled. \nThis allows for enhanced debugging but may throw warnings for other mods or active overlay software. \n").build();
                }

                public static class ExampleConfigScreen {
                    public static ConfigUIComment debugConfigScreenNote = new ConfigUIComment();
                    public static ConfigEntry<Boolean> boolTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).build();
                    public static ConfigEntry<Byte> byteTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)8)).build();
                    public static ConfigEntry<Integer> intTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)69420)).build();
                    public static ConfigEntry<Double> doubleTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)420.69)).build();
                    public static ConfigEntry<Short> shortTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)69)).build();
                    public static ConfigEntry<Long> longTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)42069L)).build();
                    public static ConfigEntry<Float> floatTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set(Float.valueOf(0.42069f))).build();
                    public static ConfigEntry<String> stringTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set("Test input box")).build();
                    public static ConfigEntry<List<String>> listTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set(new ArrayList<String>(Arrays.asList("option 1", "option 2", "option 3")))).build();
                    public static ConfigEntry<Map<String, String>> mapTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set(new HashMap())).build();
                    public static ConfigUIButton uiButtonTest = new ConfigUIButton(() -> new Thread(() -> {
                        if (!GraphicsEnvironment.isHeadless()) {
                            JOptionPane.showMessageDialog(null, "Button pressed!", "UITester dialog", 1);
                        } else {
                            LOGGER.info("button pressed!");
                        }
                    }));
                    public static ConfigCategory categoryTest = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(CategoryTest.class)).build();
                    public static ConfigEntry<Integer> linkableTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)420)).build();

                    public static class CategoryTest {
                        public static ConfigLinkedEntry linkableTest = new ConfigLinkedEntry(linkableTest);
                    }
                }
            }
        }

        public static class ResetConfirmation {
            public static ConfigUIComment resetConfirmationNote = new ConfigUIComment();
            public static ConfigEntry<Boolean> resetAllSettings = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).setAppearance(EConfigEntryAppearance.ONLY_IN_GUI)).build();
        }
    }
}

