/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.config.eventHandlers;

import com.seibel.distanthorizons.api.DhApi;
import com.seibel.distanthorizons.api.enums.config.EDhApiBlocksToAvoid;
import com.seibel.distanthorizons.api.enums.config.EDhApiGrassSideRendering;
import com.seibel.distanthorizons.api.enums.config.EDhApiLodShading;
import com.seibel.distanthorizons.api.enums.config.EDhApiMaxHorizontalResolution;
import com.seibel.distanthorizons.api.enums.config.EDhApiVerticalQuality;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiDebugRendering;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiTransparency;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.listeners.ConfigChangeListener;
import com.seibel.distanthorizons.core.util.TimerUtil;
import java.util.Timer;
import java.util.TimerTask;

public class RenderCacheConfigEventHandler {
    private static RenderCacheConfigEventHandler INSTANCE;
    private final ConfigChangeListener<EDhApiMaxHorizontalResolution> horizontalResolutionChangeListener = new ConfigChangeListener<EDhApiMaxHorizontalResolution>(Config.Client.Advanced.Graphics.Quality.maxHorizontalResolution, newValue -> this.refreshRenderDataAfterTimeout());
    private final ConfigChangeListener<EDhApiVerticalQuality> verticalQualityChangeListener = new ConfigChangeListener<EDhApiVerticalQuality>(Config.Client.Advanced.Graphics.Quality.verticalQuality, newValue -> this.refreshRenderDataAfterTimeout());
    private final ConfigChangeListener<String> customVerticalQualityChangeListener = new ConfigChangeListener<String>(Config.Client.Advanced.Graphics.Quality.customVerticalQualityCsv, newValue -> this.refreshRenderDataAfterTimeout());
    private final ConfigChangeListener<EDhApiTransparency> transparencyChangeListener = new ConfigChangeListener<EDhApiTransparency>(Config.Client.Advanced.Graphics.Quality.transparency, newValue -> this.refreshRenderDataAfterTimeout());
    private final ConfigChangeListener<EDhApiBlocksToAvoid> blocksToIgnoreChangeListener = new ConfigChangeListener<EDhApiBlocksToAvoid>(Config.Client.Advanced.Graphics.Quality.blocksToIgnore, newValue -> this.refreshRenderDataAfterTimeout());
    private final ConfigChangeListener<Boolean> tintWithAvoidedBlocksChangeListener = new ConfigChangeListener<Boolean>(Config.Client.Advanced.Graphics.Quality.tintWithAvoidedBlocks, newValue -> this.refreshRenderDataAfterTimeout());
    private final ConfigChangeListener<Double> brightnessMultiplierChangeListener = new ConfigChangeListener<Double>(Config.Client.Advanced.Graphics.AdvancedGraphics.brightnessMultiplier, newValue -> this.refreshRenderDataAfterTimeout());
    private final ConfigChangeListener<Double> saturationMultiplierChangeListener = new ConfigChangeListener<Double>(Config.Client.Advanced.Graphics.AdvancedGraphics.saturationMultiplier, newValue -> this.refreshRenderDataAfterTimeout());
    private final ConfigChangeListener<EDhApiLodShading> lodShadingChangeListener = new ConfigChangeListener<EDhApiLodShading>(Config.Client.Advanced.Graphics.AdvancedGraphics.lodShading, newValue -> this.refreshRenderDataAfterTimeout());
    private final ConfigChangeListener<EDhApiGrassSideRendering> grassSideChangeListener = new ConfigChangeListener<EDhApiGrassSideRendering>(Config.Client.Advanced.Graphics.AdvancedGraphics.grassSideRendering, newValue -> this.refreshRenderDataAfterTimeout());
    private final ConfigChangeListener<EDhApiDebugRendering> debugRenderingChangeListener = new ConfigChangeListener<EDhApiDebugRendering>(Config.Client.Advanced.Debugging.debugRendering, newValue -> this.refreshRenderDataAfterTimeout());
    private static final long TIMEOUT_IN_MS = 4000L;
    private Timer cacheClearingTimer;

    public static RenderCacheConfigEventHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RenderCacheConfigEventHandler();
        }
        return INSTANCE;
    }

    private RenderCacheConfigEventHandler() {
    }

    private void refreshRenderDataAfterTimeout() {
        if (this.cacheClearingTimer != null) {
            this.cacheClearingTimer.cancel();
        }
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                DhApi.Delayed.renderProxy.clearRenderDataCache();
            }
        };
        this.cacheClearingTimer = TimerUtil.CreateTimer("RenderCacheClearConfigTimer");
        this.cacheClearingTimer.schedule(timerTask, 4000L);
    }
}

