/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding;

import com.seibel.distanthorizons.api.enums.rendering.EDhApiBlockMaterial;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiDebugRendering;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.render.ColumnRenderSource;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.ColumnBox;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.ColumnRenderBuffer;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.LodQuadBuilder;
import com.seibel.distanthorizons.core.dataObjects.render.columnViews.ColumnArrayView;
import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import com.seibel.distanthorizons.core.util.ColorUtil;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.RenderDataPointUtil;
import com.seibel.distanthorizons.core.util.objects.UncheckedInterruptedException;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import com.seibel.distanthorizons.coreapi.util.BitShiftUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ColumnRenderBufferBuilder {
    public static final ConfigBasedLogger EVENT_LOGGER = new ConfigBasedLogger(LogManager.getLogger(), () -> Config.Client.Advanced.Logging.logRendererBufferEvent.get());
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();

    public static CompletableFuture<LodQuadBuilder> buildBuffersAsync(IDhClientLevel clientLevel, ColumnRenderSource renderSource, ColumnRenderSource[] adjData, boolean[] isSameDetailLevel) {
        ThreadPoolExecutor bufferBuilderExecutor = ThreadPoolUtil.getBufferBuilderExecutor();
        if (bufferBuilderExecutor == null || bufferBuilderExecutor.isTerminated()) {
            CompletableFuture<LodQuadBuilder> future = new CompletableFuture<LodQuadBuilder>();
            future.cancel(true);
            return future;
        }
        try {
            return CompletableFuture.supplyAsync(() -> {
                try {
                    boolean enableTransparency = Config.Client.Advanced.Graphics.Quality.transparency.get().transparencyEnabled;
                    LodQuadBuilder builder = new LodQuadBuilder(enableTransparency, clientLevel.getClientLevelWrapper());
                    ColumnRenderBufferBuilder.makeLodRenderData(builder, renderSource, clientLevel, adjData, isSameDetailLevel);
                    return builder;
                }
                catch (UncheckedInterruptedException e) {
                    throw e;
                }
                catch (Throwable e3) {
                    LOGGER.error("LodNodeBufferBuilder was unable to build quads for pos [" + DhSectionPos.toString(renderSource.pos) + "], error: [" + e3.getMessage() + "].", e3);
                    throw e3;
                }
            }, bufferBuilderExecutor);
        }
        catch (RejectedExecutionException ignore) {
            CompletableFuture<LodQuadBuilder> future = new CompletableFuture<LodQuadBuilder>();
            future.cancel(true);
            return future;
        }
    }

    public static CompletableFuture<ColumnRenderBuffer> uploadBuffersAsync(IDhClientLevel clientLevel, long pos, LodQuadBuilder quadBuilder) {
        ThreadPoolExecutor bufferUploaderExecutor = ThreadPoolUtil.getBufferUploaderExecutor();
        if (bufferUploaderExecutor == null || bufferUploaderExecutor.isTerminated()) {
            CompletableFuture<ColumnRenderBuffer> future = new CompletableFuture<ColumnRenderBuffer>();
            future.cancel(true);
            return future;
        }
        try {
            return CompletableFuture.supplyAsync(() -> {
                try {
                    ColumnRenderBuffer buffer = new ColumnRenderBuffer(new DhBlockPos(DhSectionPos.getMinCornerBlockX(pos), clientLevel.getMinY(), DhSectionPos.getMinCornerBlockZ(pos)));
                    try {
                        buffer.uploadBuffer(quadBuilder, GLProxy.getInstance().getGpuUploadMethod());
                        if (buffer.buffersUploaded) {
                            return buffer;
                        }
                        buffer.close();
                        return null;
                    }
                    catch (Exception e) {
                        buffer.close();
                        throw e;
                    }
                }
                catch (InterruptedException e) {
                    throw UncheckedInterruptedException.convert(e);
                }
                catch (Throwable e3) {
                    LOGGER.error("LodNodeBufferBuilder was unable to upload buffer for pos [" + DhSectionPos.toString(pos) + "], error: [" + e3.getMessage() + "].", e3);
                    throw e3;
                }
            }, bufferUploaderExecutor);
        }
        catch (RejectedExecutionException ignore) {
            CompletableFuture<ColumnRenderBuffer> future = new CompletableFuture<ColumnRenderBuffer>();
            future.cancel(true);
            return future;
        }
    }

    private static void makeLodRenderData(LodQuadBuilder quadBuilder, ColumnRenderSource renderSource, IDhClientLevel clientLevel, ColumnRenderSource[] adjRegions, boolean[] isSameDetailLevel) {
        boolean columnBuilderDebugEnabled = Config.Client.Advanced.Debugging.columnBuilderDebugEnable.get();
        if (columnBuilderDebugEnabled) {
            if (DhSectionPos.getDetailLevel(renderSource.pos) == Config.Client.Advanced.Debugging.columnBuilderDebugDetailLevel.get() && DhSectionPos.getX(renderSource.pos) == Config.Client.Advanced.Debugging.columnBuilderDebugXPos.get() && DhSectionPos.getZ(renderSource.pos) == Config.Client.Advanced.Debugging.columnBuilderDebugZPos.get()) {
                boolean bl = false;
            } else {
                return;
            }
        }
        byte thisDetailLevel = renderSource.getDataDetailLevel();
        for (int relX = 0; relX < ColumnRenderSource.SECTION_SIZE; ++relX) {
            block3: for (int relZ = 0; relZ < ColumnRenderSource.SECTION_SIZE; ++relZ) {
                int wantedZ;
                int wantedX;
                UncheckedInterruptedException.throwIfInterrupted();
                ColumnArrayView columnRenderData = renderSource.getVerticalDataPointView(relX, relZ);
                if (columnRenderData.size() == 0 || !RenderDataPointUtil.doesDataPointExist(columnRenderData.get(0)) || RenderDataPointUtil.isVoid(columnRenderData.get(0)) || columnBuilderDebugEnabled && ((wantedX = Config.Client.Advanced.Debugging.columnBuilderDebugXRow.get().intValue()) >= 0 && relX != wantedX || (wantedZ = Config.Client.Advanced.Debugging.columnBuilderDebugZRow.get().intValue()) >= 0 && relZ != wantedZ)) continue;
                ColumnArrayView[] adjColumnViews = new ColumnArrayView[EDhDirection.ADJ_DIRECTIONS.length];
                for (EDhDirection lodDirection : EDhDirection.ADJ_DIRECTIONS) {
                    try {
                        byte adjDetailLevel;
                        ColumnRenderSource adjRenderSource;
                        boolean isCrossRenderSourceBoundary;
                        int xAdj = relX + lodDirection.getNormal().x;
                        int zAdj = relZ + lodDirection.getNormal().z;
                        boolean bl = isCrossRenderSourceBoundary = xAdj < 0 || xAdj >= ColumnRenderSource.SECTION_SIZE || zAdj < 0 || zAdj >= ColumnRenderSource.SECTION_SIZE;
                        if (!isCrossRenderSourceBoundary) {
                            adjRenderSource = renderSource;
                            adjDetailLevel = thisDetailLevel;
                        } else {
                            adjRenderSource = adjRegions[lodDirection.ordinal() - 2];
                            if (adjRenderSource == null) continue;
                            adjDetailLevel = adjRenderSource.getDataDetailLevel();
                            if (adjDetailLevel == thisDetailLevel) {
                                if (xAdj < 0) {
                                    xAdj += ColumnRenderSource.SECTION_SIZE;
                                }
                                if (xAdj >= ColumnRenderSource.SECTION_SIZE) {
                                    xAdj -= ColumnRenderSource.SECTION_SIZE;
                                }
                                if (zAdj < 0) {
                                    zAdj += ColumnRenderSource.SECTION_SIZE;
                                }
                                if (zAdj >= ColumnRenderSource.SECTION_SIZE) {
                                    zAdj -= ColumnRenderSource.SECTION_SIZE;
                                }
                            }
                        }
                        LodUtil.assertTrue(adjDetailLevel == thisDetailLevel || adjDetailLevel > thisDetailLevel);
                        adjColumnViews[lodDirection.ordinal() - 2] = adjRenderSource.getVerticalDataPointView(xAdj, zAdj);
                    }
                    catch (RuntimeException e) {
                        EVENT_LOGGER.warn("Failed to get adj data for relative pos: [" + thisDetailLevel + ":" + relX + "," + relZ + "] at [" + (Object)((Object)lodDirection) + "], Error: " + e.getMessage(), e);
                    }
                }
                ColumnRenderSource.DebugSourceFlag debugSourceFlag = renderSource.debugGetFlag(relX, relZ);
                for (int i = 0; i < columnRenderData.size(); ++i) {
                    int wantedColumnIndex;
                    if (Config.Client.Advanced.Debugging.columnBuilderDebugEnable.get().booleanValue() && (wantedColumnIndex = Config.Client.Advanced.Debugging.columnBuilderDebugColumnIndex.get().intValue()) >= 0 && i != wantedColumnIndex) continue;
                    long data = columnRenderData.get(i);
                    if (RenderDataPointUtil.isVoid(data) || !RenderDataPointUtil.doesDataPointExist(data)) continue block3;
                    long topDataPoint = i - 1 >= 0 ? columnRenderData.get(i - 1) : 0L;
                    long bottomDataPoint = i + 1 < columnRenderData.size() ? columnRenderData.get(i + 1) : 0L;
                    ColumnRenderBufferBuilder.addLodToBuffer(clientLevel, data, topDataPoint, bottomDataPoint, adjColumnViews, isSameDetailLevel, thisDetailLevel, relX, relZ, quadBuilder, debugSourceFlag);
                }
            }
        }
        quadBuilder.finalizeData();
    }

    private static void addLodToBuffer(IDhClientLevel clientLevel, long data, long topData, long bottomData, ColumnArrayView[] adjColumnViews, boolean[] isSameDetailLevel, byte detailLevel, int renderSourceOffsetPosX, int renderSourceOffsetPosZ, LodQuadBuilder quadBuilder, ColumnRenderSource.DebugSourceFlag debugSource) {
        int color;
        long sectionPos = DhSectionPos.encode(detailLevel, renderSourceOffsetPosX, renderSourceOffsetPosZ);
        short width = (short)BitShiftUtil.powerOfTwo(detailLevel);
        short x = (short)DhSectionPos.getMinCornerBlockX(sectionPos);
        short yMin = RenderDataPointUtil.getYMin(data);
        short z = (short)DhSectionPos.getMinCornerBlockZ(sectionPos);
        short ySize = (short)(RenderDataPointUtil.getYMax(data) - yMin);
        if (ySize == 0) {
            return;
        }
        if (ySize < 0) {
            throw new IllegalArgumentException("Negative y size for the data! Data: [" + RenderDataPointUtil.toString(data) + "].");
        }
        byte blockMaterialId = RenderDataPointUtil.getBlockMaterialId(data);
        boolean fullBright = false;
        EDhApiDebugRendering debugging = Config.Client.Advanced.Debugging.debugRendering.get();
        switch (debugging) {
            case OFF: {
                float saturationMultiplier = Config.Client.Advanced.Graphics.AdvancedGraphics.saturationMultiplier.get().floatValue();
                float brightnessMultiplier = Config.Client.Advanced.Graphics.AdvancedGraphics.brightnessMultiplier.get().floatValue();
                if ((double)saturationMultiplier == 1.0 && (double)brightnessMultiplier == 1.0) {
                    color = RenderDataPointUtil.getColor(data);
                    break;
                }
                float[] ahsv = ColorUtil.argbToAhsv(RenderDataPointUtil.getColor(data));
                color = ColorUtil.ahsvToArgb(ahsv[0], ahsv[1], ahsv[2] * saturationMultiplier, ahsv[3] * brightnessMultiplier);
                break;
            }
            case SHOW_DETAIL: {
                color = LodUtil.DEBUG_DETAIL_LEVEL_COLORS[detailLevel];
                fullBright = true;
                break;
            }
            case SHOW_BLOCK_MATERIAL: {
                switch (EDhApiBlockMaterial.getFromIndex(blockMaterialId)) {
                    case UNKNOWN: 
                    case AIR: {
                        color = ColorUtil.HOT_PINK;
                        break;
                    }
                    case LEAVES: {
                        color = ColorUtil.DARK_GREEN;
                        break;
                    }
                    case STONE: {
                        color = ColorUtil.GRAY;
                        break;
                    }
                    case WOOD: {
                        color = ColorUtil.BROWN;
                        break;
                    }
                    case METAL: {
                        color = ColorUtil.DARK_GRAY;
                        break;
                    }
                    case DIRT: {
                        color = ColorUtil.LIGHT_BROWN;
                        break;
                    }
                    case LAVA: {
                        color = ColorUtil.ORANGE;
                        break;
                    }
                    case DEEPSLATE: {
                        color = ColorUtil.BLACK;
                        break;
                    }
                    case SNOW: {
                        color = ColorUtil.WHITE;
                        break;
                    }
                    case SAND: {
                        color = ColorUtil.TAN;
                        break;
                    }
                    case TERRACOTTA: {
                        color = ColorUtil.DARK_ORANGE;
                        break;
                    }
                    case NETHER_STONE: {
                        color = ColorUtil.DARK_RED;
                        break;
                    }
                    case WATER: {
                        color = ColorUtil.BLUE;
                        break;
                    }
                    case GRASS: {
                        color = ColorUtil.GREEN;
                        break;
                    }
                    case ILLUMINATED: {
                        color = ColorUtil.YELLOW;
                        break;
                    }
                    default: {
                        color = ColorUtil.CYAN;
                    }
                }
                fullBright = true;
                break;
            }
            case SHOW_OVERLAPPING_QUADS: {
                color = ColorUtil.WHITE;
                fullBright = true;
                break;
            }
            case SHOW_RENDER_SOURCE_FLAG: {
                color = debugSource == null ? ColorUtil.RED : debugSource.color;
                fullBright = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown debug mode: " + (Object)((Object)debugging));
            }
        }
        ColumnBox.addBoxQuadsToBuilder(quadBuilder, clientLevel, width, ySize, width, x, yMin, z, color, blockMaterialId, RenderDataPointUtil.getLightSky(data), fullBright ? (byte)15 : (byte)RenderDataPointUtil.getLightBlock(data), topData, bottomData, adjColumnViews, isSameDetailLevel);
    }
}

