/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.transformers;

import com.seibel.distanthorizons.api.enums.config.EDhApiBlocksToAvoid;
import com.seibel.distanthorizons.api.enums.config.EDhApiVerticalQuality;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.FullDataPointIdMap;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.dataObjects.render.ColumnRenderSource;
import com.seibel.distanthorizons.core.dataObjects.render.columnViews.ColumnArrayView;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.util.ColorUtil;
import com.seibel.distanthorizons.core.util.FullDataPointUtil;
import com.seibel.distanthorizons.core.util.RenderDataPointUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.coreapi.util.BitShiftUtil;
import com.seibel.distanthorizons.coreapi.util.MathUtil;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.HashSet;
import org.apache.logging.log4j.Logger;

public class FullDataToRenderDataTransformer {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final IWrapperFactory WRAPPER_FACTORY = SingletonInjector.INSTANCE.get(IWrapperFactory.class);
    private static final IMinecraftClientWrapper MC = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static final LongOpenHashSet brokenPos = new LongOpenHashSet();

    public static ColumnRenderSource transformFullDataToRenderSource(FullDataSourceV2 fullDataSource, IDhClientLevel level) {
        if (fullDataSource == null) {
            return null;
        }
        if (level == null) {
            return null;
        }
        try {
            return FullDataToRenderDataTransformer.transformCompleteFullDataToColumnData(level, fullDataSource);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    private static ColumnRenderSource transformCompleteFullDataToColumnData(IDhClientLevel level, FullDataSourceV2 fullDataSource) throws InterruptedException {
        long pos = fullDataSource.getPos();
        byte dataDetail = fullDataSource.getDataDetailLevel();
        int tempVertSize = 1;
        if (Config.Client.Advanced.Graphics.Quality.verticalQuality.get() != EDhApiVerticalQuality.CUSTOM) {
            tempVertSize = Config.Client.Advanced.Graphics.Quality.verticalQuality.get().calculateMaxVerticalData(fullDataSource.getDataDetailLevel());
        } else {
            String verticalQualityCsv = Config.Client.Advanced.Graphics.Quality.customVerticalQualityCsv.get();
            if (verticalQualityCsv != null) {
                String[] possibleVerticalValues = verticalQualityCsv.split(",");
                int index = MathUtil.clamp(0, dataDetail, possibleVerticalValues.length - 1);
                String verticalValueString = possibleVerticalValues[index];
                try {
                    tempVertSize = Integer.parseInt(verticalValueString);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        int vertSize = tempVertSize;
        ColumnRenderSource columnSource = ColumnRenderSource.getPooledRenderSource(pos, vertSize, level.getMinY(), true);
        if (fullDataSource.isEmpty) {
            return columnSource;
        }
        columnSource.markNotEmpty();
        int baseX = DhSectionPos.getMinCornerBlockX(pos);
        int baseZ = DhSectionPos.getMinCornerBlockZ(pos);
        for (int x = 0; x < DhSectionPos.getWidthCountForLowerDetailedSection(pos, dataDetail); ++x) {
            for (int z = 0; z < DhSectionPos.getWidthCountForLowerDetailedSection(pos, dataDetail); ++z) {
                FullDataToRenderDataTransformer.throwIfThreadInterrupted();
                ColumnArrayView columnArrayView = columnSource.getVerticalDataPointView(x, z);
                LongArrayList dataColumn = fullDataSource.get(x, z);
                FullDataToRenderDataTransformer.updateOrReplaceRenderDataViewColumnWithFullDataColumn(level, fullDataSource.mapping, baseX + BitShiftUtil.pow(x, dataDetail), baseZ + BitShiftUtil.pow(z, dataDetail), columnArrayView, dataColumn);
            }
        }
        columnSource.fillDebugFlag(0, 0, ColumnRenderSource.SECTION_SIZE, ColumnRenderSource.SECTION_SIZE, ColumnRenderSource.DebugSourceFlag.FULL);
        return columnSource;
    }

    public static void updateOrReplaceRenderDataViewColumnWithFullDataColumn(IDhClientLevel level, FullDataPointIdMap fullDataMapping, int blockX, int blockZ, ColumnArrayView columnArrayView, LongArrayList fullDataColumn) {
        if (fullDataColumn == null || fullDataColumn.size() == 0) {
            return;
        }
        int fullDataLength = fullDataColumn.size();
        if (fullDataLength <= columnArrayView.verticalSize()) {
            FullDataToRenderDataTransformer.setRenderColumnView(level, fullDataMapping, blockX, blockZ, columnArrayView, fullDataColumn);
        } else {
            ColumnArrayView newColumnArrayView = new ColumnArrayView(new LongArrayList(new long[fullDataLength]), fullDataLength, 0, fullDataLength);
            FullDataToRenderDataTransformer.setRenderColumnView(level, fullDataMapping, blockX, blockZ, newColumnArrayView, fullDataColumn);
            columnArrayView.changeVerticalSizeFrom(newColumnArrayView);
        }
    }

    private static void setRenderColumnView(IDhClientLevel level, FullDataPointIdMap fullDataMapping, int blockX, int blockZ, ColumnArrayView renderColumnData, LongArrayList fullColumnData) {
        boolean ignoreNonCollidingBlocks = Config.Client.Advanced.Graphics.Quality.blocksToIgnore.get() == EDhApiBlocksToAvoid.NON_COLLIDING;
        boolean colorBelowWithAvoidedBlocks = Config.Client.Advanced.Graphics.Quality.tintWithAvoidedBlocks.get();
        HashSet<IBlockStateWrapper> blockStatesToIgnore = WRAPPER_FACTORY.getRendererIgnoredBlocks(level.getLevelWrapper());
        HashSet<IBlockStateWrapper> caveBlockStatesToIgnore = WRAPPER_FACTORY.getRendererIgnoredCaveBlocks(level.getLevelWrapper());
        int caveCullingMaxY = Config.Client.Advanced.Graphics.AdvancedGraphics.caveCullingHeight.get() - level.getMinY();
        boolean caveCullingEnabled = Config.Client.Advanced.Graphics.AdvancedGraphics.enableCaveCulling.get() != false && !level.getLevelWrapper().hasCeiling() && !level.getLevelWrapper().getDimensionType().isTheEnd();
        boolean isColumnVoid = true;
        int colorToApplyToNextBlock = -1;
        int lastColor = 0;
        int lastBottom = -10000;
        int skylightToApplyToNextBlock = -1;
        int blocklightToApplyToNextBlock = -1;
        int renderDataIndex = 0;
        for (int fullDataIndex = 0; fullDataIndex < fullColumnData.size(); ++fullDataIndex) {
            long columnData;
            int color;
            IBlockStateWrapper block;
            IBiomeWrapper biome;
            long fullData = fullColumnData.getLong(fullDataIndex);
            int bottomY = FullDataPointUtil.getBottomY(fullData);
            int blockHeight = FullDataPointUtil.getHeight(fullData);
            int topY = bottomY + blockHeight;
            int id = FullDataPointUtil.getId(fullData);
            int blockLight = FullDataPointUtil.getBlockLight(fullData);
            int skyLight = FullDataPointUtil.getSkyLight(fullData);
            try {
                biome = fullDataMapping.getBiomeWrapper(id);
                block = fullDataMapping.getBlockStateWrapper(id);
            }
            catch (IndexOutOfBoundsException e) {
                if (brokenPos.contains(fullDataMapping.getPos())) continue;
                brokenPos.add(fullDataMapping.getPos());
                String dimName = level.getLevelWrapper().getDimensionName();
                LOGGER.warn("Unable to get data point with id [" + id + "] (Max possible ID: [" + fullDataMapping.getMaxValidId() + "]) for pos [" + fullDataMapping.getPos() + "] in dimension [" + dimName + "]. Error: [" + e.getMessage() + "]. Further errors for this position won't be logged.");
                continue;
            }
            boolean ignoreBlock = blockStatesToIgnore.contains(block);
            boolean caveBlock = caveBlockStatesToIgnore.contains(block);
            if (caveBlock) {
                if (caveCullingEnabled && skyLight == 0 && topY < caveCullingMaxY && renderDataIndex != 0 && fullDataIndex != 0 && fullDataIndex + 1 < fullColumnData.size()) {
                    long nextFullData = fullColumnData.getLong(fullDataIndex + 1);
                    int nextSkyLight = FullDataPointUtil.getSkyLight(nextFullData);
                    if (nextSkyLight != 0 || ColorUtil.getAlpha(lastColor) != 255) continue;
                    long columnData2 = renderColumnData.get(renderDataIndex - 1);
                    columnData2 = RenderDataPointUtil.setYMin(columnData2, bottomY);
                    renderColumnData.set(renderDataIndex - 1, columnData2);
                    continue;
                }
                if (ignoreBlock) {
                    continue;
                }
            } else if (ignoreBlock) continue;
            if (ignoreNonCollidingBlocks && !block.isSolid() && !block.isLiquid() && block.getOpacity() != 16) {
                int tempColor;
                if (!colorBelowWithAvoidedBlocks || ColorUtil.getAlpha(tempColor = level.computeBaseColor(new DhBlockPos(blockX, bottomY + level.getMinY(), blockZ), biome, block)) == 0) continue;
                colorToApplyToNextBlock = ColorUtil.setAlpha(tempColor, 255);
                skylightToApplyToNextBlock = skyLight;
                blocklightToApplyToNextBlock = blockLight;
                continue;
            }
            if (colorToApplyToNextBlock == -1) {
                color = level.computeBaseColor(new DhBlockPos(blockX, bottomY + level.getMinY(), blockZ), biome, block);
            } else {
                color = colorToApplyToNextBlock;
                colorToApplyToNextBlock = -1;
                skyLight = skylightToApplyToNextBlock;
                blockLight = blocklightToApplyToNextBlock;
            }
            if (color == lastColor && bottomY + blockHeight == lastBottom && renderDataIndex > 0) {
                columnData = renderColumnData.get(renderDataIndex - 1);
                columnData = RenderDataPointUtil.setYMin(columnData, bottomY);
                renderColumnData.set(renderDataIndex - 1, columnData);
            } else {
                isColumnVoid = false;
                columnData = RenderDataPointUtil.createDataPoint(bottomY + blockHeight, bottomY, color, skyLight, blockLight, block.getMaterialId());
                renderColumnData.set(renderDataIndex, columnData);
                ++renderDataIndex;
            }
            lastBottom = bottomY;
            lastColor = color;
        }
        if (isColumnVoid) {
            renderColumnData.set(0, 0L);
        }
    }

    private static void throwIfThreadInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException(FullDataToRenderDataTransformer.class.getSimpleName() + " task interrupted.");
        }
    }
}

