/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.file.fullDatafile;

import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.file.fullDatafile.GeneratedFullDataSourceProvider;
import com.seibel.distanthorizons.core.file.structure.AbstractSaveStructure;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.multiplayer.client.SyncOnLoginRequestQueue;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class RemoteFullDataSourceProvider
extends GeneratedFullDataSourceProvider {
    @Nullable
    private final SyncOnLoginRequestQueue syncOnLoginRequestQueue;
    private final Set<Long> finishedTaskPositions = ConcurrentHashMap.newKeySet();

    public RemoteFullDataSourceProvider(IDhLevel level, AbstractSaveStructure saveStructure, @Nullable File saveDirOverride, @Nullable SyncOnLoginRequestQueue syncOnLoginRequestQueue) {
        super(level, saveStructure, saveDirOverride);
        this.syncOnLoginRequestQueue = syncOnLoginRequestQueue;
    }

    @Override
    @Nullable
    public FullDataSourceV2 get(long pos) {
        FullDataSourceV2 fullDataSource = (FullDataSourceV2)super.get(pos);
        if (fullDataSource == null) {
            return null;
        }
        if (this.syncOnLoginRequestQueue == null) {
            return fullDataSource;
        }
        int posToMinimumDetailScale = DhSectionPos.getDetailLevel(pos) - 6 + 1;
        Map<Long, Long> timestamps = this.getTimestampsForRange((byte)6, DhSectionPos.getX(pos) * posToMinimumDetailScale, DhSectionPos.getZ(pos) * posToMinimumDetailScale, (DhSectionPos.getX(pos) + 1) * posToMinimumDetailScale - 1, (DhSectionPos.getZ(pos) + 1) * posToMinimumDetailScale - 1);
        for (Map.Entry<Long, Long> timestampBySectionPos : timestamps.entrySet()) {
            Long subPos = timestampBySectionPos.getKey();
            Long subTimestamp = timestampBySectionPos.getValue();
            if (!this.finishedTaskPositions.add(subPos)) continue;
            this.syncOnLoginRequestQueue.submitRequest(subPos, subTimestamp, this.delayedFullDataSourceSaveCache::queueDataSourceForUpdateAndSave);
        }
        return fullDataSource;
    }

    @Override
    public void close() {
        if (this.syncOnLoginRequestQueue != null) {
            this.syncOnLoginRequestQueue.close();
        }
        super.close();
    }
}

