/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.file.structure;

import com.google.common.net.PercentEscaper;
import com.seibel.distanthorizons.api.enums.config.EDhApiServerFolderNameMode;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.file.structure.AbstractSaveStructure;
import com.seibel.distanthorizons.core.file.subDimMatching.SubDimensionLevelMatcher;
import com.seibel.distanthorizons.core.level.IServerKeyedClientLevel;
import com.seibel.distanthorizons.core.util.objects.ParsedIp;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftSharedWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.coreapi.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ClientOnlySaveStructure
extends AbstractSaveStructure {
    public static final String SERVER_DATA_FOLDER_NAME = "Distant_Horizons_server_data";
    public static final String REPLAY_SERVER_FOLDER_NAME = "REPLAY";
    public static final String INVALID_FILE_CHARACTERS_REGEX = "[\\\\/:*?\"<>|]";
    private static final IMinecraftClientWrapper MC_CLIENT = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static final IMinecraftSharedWrapper MC_SHARED = SingletonInjector.INSTANCE.get(IMinecraftSharedWrapper.class);
    private SubDimensionLevelMatcher subDimMatcher = null;
    private final File folder;
    private final HashMap<ILevelWrapper, File> levelWrapperToFileMap = new HashMap();

    public ClientOnlySaveStructure() {
        this.folder = new File(ClientOnlySaveStructure.getSaveStructureFolderPath());
        if (!this.folder.exists() && !this.folder.mkdirs()) {
            LOGGER.warn("Unable to create folder [" + this.folder.getPath() + "]");
        }
    }

    @Override
    public File getLevelFolder(ILevelWrapper levelWrapper) {
        return this.levelWrapperToFileMap.computeIfAbsent(levelWrapper, newLevelWrapper -> {
            if (newLevelWrapper instanceof IServerKeyedClientLevel) {
                IServerKeyedClientLevel keyedClientLevel = (IServerKeyedClientLevel)newLevelWrapper;
                LOGGER.info("Loading level " + newLevelWrapper.getDimensionName() + " with key: " + keyedClientLevel.getServerLevelKey());
                return new File(ClientOnlySaveStructure.getSaveStructureFolderPath() + File.separatorChar + keyedClientLevel.getServerLevelKey().replaceAll(":", "@@"));
            }
            if (newLevelWrapper instanceof IClientLevelWrapper && Config.Client.Advanced.Multiplayer.multiverseSimilarityRequiredPercent.get() != 0.0) {
                File levelFile;
                IClientLevelWrapper newClientLevelWrapper = (IClientLevelWrapper)newLevelWrapper;
                if (this.subDimMatcher == null || !this.subDimMatcher.isFindingLevel(newClientLevelWrapper)) {
                    LOGGER.info("Loading level " + newClientLevelWrapper.getDimensionName());
                    List<File> levelFolders = this.getDhDataFoldersForLevel(newClientLevelWrapper);
                    this.subDimMatcher = new SubDimensionLevelMatcher(newClientLevelWrapper, this.folder, levelFolders);
                }
                if ((levelFile = this.subDimMatcher.tryGetLevel()) != null) {
                    this.subDimMatcher.close();
                    this.subDimMatcher = null;
                }
                return levelFile;
            }
            if (this.subDimMatcher != null) {
                this.subDimMatcher.close();
                this.subDimMatcher = null;
            }
            return this.getLevelFolderWithoutSimilarityMatching((ILevelWrapper)newLevelWrapper);
        });
    }

    private File getLevelFolderWithoutSimilarityMatching(ILevelWrapper level) {
        List<File> folders = this.getDhDataFoldersForLevel(level);
        if (!folders.isEmpty() && folders.get(0) != null) {
            String folderName = folders.get(0).getName();
            LOGGER.info("Default Sub Dimension set to: [" + StringUtil.shortenString(folderName, 8) + "...]");
            return folders.get(0);
        }
        LOGGER.info("Default Sub Dimension not found. Creating: [" + level.getDimensionName() + "]");
        return new File(this.folder, level.getDimensionName().replaceAll(":", "@@"));
    }

    public List<File> getDhDataFoldersForLevel(ILevelWrapper level) {
        File[] folders = this.folder.listFiles();
        if (folders == null) {
            return new ArrayList<File>(0);
        }
        String expectedDimName = level.getDimensionName();
        ArrayList<File> possibleDimFolders = new ArrayList<File>();
        for (File dimFolder : folders) {
            if (!dimFolder.isDirectory() || !dimFolder.getName().equals(expectedDimName)) continue;
            possibleDimFolders.addAll(ClientOnlySaveStructure.getValidDhDimensionFolders(dimFolder));
        }
        return possibleDimFolders;
    }

    @Override
    public File getFullDataFolder(ILevelWrapper level) {
        File levelFolder = this.levelWrapperToFileMap.get(level);
        if (levelFolder == null) {
            return null;
        }
        return levelFolder;
    }

    private static ArrayList<File> getValidDhDimensionFolders(File potentialFolder) {
        ArrayList<File> subDimSaveFolders = new ArrayList<File>();
        if (!potentialFolder.isDirectory()) {
            return subDimSaveFolders;
        }
        File[] potentialLevelFolders = potentialFolder.listFiles();
        if (potentialLevelFolders != null) {
            for (File potentialFile : potentialLevelFolders) {
                File[] dataFolders;
                if (!potentialFile.isDirectory() || (dataFolders = potentialFile.listFiles()) == null) continue;
                boolean isValidDhLevelFolder = false;
                for (File dataFolder : dataFolders) {
                    if (!dataFolder.getName().equalsIgnoreCase("DistantHorizons.sqlite")) continue;
                    isValidDhLevelFolder = true;
                    break;
                }
                if (!isValidDhLevelFolder) continue;
                subDimSaveFolders.add(potentialFile);
            }
        }
        return subDimSaveFolders;
    }

    private static String getSaveStructureFolderPath() {
        String path = MC_SHARED.getInstallationDirectory().getPath() + File.separatorChar + SERVER_DATA_FOLDER_NAME + File.separatorChar + ClientOnlySaveStructure.getServerFolderName();
        return path;
    }

    private static String getServerFolderName() {
        String folderName;
        if (MC_CLIENT.connectedToReplay()) {
            return REPLAY_SERVER_FOLDER_NAME;
        }
        ParsedIp parsedIp = new ParsedIp(MC_CLIENT.getCurrentServerIp());
        String serverIpCleaned = parsedIp.ip.replaceAll(INVALID_FILE_CHARACTERS_REGEX, "");
        String serverPortCleaned = parsedIp.port != null ? parsedIp.port.replaceAll(INVALID_FILE_CHARACTERS_REGEX, "") : "";
        EDhApiServerFolderNameMode folderNameMode = Config.Client.Advanced.Multiplayer.serverFolderNameMode.get();
        String serverName = MC_CLIENT.getCurrentServerName().replaceAll(INVALID_FILE_CHARACTERS_REGEX, "");
        String serverMcVersion = MC_CLIENT.getCurrentServerVersion().replaceAll(INVALID_FILE_CHARACTERS_REGEX, "");
        switch (folderNameMode) {
            default: {
                folderName = serverName;
                break;
            }
            case IP_ONLY: {
                folderName = serverIpCleaned;
                break;
            }
            case NAME_IP: {
                folderName = serverName + ", IP " + serverIpCleaned;
                break;
            }
            case NAME_IP_PORT: {
                folderName = serverName + ", IP " + serverIpCleaned + (serverPortCleaned.length() != 0 ? "-" + serverPortCleaned : "");
                break;
            }
            case NAME_IP_PORT_MC_VERSION: {
                folderName = serverName + ", IP " + serverIpCleaned + (serverPortCleaned.length() != 0 ? "-" + serverPortCleaned : "") + ", GameVersion " + serverMcVersion;
            }
        }
        return new PercentEscaper("", true).escape(folderName);
    }

    @Override
    public void close() {
        this.subDimMatcher.close();
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "@" + this.folder.getName() + "]";
    }
}

