/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.generation;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.generation.IFullDataSourceRetrievalQueue;
import com.seibel.distanthorizons.core.generation.tasks.IWorldGenTaskTracker;
import com.seibel.distanthorizons.core.generation.tasks.WorldGenResult;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.multiplayer.client.AbstractFullDataNetworkRequestQueue;
import com.seibel.distanthorizons.core.multiplayer.client.ClientNetworkState;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.render.renderer.IDebugRenderable;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.Logger;

public class RemoteWorldRetrievalQueue
extends AbstractFullDataNetworkRequestQueue
implements IFullDataSourceRetrievalQueue,
IDebugRenderable {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private int estimatedTotalTaskCount;

    public RemoteWorldRetrievalQueue(ClientNetworkState networkState, IDhClientLevel level) {
        super(networkState, level, false, Config.Client.Advanced.Debugging.DebugWireframe.showWorldGenQueue);
    }

    @Override
    public void startAndSetTargetPos(DhBlockPos2D targetPos) {
        super.tick(targetPos);
    }

    @Override
    public byte lowestDataDetail() {
        return 0;
    }

    @Override
    public byte highestDataDetail() {
        return 0;
    }

    @Override
    public CompletableFuture<WorldGenResult> submitRetrievalTask(long sectionPos, byte requiredDataDetail, IWorldGenTaskTracker tracker) {
        return super.submitRequest(sectionPos, tracker.getDataSourceConsumer()).thenApply(retrievalSuccess -> retrievalSuccess != false ? WorldGenResult.CreateSuccess(sectionPos) : WorldGenResult.CreateFail());
    }

    @Override
    public CompletableFuture<Void> startClosingAsync(boolean cancelCurrentGeneration, boolean alsoInterruptRunning) {
        return super.startClosingAsync(alsoInterruptRunning);
    }

    @Override
    protected int getRequestRateLimit() {
        return this.networkState.sessionConfig.getGenerationRequestRateLimit();
    }

    @Override
    protected String getQueueName() {
        return "World Remote Generation Queue";
    }

    @Override
    public int getEstimatedTotalTaskCount() {
        return this.estimatedTotalTaskCount;
    }

    @Override
    public void setEstimatedTotalTaskCount(int newEstimate) {
        this.estimatedTotalTaskCount = newEstimate;
    }
}

