/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.generation;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiDistantGeneratorMode;
import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiWorldGeneratorReturnType;
import com.seibel.distanthorizons.api.interfaces.override.worldGenerator.IDhApiWorldGenerator;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.dataObjects.transformers.LodDataBuilder;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.generation.IFullDataSourceRetrievalQueue;
import com.seibel.distanthorizons.core.generation.tasks.IWorldGenTaskTracker;
import com.seibel.distanthorizons.core.generation.tasks.InProgressWorldGenTaskGroup;
import com.seibel.distanthorizons.core.generation.tasks.WorldGenResult;
import com.seibel.distanthorizons.core.generation.tasks.WorldGenTask;
import com.seibel.distanthorizons.core.generation.tasks.WorldGenTaskGroup;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.render.renderer.IDebugRenderable;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.ThreadUtil;
import com.seibel.distanthorizons.core.util.objects.DataCorruptedException;
import com.seibel.distanthorizons.core.util.objects.UncheckedInterruptedException;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import com.seibel.distanthorizons.core.world.DhApiWorldProxy;
import com.seibel.distanthorizons.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;

public class WorldGenerationQueue
implements IFullDataSourceRetrievalQueue,
IDebugRenderable {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final IWrapperFactory WRAPPER_FACTORY = SingletonInjector.INSTANCE.get(IWrapperFactory.class);
    private static final int MAX_QUEUED_TASKS_PER_THREAD = 3;
    private final IDhApiWorldGenerator generator;
    private final ConcurrentHashMap<Long, WorldGenTask> waitingTasks = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, InProgressWorldGenTaskGroup> inProgressGenTasksByLodPos = new ConcurrentHashMap();
    public final byte maxGranularity;
    public final byte minGranularity;
    public final byte lowestDataDetail;
    public final byte highestDataDetail;
    private volatile CompletableFuture<Void> generatorClosingFuture = null;
    private final ExecutorService queueingThread = ThreadUtil.makeSingleThreadPool("World Gen Queue");
    private boolean generationQueueRunning = false;
    private DhBlockPos2D generationTargetPos = DhBlockPos2D.ZERO;
    private int numberOfTasksQueued = 0;
    private static final int MAX_ALREADY_GENERATED_COUNT = 100;
    private final HashMap<Long, StackTraceElement[]> alreadyGeneratedPosHashSet = new HashMap(100);
    private final LongArrayFIFOQueue alreadyGeneratedPosQueue = new LongArrayFIFOQueue();
    private int estimatedTotalTaskCount = 0;

    public WorldGenerationQueue(IDhApiWorldGenerator generator) {
        LOGGER.info("Creating world gen queue");
        this.generator = generator;
        this.maxGranularity = generator.getMaxGenerationGranularity();
        this.minGranularity = generator.getMinGenerationGranularity();
        this.lowestDataDetail = generator.getLargestDataDetailLevel();
        this.highestDataDetail = generator.getSmallestDataDetailLevel();
        if (this.minGranularity < 4) {
            throw new IllegalArgumentException(IDhApiWorldGenerator.class.getSimpleName() + ": min granularity must be at least 4 (Chunk sized)!");
        }
        if (this.maxGranularity < this.minGranularity) {
            throw new IllegalArgumentException(IDhApiWorldGenerator.class.getSimpleName() + ": max granularity smaller than min granularity!");
        }
        DebugRenderer.register(this, Config.Client.Advanced.Debugging.DebugWireframe.showWorldGenQueue);
        LOGGER.info("Created world gen queue");
    }

    @Override
    public CompletableFuture<WorldGenResult> submitRetrievalTask(long pos, byte requiredDataDetail, IWorldGenTaskTracker tracker) {
        if (this.generatorClosingFuture != null) {
            return CompletableFuture.completedFuture(WorldGenResult.CreateFail());
        }
        if (requiredDataDetail < this.highestDataDetail) {
            throw new UnsupportedOperationException("Current generator does not meet requiredDataDetail level");
        }
        if (requiredDataDetail > this.lowestDataDetail) {
            requiredDataDetail = this.lowestDataDetail;
        }
        LodUtil.assertTrue(DhSectionPos.getDetailLevel(pos) > requiredDataDetail + 4);
        CompletableFuture<WorldGenResult> future = new CompletableFuture<WorldGenResult>();
        this.waitingTasks.put(pos, new WorldGenTask(pos, requiredDataDetail, tracker, future));
        return future;
    }

    @Override
    public void removeRetrievalRequestIf(DhSectionPos.ICancelablePrimitiveLongConsumer removeIf) {
        this.waitingTasks.forEachKey(100L, genPos -> {
            if (removeIf.accept((long)genPos)) {
                this.waitingTasks.remove(genPos);
            }
        });
    }

    @Override
    public void startAndSetTargetPos(DhBlockPos2D targetPos) {
        this.generationTargetPos = targetPos;
        if (!this.generationQueueRunning) {
            this.startWorldGenQueuingThread();
        }
    }

    private void startWorldGenQueuingThread() {
        this.generationQueueRunning = true;
        this.queueingThread.execute(() -> {
            try {
                while (!Thread.interrupted() && !DhApiWorldProxy.INSTANCE.getReadOnly()) {
                    this.generator.preGeneratorTaskStart();
                    boolean taskStarted = true;
                    while (!this.isGeneratorBusy() && taskStarted) {
                        taskStarted = this.startNextWorldGenTask(this.generationTargetPos);
                        if (taskStarted) continue;
                        boolean bl = false;
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException taskStarted) {
            }
            catch (Exception e) {
                LOGGER.error("queueing exception: " + e.getMessage(), (Throwable)e);
            }
            finally {
                this.generationQueueRunning = false;
            }
        });
    }

    public boolean isGeneratorBusy() {
        ThreadPoolExecutor executor = ThreadPoolUtil.getWorldGenExecutor();
        if (executor == null) {
            return true;
        }
        int worldGenThreadCount = Math.max(Config.Client.Advanced.MultiThreading.numberOfWorldGenerationThreads.get(), 1);
        int maxWorldGenTaskCount = worldGenThreadCount * 3;
        return executor.getQueue().size() > maxWorldGenTaskCount;
    }

    private boolean startNextWorldGenTask(DhBlockPos2D targetPos) {
        if (this.waitingTasks.size() == 0) {
            return false;
        }
        this.waitingTasks.forEach((pos, task) -> {
            if (!task.StillValid()) {
                this.waitingTasks.remove(pos);
                task.future.complete(WorldGenResult.CreateFail());
            }
        });
        Mapper closestTaskMap = this.waitingTasks.reduceEntries(1024L, entry -> new Mapper((WorldGenTask)entry.getValue(), DhSectionPos.getSectionBBoxPos(((WorldGenTask)entry.getValue()).pos).getCenterBlockPos().toPos2D().chebyshevDist(targetPos.toPos2D())), (aMapper, bMapper) -> aMapper.dist < bMapper.dist ? aMapper : bMapper);
        if (closestTaskMap == null) {
            return false;
        }
        WorldGenTask closestTask = closestTaskMap.task;
        this.waitingTasks.remove(closestTask.pos, closestTask);
        if (this.canGeneratePos((byte)0, closestTask.pos)) {
            InProgressWorldGenTaskGroup newTaskGroup;
            boolean taskStarted;
            WorldGenTaskGroup closestTaskGroup = new WorldGenTaskGroup(closestTask.pos, 0);
            closestTaskGroup.worldGenTasks.add(closestTask);
            if (this.inProgressGenTasksByLodPos.containsKey(closestTask.pos) || !(taskStarted = this.tryStartingWorldGenTaskGroup(newTaskGroup = new InProgressWorldGenTaskGroup(closestTaskGroup)))) {
                // empty if block
            }
            return true;
        }
        LinkedList<CompletableFuture<WorldGenResult>> childFutures = new LinkedList<CompletableFuture<WorldGenResult>>();
        long sectionPos = closestTask.pos;
        WorldGenTask finalClosestTask = closestTask;
        DhSectionPos.forEachChild(sectionPos, childDhSectionPos -> {
            CompletableFuture<WorldGenResult> newFuture = new CompletableFuture<WorldGenResult>();
            childFutures.add(newFuture);
            WorldGenTask newGenTask = new WorldGenTask(childDhSectionPos, DhSectionPos.getDetailLevel(childDhSectionPos), finalClosestTask.taskTracker, newFuture);
            this.waitingTasks.put(newGenTask.pos, newGenTask);
        });
        closestTask.future.complete(WorldGenResult.CreateSplit(childFutures));
        return true;
    }

    private boolean tryStartingWorldGenTaskGroup(InProgressWorldGenTaskGroup newTaskGroup) {
        byte taskDetailLevel = newTaskGroup.group.dataDetail;
        long taskPos = newTaskGroup.group.pos;
        byte granularity = (byte)(DhSectionPos.getDetailLevel(taskPos) - taskDetailLevel);
        LodUtil.assertTrue(granularity >= this.minGranularity && granularity <= this.maxGranularity);
        LodUtil.assertTrue(taskDetailLevel >= this.highestDataDetail && taskDetailLevel <= this.lowestDataDetail);
        DhChunkPos chunkPosMin = new DhChunkPos(DhSectionPos.getSectionBBoxPos(taskPos).getCornerBlockPos());
        if (this.alreadyGeneratedPosHashSet.containsKey(newTaskGroup.group.pos)) {
            newTaskGroup.group.worldGenTasks.forEach(worldGenTask -> worldGenTask.future.complete(WorldGenResult.CreateSuccess(DhSectionPos.encode(granularity, DhSectionPos.getX(taskPos), DhSectionPos.getZ(taskPos)))));
            return false;
        }
        this.alreadyGeneratedPosHashSet.put(newTaskGroup.group.pos, Thread.currentThread().getStackTrace());
        this.alreadyGeneratedPosQueue.enqueue(newTaskGroup.group.pos);
        while (this.alreadyGeneratedPosQueue.size() > 100) {
            long posToRemove = this.alreadyGeneratedPosQueue.dequeueLong();
            this.alreadyGeneratedPosHashSet.remove(posToRemove);
        }
        ++this.numberOfTasksQueued;
        newTaskGroup.genFuture = this.startGenerationEvent(chunkPosMin, granularity, taskDetailLevel, newTaskGroup.group::consumeChunkData);
        LodUtil.assertTrue(newTaskGroup.genFuture != null);
        newTaskGroup.genFuture.whenComplete((voidObj, exception) -> {
            try {
                --this.numberOfTasksQueued;
                if (exception != null) {
                    if (!LodUtil.isInterruptOrReject(exception)) {
                        LOGGER.error("Error generating data for pos: " + DhSectionPos.toString(taskPos), exception);
                    }
                    newTaskGroup.group.worldGenTasks.forEach(worldGenTask -> worldGenTask.future.complete(WorldGenResult.CreateFail()));
                } else {
                    newTaskGroup.group.worldGenTasks.forEach(worldGenTask -> worldGenTask.future.complete(WorldGenResult.CreateSuccess(DhSectionPos.encode(granularity, DhSectionPos.getX(taskPos), DhSectionPos.getZ(taskPos)))));
                }
                boolean worked = this.inProgressGenTasksByLodPos.remove(taskPos, newTaskGroup);
                LodUtil.assertTrue(worked, "Unable to find in progress generator task with position [" + DhSectionPos.toString(taskPos) + "]");
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error completing world gen task at pos: [" + DhSectionPos.toString(taskPos) + "].", (Throwable)e);
            }
        });
        this.inProgressGenTasksByLodPos.put(taskPos, newTaskGroup);
        return true;
    }

    private CompletableFuture<Void> startGenerationEvent(DhChunkPos chunkPosMin, byte granularity, byte targetDataDetail, Consumer<FullDataSourceV2> chunkDataConsumer) {
        EDhApiDistantGeneratorMode generatorMode = Config.Client.Advanced.WorldGenerator.distantGeneratorMode.get();
        EDhApiWorldGeneratorReturnType returnType = this.generator.getReturnType();
        switch (returnType) {
            case VANILLA_CHUNKS: {
                return this.generator.generateChunks(chunkPosMin.getX(), chunkPosMin.getZ(), granularity, targetDataDetail, generatorMode, ThreadPoolUtil.getWorldGenExecutor(), generatedObjectArray -> {
                    try {
                        IChunkWrapper chunk = WRAPPER_FACTORY.createChunkWrapper((Object[])generatedObjectArray);
                        FullDataSourceV2 dataSource = LodDataBuilder.createFromChunk(chunk);
                        LodUtil.assertTrue(dataSource != null);
                        chunkDataConsumer.accept(dataSource);
                    }
                    catch (ClassCastException e) {
                        LOGGER.error("World generator return type incorrect. Error: [" + e.getMessage() + "]. World generator disabled.", (Throwable)e);
                        Config.Client.Advanced.WorldGenerator.enableDistantGeneration.set(false);
                    }
                });
            }
            case API_CHUNKS: {
                return this.generator.generateApiChunks(chunkPosMin.getX(), chunkPosMin.getZ(), granularity, targetDataDetail, generatorMode, ThreadPoolUtil.getWorldGenExecutor(), dataPoints -> {
                    try {
                        FullDataSourceV2 dataSource = LodDataBuilder.createFromApiChunkData(dataPoints, this.generator.runApiChunkValidation());
                        chunkDataConsumer.accept(dataSource);
                    }
                    catch (DataCorruptedException | IllegalArgumentException e) {
                        LOGGER.error("World generator returned a corrupt chunk. Error: [" + e.getMessage() + "]. World generator disabled.", (Throwable)e);
                        Config.Client.Advanced.WorldGenerator.enableDistantGeneration.set(false);
                    }
                    catch (ClassCastException e) {
                        LOGGER.error("World generator return type incorrect. Error: [" + e.getMessage() + "]. World generator disabled.", (Throwable)e);
                        Config.Client.Advanced.WorldGenerator.enableDistantGeneration.set(false);
                    }
                });
            }
        }
        Config.Client.Advanced.WorldGenerator.enableDistantGeneration.set(false);
        throw new LodUtil.AssertFailureException("Unknown return type: " + (Object)((Object)returnType));
    }

    @Override
    public int getWaitingTaskCount() {
        return this.waitingTasks.size();
    }

    @Override
    public int getInProgressTaskCount() {
        return this.inProgressGenTasksByLodPos.size();
    }

    @Override
    public byte lowestDataDetail() {
        return this.lowestDataDetail;
    }

    @Override
    public byte highestDataDetail() {
        return this.highestDataDetail;
    }

    @Override
    public int getEstimatedTotalTaskCount() {
        return this.estimatedTotalTaskCount;
    }

    @Override
    public void setEstimatedTotalTaskCount(int newEstimate) {
        this.estimatedTotalTaskCount = newEstimate;
    }

    @Override
    public void addDebugMenuStringsToList(List<String> messageList) {
    }

    @Override
    public CompletableFuture<Void> startClosingAsync(boolean cancelCurrentGeneration, boolean alsoInterruptRunning) {
        LOGGER.info("Closing world gen queue");
        this.queueingThread.shutdownNow();
        ArrayList inProgressTasksCancelingFutures = new ArrayList(this.inProgressGenTasksByLodPos.size());
        this.inProgressGenTasksByLodPos.values().forEach(runningTaskGroup -> {
            CompletableFuture<Void> genFuture = runningTaskGroup.genFuture;
            if (genFuture == null) {
                LOGGER.info("Null gen future: " + runningTaskGroup.group.pos);
                return;
            }
            if (cancelCurrentGeneration) {
                genFuture.cancel(alsoInterruptRunning);
            }
            inProgressTasksCancelingFutures.add(genFuture.handle((voidObj, exception) -> {
                if (exception instanceof CompletionException) {
                    exception = exception.getCause();
                }
                if (!UncheckedInterruptedException.isInterrupt(exception) && !(exception instanceof CancellationException)) {
                    LOGGER.error("Error when terminating data generation for section " + runningTaskGroup.group.pos, exception);
                }
                return null;
            }));
        });
        this.generatorClosingFuture = CompletableFuture.allOf(inProgressTasksCancelingFutures.toArray(new CompletableFuture[0]));
        return this.generatorClosingFuture;
    }

    @Override
    public void close() {
        LOGGER.info("Closing " + WorldGenerationQueue.class.getSimpleName() + "...");
        if (this.generatorClosingFuture == null) {
            this.startClosingAsync(true, true);
        }
        LodUtil.assertTrue(this.generatorClosingFuture != null);
        LOGGER.info("Awaiting world generator thread pool termination...");
        try {
            int waitTimeInSeconds = 3;
            ThreadPoolExecutor executor = ThreadPoolUtil.getWorldGenExecutor();
            if (executor != null && !executor.awaitTermination(waitTimeInSeconds, TimeUnit.SECONDS)) {
                LOGGER.warn("World generator thread pool shutdown didn't complete after [" + waitTimeInSeconds + "] seconds. Some world generator requests may still be running.");
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("World generator thread pool shutdown interrupted! Ignoring child threads...", (Throwable)e);
        }
        this.generator.close();
        DebugRenderer.unregister(this, Config.Client.Advanced.Debugging.DebugWireframe.showWorldGenQueue);
        try {
            this.generatorClosingFuture.cancel(true);
        }
        catch (Throwable e) {
            LOGGER.warn("Failed to close generation queue: ", e);
        }
        LOGGER.info("Finished closing " + WorldGenerationQueue.class.getSimpleName());
    }

    @Override
    public void debugRender(DebugRenderer renderer) {
        ((ConcurrentHashMap.KeySetView)this.waitingTasks.keySet()).forEach(pos -> renderer.renderBox(new DebugRenderer.Box((long)pos, -32.0f, 64.0f, 0.05f, Color.blue)));
        this.inProgressGenTasksByLodPos.forEach((pos, t) -> renderer.renderBox(new DebugRenderer.Box((long)pos, -32.0f, 64.0f, 0.05f, Color.red)));
    }

    private boolean canGeneratePos(byte worldGenTaskGroupDetailLevel, long taskPos) {
        byte granularity = (byte)(DhSectionPos.getDetailLevel(taskPos) - worldGenTaskGroupDetailLevel);
        return granularity >= this.minGranularity && granularity <= this.maxGranularity;
    }

    private static int gridSpiralIndexing(int X, int Y) {
        int index = 0;
        if (X * X >= Y * Y) {
            index = 4 * X * X - X - Y;
            if (X < Y) {
                index -= 2 * (X - Y);
            }
        } else {
            index = 4 * Y * Y - X - Y;
            if (X < Y) {
                index += 2 * (X - Y);
            }
        }
        return index;
    }

    private static class Mapper {
        public final WorldGenTask task;
        public final int dist;

        public Mapper(WorldGenTask task, int dist) {
            this.task = task;
            this.dist = dist;
        }
    }
}

