/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.jar;

import com.seibel.distanthorizons.core.jar.DarkModeDetector;
import com.seibel.distanthorizons.core.jar.EPlatform;
import com.seibel.distanthorizons.core.jar.JarDependencySetup;
import com.seibel.distanthorizons.core.jar.JarUtils;
import com.seibel.distanthorizons.core.jar.gui.BaseJFrame;
import com.seibel.distanthorizons.core.jar.gui.cusomJObject.JBox;
import com.seibel.distanthorizons.core.jar.installer.ModrinthGetter;
import com.seibel.distanthorizons.core.jar.installer.WebDownloader;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;

public class JarMain {
    public static final Logger logger = LogManager.getLogger((String)JarMain.class.getSimpleName());
    public static List<String> programArgs;
    public static final boolean isDarkTheme;
    public static boolean isOffline;

    public static void main(String[] args) {
        programArgs = Arrays.asList(args);
        if (!programArgs.contains("--no-custom-logger")) {
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            try {
                context.setConfigLocation(JarUtils.accessFileURI("/log4jConfig.xml"));
            }
            catch (Exception e) {
                logger.error("Failed to set log4j config. Try running with the \"--no-custom-logger\" argument");
                e.printStackTrace();
            }
        }
        logger.debug("Running Distant Horizons standalone jar");
        logger.warn("The standalone jar is still a massive WIP, expect bugs");
        logger.debug("Java version " + System.getProperty("java.version"));
        if (JarUtils.accessFile("assets/lod/lang/" + Locale.getDefault().toString().toLowerCase() + ".json") == null) {
            logger.warn("The language setting [" + Locale.getDefault().toString().toLowerCase() + "] isn't allowed yet. Defaulting to [" + Locale.US.toString().toLowerCase() + "].");
            Locale.setDefault(Locale.US);
        }
        JarDependencySetup.createInitialBindings();
        if (args.length == 0 || Arrays.asList(args).contains("--gui")) {
            JarMain.startGUI();
            return;
        }
    }

    public static void startGUI() {
        ModrinthGetter.init();
        System.out.println("WARNING: The standalone jar still work in progress");
        BaseJFrame frame = new BaseJFrame(false, true);
        frame.addExtraButtons(frame.getWidth(), 0, true, false);
        GridBagConstraints verticalLayout = new GridBagConstraints();
        verticalLayout.gridy = -1;
        verticalLayout.gridx = 0;
        verticalLayout.fill = 2;
        verticalLayout.weightx = 1.0;
        verticalLayout.anchor = 11;
        AtomicReference<String> downloadID = new AtomicReference<String>("");
        JPanel modVersionDescriptionPanel = new JPanel(new GridBagLayout());
        JScrollPane modVersionDescriptionScroll = new JScrollPane(modVersionDescriptionPanel, 20, 31);
        int modDescriptionWidth = 275;
        modVersionDescriptionScroll.setBounds(frame.getWidth() - modDescriptionWidth, 225, modDescriptionWidth, frame.getHeight() - 255);
        modVersionDescriptionScroll.setBorder(null);
        modVersionDescriptionScroll.setWheelScrollingEnabled(true);
        JLabel modVersionDescriptionLabel = new JLabel();
        modVersionDescriptionPanel.add((Component)modVersionDescriptionLabel, verticalLayout);
        frame.add(modVersionDescriptionScroll);
        JPanel modMinecraftVersionsPannel = new JPanel(new GridBagLayout());
        JScrollPane modMinecraftVersionsScroll = new JScrollPane(modMinecraftVersionsPannel, 22, 31);
        modMinecraftVersionsScroll.setBounds(0, 225, 125, frame.getHeight() - 255);
        modMinecraftVersionsScroll.setBorder(null);
        modMinecraftVersionsScroll.setWheelScrollingEnabled(true);
        ArrayList<JButton> modMinecraftReleaseButtons = new ArrayList<JButton>();
        frame.add(modMinecraftVersionsScroll);
        JPanel modVersionsPannel = new JPanel(new GridBagLayout());
        JScrollPane modVersionsScroll = new JScrollPane(modVersionsPannel, 20, 31);
        modVersionsScroll.setBounds(125, 225, 100, frame.getHeight() - 255);
        modVersionsScroll.setBorder(null);
        modVersionsScroll.setWheelScrollingEnabled(true);
        ArrayList modReleaseButtons = new ArrayList();
        frame.add(modVersionsScroll);
        for (String mcVer : ModrinthGetter.mcVersions) {
            JButton btn = new JButton(mcVer);
            btn.setBackground(UIManager.getColor("Panel.background"));
            btn.setBorderPainted(false);
            btn.addActionListener(e -> {
                for (JButton currentBtn : modMinecraftReleaseButtons) {
                    currentBtn.setBackground(UIManager.getColor("Panel.background"));
                }
                btn.setBackground(UIManager.getColor("Button.background"));
                modVersionsPannel.removeAll();
                modReleaseButtons.clear();
                for (String modID : ModrinthGetter.mcVerToReleaseID.get(mcVer)) {
                    JButton btnDownload = new JButton(ModrinthGetter.releaseNames.get(modID));
                    btnDownload.setBackground(UIManager.getColor("Panel.background"));
                    btnDownload.setBorderPainted(false);
                    btnDownload.setHorizontalAlignment(2);
                    btnDownload.addActionListener(f -> {
                        downloadID.set(modID);
                        for (JButton currentBtn : modReleaseButtons) {
                            currentBtn.setBackground(UIManager.getColor("Panel.background"));
                        }
                        btnDownload.setBackground(UIManager.getColor("Button.background"));
                        modVersionDescriptionLabel.setText(WebDownloader.formatMarkdownToHtml(ModrinthGetter.changeLogs.get(modID), modDescriptionWidth - 75));
                        modVersionDescriptionPanel.repaint();
                    });
                    modVersionsPannel.add((Component)btnDownload, verticalLayout);
                    modReleaseButtons.add(btnDownload);
                }
                modVersionsScroll.getVerticalScrollBar().setValue(0);
                modVersionsPannel.repaint();
                frame.validate();
            });
            modMinecraftVersionsPannel.add((Component)btn, verticalLayout);
            modMinecraftReleaseButtons.add(btn);
        }
        frame.add(new JBox(UIManager.getColor("Separator.foreground"), 0, 220, frame.getWidth(), 5));
        JLabel textMcVersionHeader = new JLabel("Minecraft version");
        textMcVersionHeader.setBounds(0, 200, 125, 20);
        frame.add(textMcVersionHeader);
        JLabel textVersionHeader = new JLabel("Mod version");
        textVersionHeader.setBounds(125, 200, 150, 20);
        frame.add(textVersionHeader);
        JFileChooser minecraftDirPop = new JFileChooser();
        switch (EPlatform.get()) {
            case WINDOWS: {
                minecraftDirPop.setCurrentDirectory(new File(System.getenv("APPDATA") + "/.minecraft/mods"));
            }
            case LINUX: {
                minecraftDirPop.setCurrentDirectory(new File(System.getProperty("user.home") + "/.minecraft/mods"));
            }
        }
        minecraftDirPop.setFileSelectionMode(1);
        JButton minecraftDirBtn = new JButton("Click to select install path");
        minecraftDirBtn.addActionListener(e -> {
            if (minecraftDirPop.showOpenDialog(frame) == 0) {
                minecraftDirBtn.setText(minecraftDirPop.getSelectedFile().toString());
            }
        });
        minecraftDirBtn.setBounds(230, frame.getHeight() - 100, 200, 20);
        frame.add(minecraftDirBtn);
        JButton installMod = new JButton("Install Distant Horizons");
        installMod.setBounds(230, frame.getHeight() - 70, 200, 20);
        installMod.addActionListener(e -> {
            if (minecraftDirPop.getSelectedFile() == null) {
                JOptionPane.showMessageDialog(frame, "Please select your install directory", "Distant Horizons", 2);
                return;
            }
            URL downloadPath = ModrinthGetter.downloadUrl.get(downloadID.get());
            try {
                WebDownloader.downloadAsFile(downloadPath, minecraftDirPop.getSelectedFile().toPath().resolve("DistantHorizons-" + ModrinthGetter.releaseNames.get(downloadID.get()) + ".jar").toFile());
                JOptionPane.showMessageDialog(frame, "Installation done. \nYou can now close the installer", "Distant Horizons", 1);
            }
            catch (Exception f) {
                JOptionPane.showMessageDialog(frame, "Download failed. Check your internet connection \nStacktrace: " + f.getMessage(), "Distant Horizons", 0);
            }
        });
        frame.add(installMod);
        frame.addLogo();
        frame.validate();
        frame.setVisible(true);
    }

    static {
        isDarkTheme = DarkModeDetector.isDarkMode();
        isOffline = WebDownloader.netIsAvailable();
    }
}

