/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.level;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.file.fullDatafile.FullDataSourceProviderV2;
import com.seibel.distanthorizons.core.file.structure.AbstractSaveStructure;
import com.seibel.distanthorizons.core.level.AbstractDhLevel;
import com.seibel.distanthorizons.core.level.IDhServerLevel;
import com.seibel.distanthorizons.core.level.ServerLevelModule;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.multiplayer.server.ServerPlayerState;
import com.seibel.distanthorizons.core.multiplayer.server.ServerPlayerStateManager;
import com.seibel.distanthorizons.core.network.exceptions.InvalidLevelException;
import com.seibel.distanthorizons.core.network.exceptions.RequestRejectedException;
import com.seibel.distanthorizons.core.network.messages.AbstractNetworkMessage;
import com.seibel.distanthorizons.core.network.messages.AbstractTrackableMessage;
import com.seibel.distanthorizons.core.network.messages.ILevelRelatedMessage;
import com.seibel.distanthorizons.core.network.messages.fullData.FullDataPartialUpdateMessage;
import com.seibel.distanthorizons.core.network.messages.fullData.FullDataPayload;
import com.seibel.distanthorizons.core.network.messages.fullData.FullDataSourceRequestMessage;
import com.seibel.distanthorizons.core.network.messages.fullData.FullDataSourceResponseMessage;
import com.seibel.distanthorizons.core.network.messages.requests.CancelMessage;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.sql.repo.FullDataSourceV2Repo;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.math.Vec3d;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.IServerPlayerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractDhServerLevel
extends AbstractDhLevel
implements IDhServerLevel {
    protected static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final ConfigBasedLogger NETWORK_LOGGER = new ConfigBasedLogger(LogManager.getLogger(), () -> Config.Client.Advanced.Logging.logNetworkEvent.get());
    public static final int FULL_DATA_SPLIT_SIZE_IN_BYTES = 1048000;
    public final ServerLevelModule serverside;
    protected final IServerLevelWrapper serverLevelWrapper;
    protected final ServerPlayerStateManager serverPlayerStateManager;
    protected final ConcurrentLinkedQueue<IServerPlayerWrapper> worldGenPlayerCenteringQueue = new ConcurrentLinkedQueue();
    private final ConcurrentMap<Long, DataSourceRequestGroup> requestGroupByPos = new ConcurrentHashMap<Long, DataSourceRequestGroup>();
    private final ConcurrentMap<Long, DataSourceRequestGroup> requestGroupByFutureId = new ConcurrentHashMap<Long, DataSourceRequestGroup>();

    public AbstractDhServerLevel(AbstractSaveStructure saveStructure, IServerLevelWrapper serverLevelWrapper, ServerPlayerStateManager serverPlayerStateManager) {
        this(saveStructure, serverLevelWrapper, serverPlayerStateManager, true);
    }

    public AbstractDhServerLevel(AbstractSaveStructure saveStructure, IServerLevelWrapper serverLevelWrapper, ServerPlayerStateManager serverPlayerStateManager, boolean runRepoReliantSetup) {
        if (saveStructure.getFullDataFolder(serverLevelWrapper).mkdirs()) {
            LOGGER.warn("unable to create data folder.");
        }
        this.serverLevelWrapper = serverLevelWrapper;
        this.serverside = new ServerLevelModule(this, saveStructure);
        this.createAndSetSupportingRepos(((FullDataSourceV2Repo)this.serverside.fullDataFileHandler.repo).databaseFile);
        if (runRepoReliantSetup) {
            this.runRepoReliantSetup();
        }
        LOGGER.info("Started " + this.getClass().getSimpleName() + " for " + serverLevelWrapper + " at " + saveStructure + ".");
        this.serverPlayerStateManager = serverPlayerStateManager;
    }

    @Override
    public void serverTick() {
        for (Map.Entry entry : this.requestGroupByPos.entrySet()) {
            DataSourceRequestGroup requestGroup = (DataSourceRequestGroup)entry.getValue();
            if (requestGroup.fullDataSource == null) continue;
            NETWORK_LOGGER.debug("[" + this.serverLevelWrapper.getDimensionName() + "] Fulfilled request group [" + entry.getKey() + "]", new Object[0]);
            this.requestGroupByPos.remove(entry.getKey());
            requestGroup.requestRemoveSemaphore.acquireUninterruptibly(Short.MAX_VALUE);
            requestGroup.requestAddSemaphore.acquireUninterruptibly(Short.MAX_VALUE);
            ThreadPoolExecutor executor = ThreadPoolUtil.getNetworkCompressionExecutor();
            if (executor == null) {
                LOGGER.warn("Unable to send FullDataSourceResponseMessage - getNetworkCompressionExecutor() is null");
                continue;
            }
            CompletableFuture.runAsync(() -> {
                FullDataPayload payload = new FullDataPayload(requestGroup.fullDataSource);
                for (FullDataSourceRequestMessage msg : requestGroup.requestMessages.values()) {
                    this.requestGroupByFutureId.remove(msg.futureId);
                    ServerPlayerState serverPlayerState = this.serverPlayerStateManager.getConnectedPlayer(msg.serverPlayer());
                    if (serverPlayerState == null) continue;
                    serverPlayerState.getRateLimiterSet((AbstractDhServerLevel)this).generationRequestRateLimiter.release();
                    payload.splitAndSend(1048000, msg.getSession()::sendMessage);
                    msg.sendResponse(new FullDataSourceResponseMessage(payload));
                }
            }, executor);
        }
    }

    @Override
    public boolean shouldDoWorldGen() {
        return Config.Client.Advanced.WorldGenerator.enableDistantGeneration.get() != false && !this.worldGenPlayerCenteringQueue.isEmpty();
    }

    @Override
    @Nullable
    public DhBlockPos2D getTargetPosForGeneration() {
        IServerPlayerWrapper firstPlayer = this.worldGenPlayerCenteringQueue.peek();
        if (firstPlayer == null) {
            return null;
        }
        this.worldGenPlayerCenteringQueue.add(firstPlayer);
        this.worldGenPlayerCenteringQueue.remove(firstPlayer);
        Vec3d position = firstPlayer.getPosition();
        return new DhBlockPos2D((int)position.x, (int)position.z);
    }

    @Override
    public void worldGenTick() {
        this.serverside.worldGenModule.worldGenTick();
    }

    public void registerNetworkHandlers(ServerPlayerState serverPlayerState) {
        serverPlayerState.networkSession.registerHandler(FullDataSourceRequestMessage.class, message -> {
            if (!this.messagePlayerInThisLevel(message)) {
                return;
            }
            ServerPlayerState.RateLimiterSet rateLimiterSet = serverPlayerState.getRateLimiterSet(this);
            if (message.clientTimestamp == null) {
                this.queueWorldGenForRequestMessage(serverPlayerState, (FullDataSourceRequestMessage)message, rateLimiterSet);
            } else {
                this.queueLodSyncForRequestMessage(serverPlayerState, (FullDataSourceRequestMessage)message, rateLimiterSet);
            }
        });
        serverPlayerState.networkSession.registerHandler(CancelMessage.class, msg -> {
            DataSourceRequestGroup requestGroup = (DataSourceRequestGroup)this.requestGroupByFutureId.remove(msg.futureId);
            if (requestGroup == null) {
                return;
            }
            if (requestGroup.requestRemoveSemaphore.tryAcquire()) {
                requestGroup.requestAddSemaphore.acquireUninterruptibly(Short.MAX_VALUE);
                requestGroup.requestRemoveSemaphore.release();
                serverPlayerState.getRateLimiterSet((AbstractDhServerLevel)this).generationRequestRateLimiter.release();
                FullDataSourceRequestMessage requestMessage = (FullDataSourceRequestMessage)requestGroup.requestMessages.remove(msg.futureId);
                if (requestGroup.requestMessages.isEmpty()) {
                    NETWORK_LOGGER.debug("[" + this.serverLevelWrapper.getDimensionName() + "] Cancelled request group [" + DhSectionPos.toString(requestMessage.sectionPos) + "].", new Object[0]);
                    this.requestGroupByPos.remove(requestMessage.sectionPos);
                    this.serverside.fullDataFileHandler.removeRetrievalRequestIf(pos -> pos == requestMessage.sectionPos);
                } else {
                    requestGroup.requestAddSemaphore.release(Short.MAX_VALUE);
                }
            }
        });
    }

    private void queueLodSyncForRequestMessage(ServerPlayerState serverPlayerState, FullDataSourceRequestMessage message, ServerPlayerState.RateLimiterSet rateLimiterSet) {
        if (!serverPlayerState.sessionConfig.getSynchronizeOnLogin()) {
            message.sendResponse(new RequestRejectedException("Operation is disabled in config."));
            return;
        }
        if (!rateLimiterSet.syncOnLoginRateLimiter.tryAcquire(message)) {
            return;
        }
        long clientTimestamp = message.clientTimestamp != null ? message.clientTimestamp : -1L;
        Long serverTimestamp = this.serverside.fullDataFileHandler.getTimestampForPos(message.sectionPos);
        if (serverTimestamp == null || serverTimestamp <= clientTimestamp) {
            rateLimiterSet.syncOnLoginRateLimiter.release();
            message.sendResponse(new FullDataSourceResponseMessage(null));
            return;
        }
        ThreadPoolExecutor executor = ThreadPoolUtil.getNetworkCompressionExecutor();
        if (executor == null) {
            LOGGER.warn("Unable to send FullDataSourceResponseMessage - getNetworkCompressionExecutor() is null");
            return;
        }
        this.serverside.fullDataFileHandler.getAsync(message.sectionPos).thenAcceptAsync(fullDataSource -> {
            rateLimiterSet.syncOnLoginRateLimiter.release();
            FullDataPayload payload = new FullDataPayload((FullDataSourceV2)fullDataSource);
            payload.splitAndSend(1048000, message.getSession()::sendMessage);
            message.sendResponse(new FullDataSourceResponseMessage(payload));
        }, (Executor)executor);
    }

    private void queueWorldGenForRequestMessage(ServerPlayerState serverPlayerState, FullDataSourceRequestMessage message, ServerPlayerState.RateLimiterSet rateLimiterSet) {
        DataSourceRequestGroup requestGroup;
        if (!serverPlayerState.sessionConfig.isDistantGenerationEnabled()) {
            message.sendResponse(new RequestRejectedException("Operation is disabled in config."));
            return;
        }
        if (!rateLimiterSet.generationRequestRateLimiter.tryAcquire(message)) {
            return;
        }
        while (true) {
            requestGroup = this.requestGroupByPos.computeIfAbsent(message.sectionPos, pos -> {
                DataSourceRequestGroup newGroup = new DataSourceRequestGroup();
                this.tryFulfillDataSourceRequestGroup(newGroup, (long)pos);
                NETWORK_LOGGER.debug("[" + this.serverLevelWrapper.getDimensionName() + "] Created request group for pos [" + DhSectionPos.toString(pos) + "].", new Object[0]);
                return newGroup;
            });
            if (requestGroup.requestAddSemaphore.tryAcquire()) break;
            Thread.yield();
        }
        this.requestGroupByFutureId.put(message.futureId, requestGroup);
        requestGroup.requestMessages.put(message.futureId, message);
        requestGroup.requestAddSemaphore.release();
    }

    private <T extends AbstractNetworkMessage> boolean messagePlayerInThisLevel(T message) {
        if (!(message instanceof ILevelRelatedMessage)) {
            LodUtil.assertNotReach("Received message [" + message + "] does not implement [" + ILevelRelatedMessage.class.getSimpleName() + "]");
        }
        if (!((ILevelRelatedMessage)((Object)message)).isSameLevelAs(this.getServerLevelWrapper())) {
            return false;
        }
        LodUtil.assertTrue(message.getSession().serverPlayer != null);
        if (message.getSession().serverPlayer.getLevel() != this.getLevelWrapper()) {
            if (message instanceof AbstractTrackableMessage) {
                ((AbstractTrackableMessage)message).sendResponse(new InvalidLevelException("Generation not allowed. Requested dimension: [" + ((ILevelRelatedMessage)((Object)message)).getLevelName() + "], player dimension: [" + message.getSession().serverPlayer.getLevel().getDimensionName() + "], handler dimension: [" + this.getLevelWrapper().getDimensionName() + "]"));
            }
            return false;
        }
        return true;
    }

    @Override
    public void onWorldGenTaskComplete(long pos) {
        DataSourceRequestGroup requestGroup = (DataSourceRequestGroup)this.requestGroupByPos.get(pos);
        if (requestGroup != null) {
            this.tryFulfillDataSourceRequestGroup(requestGroup, pos);
        }
    }

    private void tryFulfillDataSourceRequestGroup(DataSourceRequestGroup requestGroup, long pos) {
        this.serverside.fullDataFileHandler.getAsync(pos).thenAccept(fullDataSource -> {
            if (this.serverside.fullDataFileHandler.isFullyGenerated(fullDataSource.columnGenerationSteps)) {
                requestGroup.fullDataSource = fullDataSource;
            } else {
                this.serverside.fullDataFileHandler.queuePositionForRetrieval(pos);
            }
        });
    }

    public void addPlayer(IServerPlayerWrapper serverPlayer) {
        this.worldGenPlayerCenteringQueue.add(serverPlayer);
    }

    public void removePlayer(IServerPlayerWrapper serverPlayer) {
        this.worldGenPlayerCenteringQueue.remove(serverPlayer);
    }

    @Override
    public CompletableFuture<Void> updateDataSourcesAsync(FullDataSourceV2 data) {
        if (!Config.Client.Advanced.Multiplayer.ServerNetworking.enableRealTimeUpdates.get().booleanValue()) {
            return this.getFullDataProvider().updateDataSourceAsync(data);
        }
        ThreadPoolExecutor executor = ThreadPoolUtil.getNetworkCompressionExecutor();
        if (executor == null) {
            LOGGER.warn("Unable to send FullDataPartialUpdateMessage - getNetworkCompressionExecutor() is null");
            return this.getFullDataProvider().updateDataSourceAsync(data);
        }
        CompletableFuture.runAsync(() -> {
            FullDataPayload payload = new FullDataPayload(data);
            for (ServerPlayerState serverPlayerState : this.serverPlayerStateManager.getConnectedPlayers()) {
                if (serverPlayerState.getServerPlayer().getLevel() != this.serverLevelWrapper || !serverPlayerState.sessionConfig.isRealTimeUpdatesEnabled()) continue;
                Vec3d playerPosition = serverPlayerState.getServerPlayer().getPosition();
                int distanceFromPlayer = DhSectionPos.getManhattanBlockDistance(data.getPos(), new DhBlockPos2D((int)playerPosition.x, (int)playerPosition.z)) / 16;
                if (distanceFromPlayer < serverPlayerState.getServerPlayer().getViewDistance() || distanceFromPlayer > serverPlayerState.sessionConfig.getRenderDistanceRadius()) continue;
                payload.splitAndSend(1048000, serverPlayerState.networkSession::sendMessage);
                serverPlayerState.networkSession.sendMessage(new FullDataPartialUpdateMessage(this.serverLevelWrapper, payload));
            }
        }, executor);
        return this.getFullDataProvider().updateDataSourceAsync(data);
    }

    @Override
    public int getMinY() {
        return this.getLevelWrapper().getMinHeight();
    }

    @Override
    public IServerLevelWrapper getServerLevelWrapper() {
        return this.serverLevelWrapper;
    }

    @Override
    public ILevelWrapper getLevelWrapper() {
        return this.getServerLevelWrapper();
    }

    @Override
    public FullDataSourceProviderV2 getFullDataProvider() {
        return this.serverside.fullDataFileHandler;
    }

    @Override
    public AbstractSaveStructure getSaveStructure() {
        return this.serverside.saveStructure;
    }

    @Override
    public boolean hasSkyLight() {
        return this.serverLevelWrapper.hasSkyLight();
    }

    @Override
    public void close() {
        super.close();
        this.serverside.close();
        LOGGER.info("Closed DHLevel for [" + this.getLevelWrapper() + "].");
    }

    private static class DataSourceRequestGroup {
        public final ConcurrentMap<Long, FullDataSourceRequestMessage> requestMessages = new ConcurrentHashMap<Long, FullDataSourceRequestMessage>();
        @CheckForNull
        public FullDataSourceV2 fullDataSource;
        public final Semaphore requestAddSemaphore = new Semaphore(Short.MAX_VALUE, true);
        public final Semaphore requestRemoveSemaphore = new Semaphore(Short.MAX_VALUE, true);

        private DataSourceRequestGroup() {
        }
    }
}

