/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.level;

import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiRenderParam;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.file.structure.AbstractSaveStructure;
import com.seibel.distanthorizons.core.level.AbstractDhServerLevel;
import com.seibel.distanthorizons.core.level.ClientLevelModule;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.logging.f3.F3Screen;
import com.seibel.distanthorizons.core.multiplayer.server.ServerPlayerStateManager;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.render.RenderBufferHandler;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.render.renderer.generic.GenericObjectRenderer;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IProfilerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import java.awt.Color;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class DhClientServerLevel
extends AbstractDhServerLevel
implements IDhClientLevel {
    private static final IMinecraftClientWrapper MC_CLIENT = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    public final ClientLevelModule clientside;

    public DhClientServerLevel(AbstractSaveStructure saveStructure, IServerLevelWrapper serverLevelWrapper, ServerPlayerStateManager serverPlayerStateManager) {
        super(saveStructure, serverLevelWrapper, serverPlayerStateManager, false);
        this.serverLevelWrapper.setParentLevel(this);
        this.clientside = new ClientLevelModule(this);
        this.runRepoReliantSetup();
    }

    @Override
    public void clientTick() {
        this.clientside.clientTick();
    }

    @Override
    public void render(DhApiRenderParam renderEventParam, IProfilerWrapper profiler) {
        this.clientside.render(renderEventParam, profiler);
    }

    @Override
    public void renderDeferred(DhApiRenderParam renderEventParam, IProfilerWrapper profiler) {
        this.clientside.renderDeferred(renderEventParam, profiler);
    }

    public void startRenderer(IClientLevelWrapper clientLevel) {
        this.clientside.startRenderer(clientLevel);
    }

    public void stopRenderer() {
        this.clientside.stopRenderer();
    }

    @Override
    public int computeBaseColor(DhBlockPos pos, IBiomeWrapper biome, IBlockStateWrapper block) {
        IClientLevelWrapper clientLevel = this.getClientLevelWrapper();
        if (clientLevel == null) {
            return 0;
        }
        return clientLevel.getBlockColor(pos, biome, block);
    }

    @Override
    public IClientLevelWrapper getClientLevelWrapper() {
        return MC_CLIENT.getWrappedClientLevel();
    }

    @Override
    public void clearRenderCache() {
        this.clientside.clearRenderCache();
    }

    @Override
    public CompletableFuture<Void> updateDataSourcesAsync(FullDataSourceV2 data) {
        return CompletableFuture.allOf(super.updateDataSourcesAsync(data), this.clientside.updateDataSourcesAsync(data));
    }

    @Override
    public void addDebugMenuStringsToList(List<String> messageList) {
        String dimName = this.serverLevelWrapper.getDimensionName();
        boolean rendering = this.clientside.isRendering();
        messageList.add("[" + dimName + "] rendering: " + (rendering ? "yes" : "no"));
        boolean migrationErrored = this.serverside.fullDataFileHandler.getMigrationStoppedWithError();
        if (!migrationErrored) {
            long migrationCount;
            long legacyDeletionCount = this.serverside.fullDataFileHandler.getLegacyDeletionCount();
            if (legacyDeletionCount > 0L) {
                messageList.add("  Migrating - Deleting #: " + F3Screen.NUMBER_FORMAT.format(legacyDeletionCount));
            }
            if ((migrationCount = this.serverside.fullDataFileHandler.getTotalMigrationCount()) > 0L) {
                messageList.add("  Migrating - Conversion #: " + F3Screen.NUMBER_FORMAT.format(migrationCount));
            }
        } else {
            messageList.add("  Migration Failed");
        }
        this.serverside.worldGenModule.addDebugMenuStringsToList(messageList);
    }

    @Override
    public GenericObjectRenderer getGenericRenderer() {
        return this.clientside.genericRenderer;
    }

    @Override
    public RenderBufferHandler getRenderBufferHandler() {
        ClientLevelModule.ClientRenderState renderState = this.clientside.ClientRenderStateRef.get();
        return renderState != null ? renderState.renderBufferHandler : null;
    }

    @Override
    public void onWorldGenTaskComplete(long pos) {
        super.onWorldGenTaskComplete(pos);
        DebugRenderer.makeParticle(new DebugRenderer.BoxParticle(new DebugRenderer.Box(pos, 128.0f, 156.0f, 0.09f, Color.red.darker()), 0.2, 32.0f));
        this.clientside.reloadPos(pos);
    }

    public String toString() {
        return "DhClientServerLevel{" + this.serverLevelWrapper.getKeyedLevelDimensionName() + "}";
    }

    @Override
    public void close() {
        this.clientside.close();
        super.close();
        this.serverside.close();
        LOGGER.info("Closed " + this.getClass().getSimpleName() + " for " + this.getServerLevelWrapper());
    }
}

