/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.level;

import com.seibel.distanthorizons.core.file.fullDatafile.GeneratedFullDataSourceProvider;
import com.seibel.distanthorizons.core.generation.IFullDataSourceRetrievalQueue;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.logging.f3.F3Screen;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.world.DhApiWorldProxy;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;

public class WorldGenModule
implements Closeable {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private final GeneratedFullDataSourceProvider.IOnWorldGenCompleteListener onWorldGenCompleteListener;
    private final GeneratedFullDataSourceProvider dataSourceProvider;
    private final Supplier<? extends AbstractWorldGenState> worldGenStateSupplier;
    private final AtomicReference<AbstractWorldGenState> worldGenStateRef = new AtomicReference();

    public WorldGenModule(GeneratedFullDataSourceProvider.IOnWorldGenCompleteListener onWorldGenCompleteListener, GeneratedFullDataSourceProvider dataSourceProvider, Supplier<? extends AbstractWorldGenState> worldGenStateSupplier) {
        this.onWorldGenCompleteListener = onWorldGenCompleteListener;
        this.dataSourceProvider = dataSourceProvider;
        this.worldGenStateSupplier = worldGenStateSupplier;
    }

    public void startWorldGen(GeneratedFullDataSourceProvider dataFileHandler, AbstractWorldGenState newWgs) {
        if (!this.worldGenStateRef.compareAndSet(null, newWgs)) {
            LOGGER.warn("Failed to start world gen due to concurrency");
            newWgs.closeAsync(false);
        }
        dataFileHandler.addWorldGenCompleteListener(this.onWorldGenCompleteListener);
        dataFileHandler.setWorldGenerationQueue(newWgs.worldGenerationQueue);
    }

    public void stopWorldGen(GeneratedFullDataSourceProvider dataFileHandler) {
        AbstractWorldGenState worldGenState = this.worldGenStateRef.get();
        if (worldGenState == null) {
            LOGGER.warn("Attempted to stop world gen when it was not running");
            return;
        }
        while (!this.worldGenStateRef.compareAndSet(worldGenState, null)) {
            worldGenState = this.worldGenStateRef.get();
            if (worldGenState != null) continue;
            return;
        }
        dataFileHandler.clearRetrievalQueue();
        worldGenState.closeAsync(true).join();
        dataFileHandler.removeWorldGenCompleteListener(this.onWorldGenCompleteListener);
    }

    public void worldGenTick() {
        DhBlockPos2D targetPosForGeneration;
        AbstractWorldGenState worldGenState;
        boolean shouldDoWorldGen = this.onWorldGenCompleteListener.shouldDoWorldGen();
        boolean bl = !DhApiWorldProxy.INSTANCE.getReadOnly();
        boolean isWorldGenRunning = this.isWorldGenRunning();
        if ((shouldDoWorldGen &= bl) && !isWorldGenRunning) {
            this.startWorldGen(this.dataSourceProvider, this.worldGenStateSupplier.get());
        } else if (!shouldDoWorldGen && isWorldGenRunning) {
            this.stopWorldGen(this.dataSourceProvider);
        }
        if (this.isWorldGenRunning() && (worldGenState = this.worldGenStateRef.get()) != null && (targetPosForGeneration = this.onWorldGenCompleteListener.getTargetPosForGeneration()) != null) {
            worldGenState.startGenerationQueueAndSetTargetPos(targetPosForGeneration);
        }
    }

    @Override
    public void close() {
        AbstractWorldGenState worldGenState = this.worldGenStateRef.get();
        if (worldGenState != null) {
            while (!this.worldGenStateRef.compareAndSet(worldGenState, null) && (worldGenState = this.worldGenStateRef.get()) != null) {
            }
            if (worldGenState != null) {
                worldGenState.closeAsync(true).join();
            }
        }
    }

    public boolean isWorldGenRunning() {
        return this.worldGenStateRef.get() != null;
    }

    public void addDebugMenuStringsToList(List<String> messageList) {
        AbstractWorldGenState worldGenState = this.worldGenStateRef.get();
        if (worldGenState == null) {
            return;
        }
        String waitingCountStr = F3Screen.NUMBER_FORMAT.format(worldGenState.worldGenerationQueue.getWaitingTaskCount());
        String inProgressCountStr = F3Screen.NUMBER_FORMAT.format(worldGenState.worldGenerationQueue.getInProgressTaskCount());
        String totalCountEstimateStr = F3Screen.NUMBER_FORMAT.format(worldGenState.worldGenerationQueue.getEstimatedTotalTaskCount());
        messageList.add("World Gen Tasks: " + waitingCountStr + "/" + totalCountEstimateStr + " (in progress: " + inProgressCountStr + ")");
        worldGenState.worldGenerationQueue.addDebugMenuStringsToList(messageList);
    }

    public static abstract class AbstractWorldGenState {
        public IFullDataSourceRetrievalQueue worldGenerationQueue;

        CompletableFuture<Void> closeAsync(boolean doInterrupt) {
            return ((CompletableFuture)((CompletableFuture)this.worldGenerationQueue.startClosingAsync(true, doInterrupt).exceptionally(e -> {
                LOGGER.error("Error during first stage of generation queue shutdown, Error: [" + e.getMessage() + "].", e);
                return null;
            })).thenRun(this.worldGenerationQueue::close)).exceptionally(e -> {
                LOGGER.error("Error during second stage of generation queue shutdown, Error: [" + e.getMessage() + "].", e);
                return null;
            });
        }

        public void startGenerationQueueAndSetTargetPos(DhBlockPos2D targetPosForGeneration) {
            this.worldGenerationQueue.startAndSetTargetPos(targetPosForGeneration);
        }
    }
}

