/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.logging.f3;

import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.jar.ModJarInfo;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.render.RenderBufferHandler;
import com.seibel.distanthorizons.core.render.renderer.generic.GenericObjectRenderer;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import com.seibel.distanthorizons.core.world.AbstractDhWorld;
import com.seibel.distanthorizons.coreapi.ModInfo;
import com.seibel.distanthorizons.coreapi.util.StringUtil;
import java.text.NumberFormat;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class F3Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final NumberFormat NUMBER_FORMAT = NumberFormat.getIntegerInstance();

    public static void addStringToDisplay(List<String> messageList) {
        ThreadPoolExecutor worldGenPool = ThreadPoolUtil.getWorldGenExecutor();
        ThreadPoolExecutor fileHandlerPool = ThreadPoolUtil.getFileHandlerExecutor();
        ThreadPoolExecutor updatePool = ThreadPoolUtil.getUpdatePropagatorExecutor();
        ThreadPoolExecutor lodBuilderPool = ThreadPoolUtil.getChunkToLodBuilderExecutor();
        ThreadPoolExecutor bufferBuilderPool = ThreadPoolUtil.getBufferBuilderExecutor();
        ThreadPoolExecutor bufferUploaderPool = ThreadPoolUtil.getBufferUploaderExecutor();
        AbstractDhWorld world = SharedApi.getAbstractDhWorld();
        Iterable<? extends IDhLevel> levelIterator = world.getAllLoadedLevels();
        messageList.add("");
        messageList.add("Distant Horizons: 2.3.0-a-dev");
        if (ModInfo.IS_DEV_BUILD) {
            messageList.add("Build: " + StringUtil.shortenString(ModJarInfo.Git_Commit, 8) + " (" + ModJarInfo.Git_Branch + ")");
        }
        messageList.add("");
        messageList.add(F3Screen.getThreadPoolStatString("World Gen", worldGenPool));
        messageList.add(F3Screen.getThreadPoolStatString("File Handler", fileHandlerPool));
        messageList.add(F3Screen.getThreadPoolStatString("Update Propagator", updatePool));
        messageList.add(F3Screen.getThreadPoolStatString("LOD Builder", lodBuilderPool));
        messageList.add(F3Screen.getThreadPoolStatString("Buffer Builder", bufferBuilderPool));
        messageList.add(F3Screen.getThreadPoolStatString("Buffer Uploader", bufferUploaderPool));
        messageList.add("");
        messageList.add(SharedApi.INSTANCE.getDebugMenuString());
        messageList.add("");
        world.addDebugMenuStringsToList(messageList);
        for (IDhLevel iDhLevel : levelIterator) {
            GenericObjectRenderer genericRenderer;
            iDhLevel.addDebugMenuStringsToList(messageList);
            RenderBufferHandler renderBufferHandler = iDhLevel.getRenderBufferHandler();
            if (renderBufferHandler != null) {
                messageList.add(renderBufferHandler.getVboRenderDebugMenuString());
                String showPassString = renderBufferHandler.getShadowPassRenderDebugMenuString();
                if (showPassString != null) {
                    messageList.add(showPassString);
                }
            }
            if ((genericRenderer = iDhLevel.getGenericRenderer()) == null) continue;
            messageList.add(genericRenderer.getVboRenderDebugMenuString());
        }
    }

    private static String getThreadPoolStatString(String name, ThreadPoolExecutor pool) {
        String queueSize = pool != null ? NUMBER_FORMAT.format(pool.getQueue().size()) : "-";
        String completedCount = pool != null ? NUMBER_FORMAT.format(pool.getCompletedTaskCount()) : "-";
        return name + ", tasks: " + queueSize + ", complete: " + completedCount;
    }
}

