/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.multiplayer.client;

import com.google.common.cache.CacheBuilder;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import com.seibel.distanthorizons.core.multiplayer.config.SessionConfig;
import com.seibel.distanthorizons.core.network.INetworkObject;
import com.seibel.distanthorizons.core.network.event.internal.CloseInternalEvent;
import com.seibel.distanthorizons.core.network.event.internal.IncompatibleMessageInternalEvent;
import com.seibel.distanthorizons.core.network.messages.base.CurrentLevelKeyMessage;
import com.seibel.distanthorizons.core.network.messages.base.SessionConfigMessage;
import com.seibel.distanthorizons.core.network.messages.fullData.FullDataPartialUpdateMessage;
import com.seibel.distanthorizons.core.network.messages.fullData.FullDataPayload;
import com.seibel.distanthorizons.core.network.messages.fullData.FullDataSplitMessage;
import com.seibel.distanthorizons.core.network.session.NetworkSession;
import com.seibel.distanthorizons.core.sql.dto.FullDataSourceV2DTO;
import com.seibel.distanthorizons.core.util.LodUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.Nullable;

public class ClientNetworkState
implements Closeable {
    protected static final ConfigBasedLogger LOGGER = new ConfigBasedLogger(LogManager.getLogger(), () -> Config.Client.Advanced.Logging.logNetworkEvent.get());
    private final ConcurrentMap<Integer, CompositeByteBuf> fullDataBufferById = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build().asMap();
    private final SessionConfig.AnyChangeListener configAnyChangeListener = new SessionConfig.AnyChangeListener(this::sendConfigMessage);
    private final NetworkSession networkSession = new NetworkSession(null);
    public SessionConfig sessionConfig = new SessionConfig();
    private volatile boolean configReceived = false;
    private EServerSupportStatus serverSupportStatus = EServerSupportStatus.NONE;
    @Nullable
    private Integer closestProtocolVersion;

    public NetworkSession getSession() {
        return this.networkSession;
    }

    public boolean isReady() {
        return this.configReceived;
    }

    public ClientNetworkState() {
        this.networkSession.registerHandler(IncompatibleMessageInternalEvent.class, event -> {
            if (this.closestProtocolVersion == null || Math.abs(event.protocolVersion - 4) < this.closestProtocolVersion) {
                this.closestProtocolVersion = event.protocolVersion;
            }
        });
        this.networkSession.registerHandler(CurrentLevelKeyMessage.class, message -> {
            if (this.serverSupportStatus == EServerSupportStatus.NONE) {
                this.serverSupportStatus = EServerSupportStatus.LEVELS_ONLY;
            }
        });
        this.networkSession.registerHandler(SessionConfigMessage.class, message -> {
            this.serverSupportStatus = EServerSupportStatus.FULL;
            LOGGER.info("Connection config has been changed: [" + message.config + "].", new Object[0]);
            this.sessionConfig = message.config;
            this.configReceived = true;
        });
        this.networkSession.registerHandler(CloseInternalEvent.class, message -> {
            this.configReceived = false;
        });
        this.networkSession.registerHandler(FullDataSplitMessage.class, message -> {
            CompositeByteBuf composite;
            if (message.isFirst && (composite = (CompositeByteBuf)this.fullDataBufferById.remove(message.bufferId)) != null) {
                composite.release();
                LOGGER.debug("Released full data buffer [" + message.bufferId + "]: [" + composite + "]", new Object[0]);
            }
            CompositeByteBuf byteBuffer = this.fullDataBufferById.computeIfAbsent(message.bufferId, bufferId -> ByteBufAllocator.DEFAULT.compositeBuffer());
            byteBuffer.addComponent(true, message.buffer);
            LOGGER.debug("Full data buffer [" + message.bufferId + "]: [" + byteBuffer + "].", new Object[0]);
        });
        this.networkSession.registerHandler(FullDataPartialUpdateMessage.class, msg -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FullDataSourceV2DTO decodeDataSourceAndReleaseBuffer(FullDataPayload msg) {
        CompositeByteBuf compositeByteBuffer = (CompositeByteBuf)this.fullDataBufferById.remove(msg.dtoBufferId);
        LodUtil.assertTrue(compositeByteBuffer != null);
        try {
            FullDataSourceV2DTO fullDataSourceV2DTO = INetworkObject.decodeToInstance(FullDataSourceV2DTO.CreateEmptyDataSource(), (ByteBuf)compositeByteBuffer);
            return fullDataSourceV2DTO;
        }
        finally {
            compositeByteBuffer.release();
        }
    }

    public void sendConfigMessage() {
        this.configReceived = false;
        this.getSession().sendMessage(new SessionConfigMessage(new SessionConfig()));
    }

    public void addDebugMenuStringsToList(List<String> messageList) {
        if (this.networkSession.isClosed()) {
            messageList.add("NetworkSession closed: " + this.networkSession.getCloseReason().getMessage());
            return;
        }
        if (this.serverSupportStatus == EServerSupportStatus.NONE && this.closestProtocolVersion != null) {
            messageList.add("Incompatible protocol version: [" + this.closestProtocolVersion + "], required: [" + 4 + "]");
            return;
        }
        messageList.add(this.serverSupportStatus.message);
    }

    @Override
    public void close() {
        this.configAnyChangeListener.close();
        this.networkSession.close();
    }

    private static enum EServerSupportStatus {
        NONE("Server does not support DH"),
        LEVELS_ONLY("Server supports shared level keys"),
        FULL("Server has full DH support");

        public final String message;

        private EServerSupportStatus(String message) {
            this.message = message;
        }
    }
}

