/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.network.messages.fullData;

import com.google.common.base.MoreObjects;
import com.seibel.distanthorizons.api.enums.config.EDhApiDataCompressionMode;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.network.INetworkObject;
import com.seibel.distanthorizons.core.network.messages.fullData.FullDataSplitMessage;
import com.seibel.distanthorizons.core.sql.dto.FullDataSourceV2DTO;
import com.seibel.distanthorizons.core.util.TimerUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class FullDataPayload
implements INetworkObject {
    private static final AtomicInteger lastBufferId = new AtomicInteger();
    private static final Timer bufferCleanupTimer = TimerUtil.CreateTimer("FullDataBufferCleanupTimer");
    public int dtoBufferId;
    public ByteBuf dtoBuffer;

    public FullDataPayload() {
    }

    public FullDataPayload(@NotNull FullDataSourceV2 fullDataSource) {
        Objects.requireNonNull(fullDataSource);
        this.dtoBufferId = lastBufferId.getAndIncrement();
        try {
            EDhApiDataCompressionMode compressionMode = Config.Client.Advanced.LodBuilding.dataCompression.get();
            FullDataSourceV2DTO dataSourceDto = FullDataSourceV2DTO.CreateFromDataSource(fullDataSource, compressionMode);
            this.dtoBuffer = ByteBufAllocator.DEFAULT.buffer();
            dataSourceDto.encode(this.dtoBuffer);
            bufferCleanupTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    FullDataPayload.this.dtoBuffer.release();
                }
            }, 5000L);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void encode(ByteBuf out) {
        out.writeInt(this.dtoBufferId);
    }

    @Override
    public void decode(ByteBuf in) {
        this.dtoBufferId = in.readInt();
    }

    public void splitAndSend(int payloadChunkSizeInBytes, Consumer<FullDataSplitMessage> sendMessageConsumer) {
        int payloadChunkNum = 0;
        while (true) {
            int offset = payloadChunkNum * payloadChunkSizeInBytes;
            int actualChunkSize = Math.min(this.dtoBuffer.writerIndex() - offset, payloadChunkSizeInBytes);
            if (actualChunkSize <= 0) break;
            FullDataSplitMessage chunk = new FullDataSplitMessage(this.dtoBufferId, payloadChunkNum == 0, this.dtoBuffer.slice(offset, actualChunkSize));
            sendMessageConsumer.accept(chunk);
            ++payloadChunkNum;
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("dtoBufferId", this.dtoBufferId).add("dtoBuffer", (Object)this.dtoBuffer).toString();
    }
}

