/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.network.messages.fullData;

import com.google.common.base.MoreObjects;
import com.seibel.distanthorizons.core.network.messages.AbstractNetworkMessage;
import io.netty.buffer.ByteBuf;

public class FullDataSplitMessage
extends AbstractNetworkMessage {
    public int bufferId;
    public ByteBuf buffer;
    public boolean isFirst;

    public FullDataSplitMessage() {
    }

    public FullDataSplitMessage(int bufferId, boolean isFirst, ByteBuf buffer) {
        this.bufferId = bufferId;
        this.buffer = buffer;
        this.isFirst = isFirst;
    }

    @Override
    public void encode(ByteBuf out) {
        out.writeInt(this.bufferId);
        out.writeInt(this.buffer.writerIndex());
        out.writeBytes(this.buffer.readerIndex(0));
        out.writeBoolean(this.isFirst);
    }

    @Override
    public void decode(ByteBuf in) {
        this.bufferId = in.readInt();
        int bufferSize = in.readInt();
        this.buffer = in.readBytes(bufferSize);
        this.isFirst = in.readBoolean();
    }

    @Override
    public MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("bufferId", this.bufferId).add("buffer", (Object)this.buffer).add("isFirst", this.isFirst);
    }
}

