/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.dataObjects.render.ColumnRenderSource;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.ColumnRenderBuffer;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.ColumnRenderBufferBuilder;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.LodQuadBuilder;
import com.seibel.distanthorizons.core.dataObjects.transformers.FullDataToRenderDataTransformer;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.file.fullDatafile.FullDataSourceProviderV2;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.render.LodQuadTree;
import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.render.renderer.IDebugRenderable;
import com.seibel.distanthorizons.core.util.ListUtil;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.WillNotClose;
import org.apache.logging.log4j.Logger;

public class LodRenderSection
implements IDebugRenderable,
AutoCloseable {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final IMinecraftClientWrapper MC = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    public final long pos;
    private final IDhClientLevel level;
    @WillNotClose
    private final FullDataSourceProviderV2 fullDataSourceProvider;
    private final LodQuadTree quadTree;
    private boolean renderingEnabled = false;
    private boolean canRender = false;
    public ColumnRenderBuffer renderBuffer;
    private CompletableFuture<Void> buildAndUploadRenderDataToGpuFuture = null;
    private CompletableFuture<LodQuadBuilder> bufferBuildFuture = null;
    private CompletableFuture<ColumnRenderBuffer> bufferUploadFuture = null;
    private final ReentrantLock getRenderSourceLock = new ReentrantLock();
    private ReferencedRenderSourceFutureWrapper renderSourceLoadingRefFuture = null;
    private boolean missingPositionsCalculated = false;
    private LongArrayList missingGenerationPos = null;

    public LodRenderSection(long pos, LodQuadTree quadTree, IDhClientLevel level, FullDataSourceProviderV2 fullDataSourceProvider) {
        this.pos = pos;
        this.quadTree = quadTree;
        this.level = level;
        this.fullDataSourceProvider = fullDataSourceProvider;
        DebugRenderer.register(this, Config.Client.Advanced.Debugging.DebugWireframe.showRenderSectionStatus);
    }

    public synchronized void uploadRenderDataToGpuAsync() {
        if (!GLProxy.hasInstance()) {
            return;
        }
        if (this.buildAndUploadRenderDataToGpuFuture != null) {
            return;
        }
        ThreadPoolExecutor executor = ThreadPoolUtil.getFileHandlerExecutor();
        if (executor == null || executor.isTerminated()) {
            return;
        }
        try {
            this.buildAndUploadRenderDataToGpuFuture = CompletableFuture.runAsync(() -> {
                try {
                    ((CompletableFuture)this.loadRenderDataAsync().thenCompose(loadedRenderSources -> {
                        try {
                            ColumnRenderSource thisRenderSource = loadedRenderSources.getThisRenderSource();
                            if (thisRenderSource != null && !thisRenderSource.isEmpty()) {
                                CompletableFuture<LodQuadBuilder> buildDataFuture = this.buildNewRenderDataAsync(thisRenderSource, (LoadedRenderSourcesFutureWrapper)loadedRenderSources);
                                buildDataFuture.thenRun(loadedRenderSources::decrementRefCounts);
                                return buildDataFuture;
                            }
                            this.canRender = false;
                            this.buildAndUploadRenderDataToGpuFuture = null;
                            this.bufferBuildFuture = null;
                            return CompletableFuture.completedFuture(null);
                        }
                        catch (Exception e) {
                            this.handleException(e);
                            throw e;
                        }
                    })).thenCompose(lodQuadBuilder -> {
                        try {
                            if (lodQuadBuilder != null) {
                                return this.uploadToGpuAsync((LodQuadBuilder)lodQuadBuilder);
                            }
                            return CompletableFuture.completedFuture(null);
                        }
                        catch (Exception e) {
                            this.handleException(e);
                            throw e;
                        }
                    });
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }, executor);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    private CompletableFuture<LoadedRenderSourcesFutureWrapper> loadRenderDataAsync() {
        ReferencedRenderSourceFutureWrapper thisRenderSourceLoadFuture = this.getRenderSourceAsync();
        ArrayList<ReferencedRenderSourceFutureWrapper> adjRenderSourceLoadRefFutures = this.getNeighborRenderSourcesAsync();
        ArrayList<CompletableFuture<ColumnRenderSource>> futureList = new ArrayList<CompletableFuture<ColumnRenderSource>>();
        futureList.add(thisRenderSourceLoadFuture.future);
        for (ReferencedRenderSourceFutureWrapper futureWrapper : adjRenderSourceLoadRefFutures) {
            futureList.add(futureWrapper.future);
        }
        CompletableFuture<Void> allLoadedFuture = CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0]));
        return allLoadedFuture.thenApply(voidObj -> new LoadedRenderSourcesFutureWrapper(thisRenderSourceLoadFuture, adjRenderSourceLoadRefFutures));
    }

    private CompletableFuture<LodQuadBuilder> buildNewRenderDataAsync(ColumnRenderSource thisRenderSource, LoadedRenderSourcesFutureWrapper loadedRenderSources) {
        ColumnRenderSource[] adjacentRenderSections = new ColumnRenderSource[EDhDirection.ADJ_DIRECTIONS.length];
        boolean[] adjIsSameDetailLevel = new boolean[EDhDirection.ADJ_DIRECTIONS.length];
        for (int i = 0; i < EDhDirection.ADJ_DIRECTIONS.length; ++i) {
            adjacentRenderSections[i] = loadedRenderSources.getAdjacentRenderSource(i);
            EDhDirection direction = EDhDirection.ADJ_DIRECTIONS[i];
            adjIsSameDetailLevel[direction.ordinal() - 2] = this.isAdjacentPosSameDetailLevel(direction);
        }
        if (this.bufferBuildFuture != null) {
            this.bufferBuildFuture.cancel(true);
        }
        this.bufferBuildFuture = ColumnRenderBufferBuilder.buildBuffersAsync(this.level, thisRenderSource, adjacentRenderSections, adjIsSameDetailLevel);
        return this.bufferBuildFuture;
    }

    private CompletableFuture<Void> uploadToGpuAsync(LodQuadBuilder lodQuadBuilder) {
        if (this.bufferUploadFuture != null) {
            this.bufferUploadFuture.cancel(true);
        }
        this.bufferUploadFuture = ColumnRenderBufferBuilder.uploadBuffersAsync(this.level, this.pos, lodQuadBuilder);
        return this.bufferUploadFuture.thenCompose(buffer -> {
            ColumnRenderBuffer previousBuffer = this.renderBuffer;
            this.renderBuffer = buffer;
            this.canRender = buffer != null;
            this.buildAndUploadRenderDataToGpuFuture = null;
            this.bufferBuildFuture = null;
            if (previousBuffer != null) {
                previousBuffer.close();
            }
            return null;
        });
    }

    private ArrayList<ReferencedRenderSourceFutureWrapper> getNeighborRenderSourcesAsync() {
        ArrayList<ReferencedRenderSourceFutureWrapper> futureList = ListUtil.createEmptyList(EDhDirection.ADJ_DIRECTIONS.length);
        for (int i = 0; i < EDhDirection.ADJ_DIRECTIONS.length; ++i) {
            EDhDirection direction = EDhDirection.ADJ_DIRECTIONS[i];
            int arrayIndex = direction.ordinal() - 2;
            long adjPos = DhSectionPos.getAdjacentPos(this.pos, direction);
            try {
                LodRenderSection adjRenderSection = (LodRenderSection)this.quadTree.getValue(adjPos);
                if (adjRenderSection != null) {
                    futureList.set(arrayIndex, adjRenderSection.getRenderSourceAsync());
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            if (futureList.get(arrayIndex) != null) continue;
            futureList.set(arrayIndex, new ReferencedRenderSourceFutureWrapper(CompletableFuture.completedFuture(null)));
        }
        return futureList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReferencedRenderSourceFutureWrapper getRenderSourceAsync() {
        try {
            this.getRenderSourceLock.lock();
            ReferencedRenderSourceFutureWrapper oldFuture = this.renderSourceLoadingRefFuture;
            if (oldFuture != null) {
                oldFuture.incrementRefCount();
                ReferencedRenderSourceFutureWrapper referencedRenderSourceFutureWrapper = oldFuture;
                return referencedRenderSourceFutureWrapper;
            }
            ThreadPoolExecutor executor = ThreadPoolUtil.getFileHandlerExecutor();
            if (executor == null || executor.isTerminated()) {
                ReferencedRenderSourceFutureWrapper referencedRenderSourceFutureWrapper = new ReferencedRenderSourceFutureWrapper(CompletableFuture.completedFuture(null));
                return referencedRenderSourceFutureWrapper;
            }
            ReferencedRenderSourceFutureWrapper referencedRenderSourceFutureWrapper = this.renderSourceLoadingRefFuture = new ReferencedRenderSourceFutureWrapper(CompletableFuture.supplyAsync(() -> {
                ColumnRenderSource columnRenderSource;
                block8: {
                    FullDataSourceV2 fullDataSource = (FullDataSourceV2)this.fullDataSourceProvider.get(this.pos);
                    try {
                        ColumnRenderSource renderSource = FullDataToRenderDataTransformer.transformFullDataToRenderSource(fullDataSource, this.level);
                        this.renderSourceLoadingRefFuture = null;
                        columnRenderSource = renderSource;
                        if (fullDataSource == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (fullDataSource != null) {
                                try {
                                    fullDataSource.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.warn("Unable to get render source " + DhSectionPos.toString(this.pos) + ", error: " + e.getMessage(), (Throwable)e);
                            this.renderSourceLoadingRefFuture = null;
                            return null;
                        }
                    }
                    fullDataSource.close();
                }
                return columnRenderSource;
            }, executor));
            return referencedRenderSourceFutureWrapper;
        }
        finally {
            this.getRenderSourceLock.unlock();
        }
    }

    private boolean isAdjacentPosSameDetailLevel(EDhDirection direction) {
        long adjPos = DhSectionPos.getAdjacentPos(this.pos, direction);
        byte detailLevel = this.quadTree.calculateExpectedDetailLevel(new DhBlockPos2D(MC.getPlayerBlockPos()), adjPos);
        return (detailLevel = (byte)(detailLevel + 6)) == DhSectionPos.getDetailLevel(this.pos);
    }

    private void handleException(Throwable e) {
        LOGGER.error("Unexpected error in LodRenderSection loading, Error: " + e.getMessage(), e);
        this.buildAndUploadRenderDataToGpuFuture = null;
        this.bufferBuildFuture = null;
    }

    public boolean canRender() {
        return this.canRender;
    }

    public boolean getRenderingEnabled() {
        return this.renderingEnabled;
    }

    public void setRenderingEnabled(boolean enabled) {
        this.renderingEnabled = enabled;
    }

    public void onRenderingEnabled() {
        this.level.loadBeaconBeamsInPos(this.pos);
    }

    public void onRenderingDisabled() {
        this.level.unloadBeaconBeamsInPos(this.pos);
        if (Config.Client.Advanced.Debugging.DebugWireframe.showRenderSectionStatus.get().booleanValue()) {
            DebugRenderer.makeParticle(new DebugRenderer.BoxParticle(new DebugRenderer.Box(this.pos, 128.0f, 156.0f, 0.09f, Color.CYAN.darker()), 0.2, 32.0f));
        }
    }

    public boolean gpuUploadInProgress() {
        return this.buildAndUploadRenderDataToGpuFuture != null;
    }

    public boolean isFullyGenerated() {
        return this.missingPositionsCalculated && this.missingGenerationPos.isEmpty();
    }

    public boolean missingPositionsCalculated() {
        return this.missingPositionsCalculated;
    }

    public int ungeneratedPositionCount() {
        return this.missingGenerationPos != null ? this.missingGenerationPos.size() : 0;
    }

    public void tryQueuingMissingLodRetrieval() {
        if (this.fullDataSourceProvider.canRetrieveMissingDataSources() && this.fullDataSourceProvider.canQueueRetrieval()) {
            if (!this.missingPositionsCalculated) {
                this.missingGenerationPos = this.fullDataSourceProvider.getPositionsToRetrieve(this.pos);
                if (this.missingGenerationPos != null) {
                    this.missingPositionsCalculated = true;
                }
            }
            if (this.missingGenerationPos != null) {
                for (int i = this.missingGenerationPos.size() - 1; i >= 0 && this.fullDataSourceProvider.canQueueRetrieval(); --i) {
                    long pos = this.missingGenerationPos.removeLong(i);
                    boolean positionQueued = this.fullDataSourceProvider.queuePositionForRetrieval(pos);
                    if (positionQueued) continue;
                    this.missingGenerationPos.add(pos);
                    break;
                }
            }
        }
    }

    public String toString() {
        return "pos=[" + DhSectionPos.toString(this.pos) + "] enabled=[" + this.renderingEnabled + "] uploading=[" + this.gpuUploadInProgress() + "] ";
    }

    @Override
    public void close() {
        ThreadPoolExecutor executor;
        DebugRenderer.unregister(this, Config.Client.Advanced.Debugging.DebugWireframe.showRenderSectionStatus);
        if (Config.Client.Advanced.Debugging.DebugWireframe.showRenderSectionStatus.get().booleanValue()) {
            DebugRenderer.makeParticle(new DebugRenderer.BoxParticle(new DebugRenderer.Box(this.pos, 128.0f, 156.0f, 0.09f, Color.RED.darker()), 0.5, 32.0f));
        }
        this.level.unloadBeaconBeamsInPos(this.pos);
        if (this.renderBuffer != null) {
            this.renderBuffer.close();
        }
        if (this.buildAndUploadRenderDataToGpuFuture != null) {
            this.buildAndUploadRenderDataToGpuFuture.cancel(true);
        }
        if (this.bufferBuildFuture != null) {
            this.bufferBuildFuture.cancel(true);
        }
        if (this.bufferUploadFuture != null) {
            this.bufferUploadFuture.cancel(true);
        }
        if ((executor = ThreadPoolUtil.getCleanupExecutor()) != null && !executor.isTerminated()) {
            try {
                executor.execute(() -> this.fullDataSourceProvider.removeRetrievalRequestIf(genPos -> DhSectionPos.contains(this.pos, genPos)));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    @Override
    public void debugRender(DebugRenderer debugRenderer) {
        Color color = Color.red;
        if (this.renderingEnabled) {
            color = Color.green;
        } else if (this.buildAndUploadRenderDataToGpuFuture != null) {
            color = Color.yellow;
        } else if (this.canRender) {
            color = Color.cyan;
        }
        debugRenderer.renderBox(new DebugRenderer.Box(this.pos, 400.0f, 8.0f, (Object)Objects.hashCode(this), 0.1f, color));
    }

    private static class ReferencedRenderSourceFutureWrapper {
        public final CompletableFuture<ColumnRenderSource> future;
        private final AtomicInteger refCount = new AtomicInteger(1);

        public ReferencedRenderSourceFutureWrapper(CompletableFuture<ColumnRenderSource> future) {
            this.future = future;
        }

        public void incrementRefCount() {
            this.refCount.incrementAndGet();
        }

        public void decrementRefCount() {
            int refCount = this.refCount.decrementAndGet();
            if (refCount <= 0) {
                ColumnRenderSource source;
                if (refCount < 0) {
                    LodUtil.assertNotReach("ReferencedRenderSourceFutureWrapper was released more than once! Ref Count [" + refCount + "].");
                }
                if ((source = (ColumnRenderSource)this.future.getNow(null)) != null) {
                    ColumnRenderSource.DATA_SOURCE_POOL.returnPooledDataSource(source);
                }
            }
        }

        public String toString() {
            return this.future.toString() + " - " + this.refCount.get();
        }
    }

    private static class LoadedRenderSourcesFutureWrapper {
        private final ReferencedRenderSourceFutureWrapper thisRenderSourceFutureRef;
        private final ArrayList<ReferencedRenderSourceFutureWrapper> adjacentRenderSourceFutureRefList;

        public LoadedRenderSourcesFutureWrapper(ReferencedRenderSourceFutureWrapper thisRenderSourceFutureRef, ArrayList<ReferencedRenderSourceFutureWrapper> adjacentRenderSourceFutureRefList) {
            this.thisRenderSourceFutureRef = thisRenderSourceFutureRef;
            this.adjacentRenderSourceFutureRefList = adjacentRenderSourceFutureRefList;
        }

        public ColumnRenderSource getThisRenderSource() {
            return this.thisRenderSourceFutureRef != null && this.thisRenderSourceFutureRef.future != null ? (ColumnRenderSource)this.thisRenderSourceFutureRef.future.getNow(null) : null;
        }

        public ColumnRenderSource getAdjacentRenderSource(int i) {
            ReferencedRenderSourceFutureWrapper futureWrapper = this.adjacentRenderSourceFutureRefList.get(i);
            return futureWrapper != null && futureWrapper.future != null ? (ColumnRenderSource)futureWrapper.future.getNow(null) : null;
        }

        public void decrementRefCounts() {
            this.thisRenderSourceFutureRef.decrementRefCount();
            for (int i = 0; i < this.adjacentRenderSourceFutureRefList.size(); ++i) {
                this.adjacentRenderSourceFutureRefList.get(i).decrementRefCount();
            }
        }
    }
}

