/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.sql.dto;

import com.google.common.base.MoreObjects;
import com.seibel.distanthorizons.api.enums.config.EDhApiDataCompressionMode;
import com.seibel.distanthorizons.core.dataObjects.fullData.FullDataPointIdMap;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.network.INetworkObject;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.sql.dto.IBaseDTO;
import com.seibel.distanthorizons.core.util.FullDataPointUtil;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.objects.DataCorruptedException;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataInputStream;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataOutputStream;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class FullDataSourceV2DTO
implements IBaseDTO<Long>,
INetworkObject {
    public static final boolean VALIDATE_INPUT_DATAPOINTS = true;
    public long pos;
    public int levelMinY;
    public int dataChecksum;
    public byte[] compressedDataByteArray;
    public byte[] compressedColumnGenStepByteArray;
    public byte[] compressedWorldCompressionModeByteArray;
    public byte[] compressedMappingByteArray;
    public byte dataFormatVersion;
    public byte compressionModeValue;
    public boolean applyToParent;
    public long lastModifiedUnixDateTime;
    public long createdUnixDateTime;

    public static FullDataSourceV2DTO CreateFromDataSource(FullDataSourceV2 dataSource, EDhApiDataCompressionMode compressionModeEnum) throws IOException {
        byte[] dataPointByteArray = FullDataSourceV2DTO.writeDataSourceDataArrayToBlob(dataSource.dataPoints, compressionModeEnum);
        byte[] compressedWorldGenStepByteArray = FullDataSourceV2DTO.writeGenerationStepsToBlob(dataSource.columnGenerationSteps, compressionModeEnum);
        byte[] compressedWorldCompressionModeByteArray = FullDataSourceV2DTO.writeWorldCompressionModeToBlob(dataSource.columnWorldCompressionMode, compressionModeEnum);
        byte[] mappingByteArray = FullDataSourceV2DTO.writeDataMappingToBlob(dataSource.mapping, compressionModeEnum);
        int checksum = dataSource.mapping.hashCode() * 4217 + dataSource.hashCode();
        return new FullDataSourceV2DTO(dataSource.getPos(), checksum, compressedWorldGenStepByteArray, compressedWorldCompressionModeByteArray, 1, compressionModeEnum.value, dataPointByteArray, dataSource.lastModifiedUnixDateTime, dataSource.createdUnixDateTime, mappingByteArray, dataSource.applyToParent, dataSource.levelMinY);
    }

    public static FullDataSourceV2DTO CreateEmptyDataSource() {
        return new FullDataSourceV2DTO();
    }

    private FullDataSourceV2DTO() {
    }

    public FullDataSourceV2DTO(long pos, int dataChecksum, byte[] compressedColumnGenStepByteArray, byte[] compressedWorldCompressionModeByteArray, byte dataFormatVersion, byte compressionModeValue, byte[] compressedDataByteArray, long lastModifiedUnixDateTime, long createdUnixDateTime, byte[] compressedMappingByteArray, boolean applyToParent, int levelMinY) {
        this.pos = pos;
        this.dataChecksum = dataChecksum;
        this.compressedColumnGenStepByteArray = compressedColumnGenStepByteArray;
        this.compressedWorldCompressionModeByteArray = compressedWorldCompressionModeByteArray;
        this.dataFormatVersion = dataFormatVersion;
        this.compressionModeValue = compressionModeValue;
        this.compressedDataByteArray = compressedDataByteArray;
        this.compressedMappingByteArray = compressedMappingByteArray;
        this.applyToParent = applyToParent;
        this.lastModifiedUnixDateTime = lastModifiedUnixDateTime;
        this.createdUnixDateTime = createdUnixDateTime;
        this.levelMinY = levelMinY;
    }

    public FullDataSourceV2 createPooledDataSource(@NotNull ILevelWrapper levelWrapper) throws IOException, InterruptedException, DataCorruptedException {
        FullDataSourceV2 dataSource = FullDataSourceV2.DATA_SOURCE_POOL.getPooledSource(this.pos, false);
        return this.populateDataSource(dataSource, levelWrapper);
    }

    public FullDataSourceV2 populateDataSource(FullDataSourceV2 dataSource, @NotNull ILevelWrapper levelWrapper) throws IOException, InterruptedException, DataCorruptedException {
        return this.internalPopulateDataSource(dataSource, levelWrapper, false);
    }

    public FullDataSourceV2 createUnitTestDataSource() throws IOException, InterruptedException, DataCorruptedException {
        return this.internalPopulateDataSource(FullDataSourceV2.createEmpty(this.pos), null, true);
    }

    private FullDataSourceV2 internalPopulateDataSource(FullDataSourceV2 dataSource, ILevelWrapper levelWrapper, boolean unitTest) throws IOException, InterruptedException, DataCorruptedException {
        EDhApiDataCompressionMode compressionModeEnum;
        if (1 != this.dataFormatVersion) {
            throw new IllegalStateException("There should only be one data format [1].");
        }
        try {
            compressionModeEnum = this.getCompressionMode();
        }
        catch (IllegalArgumentException e) {
            throw new DataCorruptedException(e);
        }
        dataSource.columnGenerationSteps = FullDataSourceV2DTO.readBlobToGenerationSteps(this.compressedColumnGenStepByteArray, compressionModeEnum);
        dataSource.columnWorldCompressionMode = FullDataSourceV2DTO.readBlobToGenerationSteps(this.compressedWorldCompressionModeByteArray, compressionModeEnum);
        dataSource.dataPoints = FullDataSourceV2DTO.readBlobToDataSourceDataArray(this.compressedDataByteArray, compressionModeEnum);
        dataSource.mapping.clear(dataSource.getPos());
        if (!unitTest) {
            if (levelWrapper == null) {
                throw new NullPointerException("No level wrapper present, unable to deserialize data map. This should only be used for unit tests.");
            }
            FullDataPointIdMap newMap = FullDataSourceV2DTO.readBlobToDataMapping(this.compressedMappingByteArray, dataSource.getPos(), levelWrapper, compressionModeEnum);
            dataSource.mapping.addAll(newMap);
            if (dataSource.mapping.size() != newMap.size()) {
                LodUtil.assertNotReach("ID maps out of sync for pos: " + this.pos);
            }
        }
        dataSource.lastModifiedUnixDateTime = this.lastModifiedUnixDateTime;
        dataSource.createdUnixDateTime = this.createdUnixDateTime;
        dataSource.levelMinY = this.levelMinY;
        dataSource.isEmpty = false;
        return dataSource;
    }

    private static byte[] writeDataSourceDataArrayToBlob(LongArrayList[] dataArray, EDhApiDataCompressionMode compressionModeEnum) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DhDataOutputStream compressedOut = new DhDataOutputStream(byteArrayOutputStream, compressionModeEnum);
        int dataArrayLength = 4096;
        for (int xz = 0; xz < dataArrayLength; ++xz) {
            LongArrayList dataColumn = dataArray[xz];
            int columnLength = dataColumn != null ? (int)dataColumn.size() : 0;
            compressedOut.writeShort(columnLength);
            for (int y = 0; y < columnLength; ++y) {
                compressedOut.writeLong(dataColumn.getLong(y));
            }
        }
        compressedOut.flush();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private static LongArrayList[] readBlobToDataSourceDataArray(byte[] compressedDataByteArray, EDhApiDataCompressionMode compressionModeEnum) throws IOException, DataCorruptedException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(compressedDataByteArray);
        DhDataInputStream compressedIn = new DhDataInputStream(byteArrayInputStream, compressionModeEnum);
        int dataArrayLength = 4096;
        LongArrayList[] dataArray = new LongArrayList[dataArrayLength];
        for (int xz = 0; xz < dataArray.length; ++xz) {
            int dataColumnLength = compressedIn.readShort();
            if (dataColumnLength < 0) {
                throw new DataCorruptedException("Read DataSource Blob data at index [" + xz + "], column length [" + dataColumnLength + "] should be greater than zero.");
            }
            LongArrayList dataColumn = new LongArrayList(new long[dataColumnLength]);
            for (int y = 0; y < dataColumnLength; ++y) {
                long dataPoint = compressedIn.readLong();
                FullDataPointUtil.validateDatapoint(dataPoint);
                dataColumn.set(y, dataPoint);
            }
            dataArray[xz] = dataColumn;
        }
        return dataArray;
    }

    private static byte[] writeGenerationStepsToBlob(byte[] columnGenStepByteArray, EDhApiDataCompressionMode compressionModeEnum) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DhDataOutputStream compressedOut = new DhDataOutputStream(byteArrayOutputStream, compressionModeEnum);
        compressedOut.write(columnGenStepByteArray);
        compressedOut.flush();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] readBlobToGenerationSteps(byte[] dataByteArray, EDhApiDataCompressionMode compressionModeEnum) throws IOException, DataCorruptedException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(dataByteArray);
        DhDataInputStream compressedIn = new DhDataInputStream(byteArrayInputStream, compressionModeEnum);
        try {
            byte[] columnGenStepByteArray = new byte[4096];
            compressedIn.readFully(columnGenStepByteArray);
            return columnGenStepByteArray;
        }
        catch (EOFException e) {
            throw new DataCorruptedException(e);
        }
    }

    private static byte[] writeWorldCompressionModeToBlob(byte[] worldCompressionModeByteArray, EDhApiDataCompressionMode compressionModeEnum) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DhDataOutputStream compressedOut = new DhDataOutputStream(byteArrayOutputStream, compressionModeEnum);
        compressedOut.write(worldCompressionModeByteArray);
        compressedOut.flush();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] readBlobToWorldCompressionMode(byte[] dataByteArray, EDhApiDataCompressionMode compressionModeEnum) throws IOException, InterruptedException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(dataByteArray);
        DhDataInputStream compressedIn = new DhDataInputStream(byteArrayInputStream, compressionModeEnum);
        byte[] worldCompressionModeByteArray = new byte[4096];
        compressedIn.readFully(worldCompressionModeByteArray);
        return worldCompressionModeByteArray;
    }

    private static byte[] writeDataMappingToBlob(FullDataPointIdMap mapping, EDhApiDataCompressionMode compressionModeEnum) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DhDataOutputStream compressedOut = new DhDataOutputStream(byteArrayOutputStream, compressionModeEnum);
        mapping.serialize(compressedOut);
        compressedOut.flush();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private static FullDataPointIdMap readBlobToDataMapping(byte[] compressedMappingByteArray, long pos, @NotNull ILevelWrapper levelWrapper, EDhApiDataCompressionMode compressionModeEnum) throws IOException, InterruptedException, DataCorruptedException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(compressedMappingByteArray);
        DhDataInputStream compressedIn = new DhDataInputStream(byteArrayInputStream, compressionModeEnum);
        FullDataPointIdMap mapping = FullDataPointIdMap.deserialize(compressedIn, pos, levelWrapper);
        return mapping;
    }

    @Override
    public void encode(ByteBuf out) {
        out.writeLong(this.pos);
        out.writeInt(this.dataChecksum);
        out.writeInt(this.compressedDataByteArray.length);
        out.writeBytes(this.compressedDataByteArray);
        out.writeInt(this.compressedColumnGenStepByteArray.length);
        out.writeBytes(this.compressedColumnGenStepByteArray);
        out.writeInt(this.compressedWorldCompressionModeByteArray.length);
        out.writeBytes(this.compressedWorldCompressionModeByteArray);
        out.writeInt(this.compressedMappingByteArray.length);
        out.writeBytes(this.compressedMappingByteArray);
        out.writeByte((int)this.dataFormatVersion);
        out.writeByte((int)this.compressionModeValue);
        out.writeBoolean(this.applyToParent);
        out.writeLong(this.lastModifiedUnixDateTime);
        out.writeLong(this.createdUnixDateTime);
    }

    @Override
    public void decode(ByteBuf in) {
        this.pos = in.readLong();
        this.dataChecksum = in.readInt();
        this.compressedDataByteArray = new byte[in.readInt()];
        in.readBytes(this.compressedDataByteArray);
        this.compressedColumnGenStepByteArray = new byte[in.readInt()];
        in.readBytes(this.compressedColumnGenStepByteArray);
        this.compressedWorldCompressionModeByteArray = new byte[in.readInt()];
        in.readBytes(this.compressedWorldCompressionModeByteArray);
        this.compressedMappingByteArray = new byte[in.readInt()];
        in.readBytes(this.compressedMappingByteArray);
        this.dataFormatVersion = in.readByte();
        this.compressionModeValue = in.readByte();
        this.applyToParent = in.readBoolean();
        this.lastModifiedUnixDateTime = in.readLong();
        this.createdUnixDateTime = in.readLong();
    }

    @Override
    public Long getKey() {
        return this.pos;
    }

    @Override
    public String getKeyDisplayString() {
        return DhSectionPos.toString(this.pos);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("levelMinY", this.levelMinY).add("pos", this.pos).add("dataChecksum", this.dataChecksum).add("compressedDataByteArray length", this.compressedDataByteArray.length).add("compressedColumnGenStepByteArray length", this.compressedColumnGenStepByteArray.length).add("compressedWorldCompressionModeByteArray length", this.compressedWorldCompressionModeByteArray.length).add("compressedMappingByteArray length", this.compressedMappingByteArray.length).add("dataFormatVersion", (int)this.dataFormatVersion).add("compressionModeValue", (int)this.compressionModeValue).add("applyToParent", this.applyToParent).add("lastModifiedUnixDateTime", this.lastModifiedUnixDateTime).add("createdUnixDateTime", this.createdUnixDateTime).toString();
    }

    public EDhApiDataCompressionMode getCompressionMode() throws IllegalArgumentException {
        return EDhApiDataCompressionMode.getFromValue(this.compressionModeValue);
    }
}

