/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.sql.repo;

import com.seibel.distanthorizons.api.enums.config.EDhApiDataCompressionMode;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.sql.dto.FullDataSourceV2DTO;
import com.seibel.distanthorizons.core.sql.repo.AbstractDhRepo;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataInputStream;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FullDataSourceV2Repo
extends AbstractDhRepo<Long, FullDataSourceV2DTO> {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();

    public FullDataSourceV2Repo(String databaseType, File databaseFile) throws SQLException {
        super(databaseType, databaseFile, FullDataSourceV2DTO.class);
    }

    @Override
    public String getTableName() {
        return "FullData";
    }

    @Override
    public String createWhereStatement(Long pos) {
        int detailLevel = DhSectionPos.getDetailLevel(pos) - 6;
        return "DetailLevel = '" + detailLevel + "' AND PosX = '" + DhSectionPos.getX(pos) + "' AND PosZ = '" + DhSectionPos.getZ(pos) + "'";
    }

    @Override
    public FullDataSourceV2DTO convertDictionaryToDto(Map<String, Object> objectMap) throws ClassCastException {
        byte detailLevel = (Byte)objectMap.get("DetailLevel");
        byte sectionDetailLevel = (byte)(detailLevel + 6);
        int posX = (Integer)objectMap.get("PosX");
        int posZ = (Integer)objectMap.get("PosZ");
        long pos = DhSectionPos.encode(sectionDetailLevel, posX, posZ);
        int minY = (Integer)objectMap.get("MinY");
        int dataChecksum = (Integer)objectMap.get("DataChecksum");
        byte[] dataByteArray = (byte[])objectMap.get("Data");
        byte[] columnGenStepByteArray = (byte[])objectMap.get("ColumnGenerationStep");
        byte[] columnWorldCompressionByteArray = (byte[])objectMap.get("ColumnWorldCompressionMode");
        byte[] mappingByteArray = (byte[])objectMap.get("Mapping");
        byte dataFormatVersion = (Byte)objectMap.get("DataFormatVersion");
        byte compressionModeValue = (Byte)objectMap.get("CompressionMode");
        boolean applyToParent = (Integer)objectMap.get("ApplyToParent") == 1;
        long lastModifiedUnixDateTime = (Long)objectMap.get("LastModifiedUnixDateTime");
        long createdUnixDateTime = (Long)objectMap.get("CreatedUnixDateTime");
        FullDataSourceV2DTO dto = new FullDataSourceV2DTO(pos, dataChecksum, columnGenStepByteArray, columnWorldCompressionByteArray, dataFormatVersion, compressionModeValue, dataByteArray, lastModifiedUnixDateTime, createdUnixDateTime, mappingByteArray, applyToParent, minY);
        return dto;
    }

    @Override
    public PreparedStatement createInsertStatement(FullDataSourceV2DTO dto) throws SQLException {
        String sql = "INSERT INTO " + this.getTableName() + " (\n   DetailLevel, PosX, PosZ, \n   MinY, DataChecksum, \n   Data, ColumnGenerationStep, ColumnWorldCompressionMode, Mapping, \n   DataFormatVersion, CompressionMode, ApplyToParent, \n   LastModifiedUnixDateTime, CreatedUnixDateTime) \nVALUES( \n    ?, ?, ?, \n    ?, ?, \n    ?, ?, ?, ?, \n    ?, ?, ?, \n    ?, ? \n);";
        PreparedStatement statement = this.createPreparedStatement(sql);
        int i = 1;
        statement.setObject(i++, DhSectionPos.getDetailLevel(dto.pos) - 6);
        statement.setObject(i++, DhSectionPos.getX(dto.pos));
        statement.setObject(i++, DhSectionPos.getZ(dto.pos));
        statement.setObject(i++, dto.levelMinY);
        statement.setObject(i++, dto.dataChecksum);
        statement.setObject(i++, dto.compressedDataByteArray);
        statement.setObject(i++, dto.compressedColumnGenStepByteArray);
        statement.setObject(i++, dto.compressedWorldCompressionModeByteArray);
        statement.setObject(i++, dto.compressedMappingByteArray);
        statement.setObject(i++, dto.dataFormatVersion);
        statement.setObject(i++, dto.compressionModeValue);
        statement.setObject(i++, dto.applyToParent);
        statement.setObject(i++, System.currentTimeMillis());
        statement.setObject(i++, System.currentTimeMillis());
        return statement;
    }

    @Override
    public PreparedStatement createUpdateStatement(FullDataSourceV2DTO dto) throws SQLException {
        String sql = "UPDATE " + this.getTableName() + " \nSET \n    MinY = ? \n   ,DataChecksum = ? \n   ,Data = ? \n   ,ColumnGenerationStep = ? \n   ,ColumnWorldCompressionMode = ? \n   ,Mapping = ? \n   ,DataFormatVersion = ? \n   ,CompressionMode = ? \n   ,ApplyToParent = ? \n   ,LastModifiedUnixDateTime = ? \n   ,CreatedUnixDateTime = ? \nWHERE DetailLevel = ? AND PosX = ? AND PosZ = ?";
        PreparedStatement statement = this.createPreparedStatement(sql);
        int i = 1;
        statement.setObject(i++, dto.levelMinY);
        statement.setObject(i++, dto.dataChecksum);
        statement.setObject(i++, dto.compressedDataByteArray);
        statement.setObject(i++, dto.compressedColumnGenStepByteArray);
        statement.setObject(i++, dto.compressedWorldCompressionModeByteArray);
        statement.setObject(i++, dto.compressedMappingByteArray);
        statement.setObject(i++, dto.dataFormatVersion);
        statement.setObject(i++, dto.compressionModeValue);
        statement.setObject(i++, dto.applyToParent);
        statement.setObject(i++, System.currentTimeMillis());
        statement.setObject(i++, dto.createdUnixDateTime);
        statement.setObject(i++, DhSectionPos.getDetailLevel(dto.pos) - 6);
        statement.setObject(i++, DhSectionPos.getX(dto.pos));
        statement.setObject(i++, DhSectionPos.getZ(dto.pos));
        return statement;
    }

    public void setApplyToParent(long pos, boolean applyToParent) throws SQLException {
        int detailLevel = DhSectionPos.getDetailLevel(pos) - 6;
        String sql = "UPDATE " + this.getTableName() + " \nSET ApplyToParent = " + applyToParent + " \nWHERE DetailLevel = " + detailLevel + " AND PosX = " + DhSectionPos.getX(pos) + " AND PosZ = " + DhSectionPos.getZ(pos);
        this.queryDictionaryFirst(sql);
    }

    public LongArrayList getPositionsToUpdate(int returnCount) {
        LongArrayList list = new LongArrayList();
        List<Map<String, Object>> resultMapList = this.queryDictionary("select DetailLevel, PosX, PosZ from " + this.getTableName() + " where ApplyToParent = 1 order by DetailLevel asc LIMIT " + returnCount + ";");
        for (Map<String, Object> resultMap : resultMapList) {
            byte detailLevel = (Byte)resultMap.get("DetailLevel");
            byte sectionDetailLevel = (byte)(detailLevel + 6);
            int posX = (Integer)resultMap.get("PosX");
            int posZ = (Integer)resultMap.get("PosZ");
            long pos = DhSectionPos.encode(sectionDetailLevel, posX, posZ);
            list.add(pos);
        }
        return list;
    }

    public byte[] getColumnGenerationStepForPos(long pos) {
        int detailLevel = DhSectionPos.getDetailLevel(pos) - 6;
        Map<String, Object> resultMap = this.queryDictionaryFirst("select ColumnGenerationStep, CompressionMode from " + this.getTableName() + " WHERE DetailLevel = " + detailLevel + " AND PosX = " + DhSectionPos.getX(pos) + " AND PosZ = " + DhSectionPos.getZ(pos));
        if (resultMap != null) {
            byte[] compressedByteArray = (byte[])resultMap.get("ColumnGenerationStep");
            byte compressionModeEnumValue = (Byte)resultMap.get("CompressionMode");
            EDhApiDataCompressionMode compressionModeEnum = EDhApiDataCompressionMode.getFromValue(compressionModeEnumValue);
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(compressedByteArray);
                DhDataInputStream compressedIn = new DhDataInputStream(byteArrayInputStream, compressionModeEnum);
                byte[] columnGenStepByteArray = new byte[4096];
                compressedIn.readFully(columnGenStepByteArray);
                return columnGenStepByteArray;
            }
            catch (IOException e) {
                LOGGER.warn("Decompression issue when getting column gen steps for pos: [" + DhSectionPos.toString(pos) + "]", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    @Nullable
    public Long getTimestampForPos(long pos) {
        try {
            PreparedStatement preparedStatement = this.createPreparedStatement("SELECT LastModifiedUnixDateTime FROM " + this.getTableName() + " WHERE DetailLevel = ? AND PosX = ? AND PosZ = ?;");
            int i = 1;
            preparedStatement.setInt(i++, DhSectionPos.getDetailLevel(pos) - 6);
            preparedStatement.setInt(i++, DhSectionPos.getX(pos));
            preparedStatement.setInt(i++, DhSectionPos.getZ(pos));
            List<Map<String, Object>> row = this.queryDictionary(preparedStatement);
            return !row.isEmpty() ? (Long)row.get(0).get("LastModifiedUnixDateTime") : null;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<Long, Long> getTimestampsForRange(byte detailLevel, int startPosX, int startPosZ, int endPosX, int endPosZ) {
        try {
            PreparedStatement preparedStatement = this.createPreparedStatement("SELECT PosX, PosZ, LastModifiedUnixDateTime FROM " + this.getTableName() + " WHERE DetailLevel = ? AND PosX BETWEEN ? AND ? AND PosZ BETWEEN ? AND ?;");
            int i = 1;
            preparedStatement.setInt(i++, detailLevel - 6);
            preparedStatement.setInt(i++, startPosX);
            preparedStatement.setInt(i++, endPosX);
            preparedStatement.setInt(i++, startPosZ);
            preparedStatement.setInt(i++, endPosZ);
            return this.queryDictionary(preparedStatement).stream().collect(Collectors.toMap(row -> DhSectionPos.encode(detailLevel, (Integer)row.get("PosX"), (Integer)row.get("PosZ")), row -> (long)((Long)row.get("LastModifiedUnixDateTime"))));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public LongArrayList getAllPositions() {
        LongArrayList list = new LongArrayList();
        List<Map<String, Object>> resultMapList = this.queryDictionary("select DetailLevel, PosX, PosZ from " + this.getTableName() + "; ");
        for (Map<String, Object> resultMap : resultMapList) {
            byte detailLevel = (Byte)resultMap.get("DetailLevel");
            byte sectionDetailLevel = (byte)(detailLevel + 6);
            int posX = (Integer)resultMap.get("PosX");
            int posZ = (Integer)resultMap.get("PosZ");
            long pos = DhSectionPos.encode(sectionDetailLevel, posX, posZ);
            list.add(pos);
        }
        return list;
    }

    public long getDataSizeInBytes(long pos) {
        int detailLevel = DhSectionPos.getDetailLevel(pos) - 6;
        Map<String, Object> resultMap = this.queryDictionaryFirst("select LENGTH(Data) as dataSize from " + this.getTableName() + " WHERE DetailLevel = " + detailLevel + " AND PosX = " + DhSectionPos.getX(pos) + " AND PosZ = " + DhSectionPos.getZ(pos));
        if (resultMap != null && resultMap.get("dataSize") != null) {
            Number resultNumber = (Number)resultMap.get("dataSize");
            long dataLength = resultNumber.longValue();
            return dataLength;
        }
        return 0L;
    }

    public long getTotalDataSizeInBytes() {
        Map<String, Object> resultMap = this.queryDictionaryFirst("select SUM(LENGTH(Data)) as dataSize from " + this.getTableName() + "; ");
        if (resultMap != null && resultMap.get("dataSize") != null) {
            Number resultNumber = (Number)resultMap.get("dataSize");
            long dataLength = resultNumber.longValue();
            return dataLength;
        }
        return 0L;
    }
}

