/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util;

import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.objects.DataCorruptedException;
import com.seibel.distanthorizons.coreapi.ModInfo;
import org.jetbrains.annotations.Contract;

public class FullDataPointUtil {
    public static final boolean RUN_VALIDATION = ModInfo.IS_DEV_BUILD;
    public static final int EMPTY_DATA_POINT = 0;
    public static final int ID_WIDTH = 32;
    public static final int HEIGHT_WIDTH = 12;
    public static final int MIN_Y_WIDTH = 12;
    public static final int SKY_LIGHT_WIDTH = 4;
    public static final int BLOCK_LIGHT_WIDTH = 4;
    public static final int ID_OFFSET = 0;
    public static final int HEIGHT_OFFSET = 32;
    public static final int MIN_Y_OFFSET = 44;
    public static final int SKY_LIGHT_OFFSET = 56;
    public static final int BLOCK_LIGHT_OFFSET = 60;
    public static final long ID_MASK = Integer.MAX_VALUE;
    public static final long INVERSE_ID_MASK = Integer.MIN_VALUE;
    public static final int HEIGHT_MASK = (int)Math.pow(2.0, 12.0) - 1;
    public static final int MIN_Y_MASK = (int)Math.pow(2.0, 12.0) - 1;
    public static final int SKY_LIGHT_MASK = (int)Math.pow(2.0, 4.0) - 1;
    public static final int BLOCK_LIGHT_MASK = (int)Math.pow(2.0, 4.0) - 1;

    public static long encode(int id, int height, int relMinY, byte blockLight, byte skyLight) throws DataCorruptedException {
        if (RUN_VALIDATION) {
            FullDataPointUtil.validateData(id, height, relMinY, blockLight, skyLight);
        }
        long data = 0L;
        data |= (long)id & Integer.MAX_VALUE;
        data |= (long)(height & HEIGHT_MASK) << 32;
        data |= (long)(relMinY & MIN_Y_MASK) << 44;
        data |= (long)blockLight << 60;
        if (RUN_VALIDATION && (FullDataPointUtil.getId(data |= (long)skyLight << 56) != id || FullDataPointUtil.getHeight(data) != height || FullDataPointUtil.getBottomY(data) != relMinY || FullDataPointUtil.getBlockLight(data) != Byte.toUnsignedInt(blockLight) || FullDataPointUtil.getSkyLight(data) != Byte.toUnsignedInt(skyLight))) {
            LodUtil.assertNotReach("Trying to create datapoint with id[" + id + "], height[" + height + "], minY[" + relMinY + "], blockLight[" + blockLight + "], skyLight[" + skyLight + "] but got id[" + FullDataPointUtil.getId(data) + "], height[" + FullDataPointUtil.getHeight(data) + "], minY[" + FullDataPointUtil.getBottomY(data) + "], blockLight[" + FullDataPointUtil.getBlockLight(data) + "], skyLight[" + FullDataPointUtil.getSkyLight(data) + "]!");
        }
        return data;
    }

    public static void validateDatapoint(long datapoint) throws DataCorruptedException {
        FullDataPointUtil.validateData(FullDataPointUtil.getId(datapoint), FullDataPointUtil.getHeight(datapoint), FullDataPointUtil.getBottomY(datapoint), (byte)FullDataPointUtil.getBlockLight(datapoint), (byte)FullDataPointUtil.getSkyLight(datapoint));
    }

    public static void validateData(int id, int height, int relMinY, byte blockLight, byte skyLight) throws DataCorruptedException {
        if (id < 0) {
            throw new DataCorruptedException("Full datapoint ID [" + relMinY + "] must be greater than zero.");
        }
        if (relMinY < 0 || relMinY >= 4096) {
            throw new DataCorruptedException("Full datapoint relative min y [" + relMinY + "] must be in the range [0 - " + 4096 + "] (inclusive).");
        }
        if (height <= 0 || height >= 4096) {
            throw new DataCorruptedException("Full datapoint height [" + height + "] must be in the range [1 - " + 4096 + "] (inclusive).");
        }
        if (relMinY + height > 4096) {
            throw new DataCorruptedException("Full datapoint y+depth [" + (relMinY + height) + "] is higher than the maximum world Y height [" + 4096 + "].");
        }
        if (blockLight < 0 || blockLight > 15) {
            throw new DataCorruptedException("Full datapoint block light [" + blockLight + "] must be in the range [" + 0 + " - " + 15 + "] (inclusive).");
        }
        if (skyLight < 0 || skyLight > 15) {
            throw new DataCorruptedException("Full datapoint sky light [" + skyLight + "] must be in the range [" + 0 + " - " + 15 + "] (inclusive).");
        }
    }

    public static int getId(long data) {
        return (int)(data & Integer.MAX_VALUE);
    }

    public static int getHeight(long data) {
        return (int)(data >> 32 & (long)HEIGHT_MASK);
    }

    public static int getBottomY(long data) {
        return (int)(data >> 44 & (long)MIN_Y_MASK);
    }

    public static int getBlockLight(long data) {
        return (int)(data >> 60 & (long)BLOCK_LIGHT_MASK);
    }

    public static int getSkyLight(long data) {
        return (int)(data >> 56 & (long)SKY_LIGHT_MASK);
    }

    public static long setBlockLight(long data, byte blockLight) {
        return data & ((long)BLOCK_LIGHT_MASK << 60 ^ 0xFFFFFFFFFFFFFFFFL) | (long)blockLight << 60;
    }

    public static long setSkyLight(long data, int skyLight) {
        return data & ((long)SKY_LIGHT_MASK << 56 ^ 0xFFFFFFFFFFFFFFFFL) | (long)skyLight << 56;
    }

    public static String toString(long data) {
        return "[ID:" + FullDataPointUtil.getId(data) + ",Y:" + FullDataPointUtil.getBottomY(data) + ",Height:" + FullDataPointUtil.getHeight(data) + ",BlockLight:" + FullDataPointUtil.getBlockLight(data) + ",SkyLight:" + FullDataPointUtil.getSkyLight(data) + "]";
    }

    @Contract(pure=true)
    public static long remap(int[] newIdMapping, long data) throws IndexOutOfBoundsException {
        int currentId = FullDataPointUtil.getId(data);
        try {
            int newId = newIdMapping[currentId];
            return data & Integer.MIN_VALUE | (long)newId;
        }
        catch (IndexOutOfBoundsException e) {
            throw new RuntimeException(e);
        }
    }
}

