/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util;

import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.util.math.Mat4f;
import com.seibel.distanthorizons.core.world.IDhClientWorld;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.coreapi.util.MathUtil;

public class RenderUtil {
    private static final IMinecraftClientWrapper MC = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);

    public static Mat4f createLodProjectionMatrix(Mat4f mcProjMat, float partialTicks) {
        float nearClipDist = RenderUtil.getNearClipPlaneDistanceInBlocks(partialTicks);
        float farClipDist = RenderUtil.getFarClipPlaneDistanceInBlocks();
        Mat4f lodProj = mcProjMat.copy();
        lodProj.setClipPlanes(nearClipDist, farClipDist);
        return lodProj;
    }

    public static Mat4f createLodModelViewMatrix(Mat4f mcModelViewMat) {
        return mcModelViewMat.copy();
    }

    public static float getNearClipPlaneDistanceInBlocks(float partialTicks) {
        float nearClipPlane;
        int chunkRenderDistance = MC_RENDER.getRenderDistance();
        int vanillaBlockRenderedDistance = chunkRenderDistance * 16;
        if (Config.Client.Advanced.Debugging.lodOnlyMode.get().booleanValue()) {
            nearClipPlane = 0.1f;
        } else {
            nearClipPlane = Config.Client.Advanced.Graphics.AdvancedGraphics.overdrawPrevention.get().floatValue();
            if ((nearClipPlane *= (float)vanillaBlockRenderedDistance) < 0.1f) {
                nearClipPlane = 0.1f;
            }
        }
        float heightOverride = RenderUtil.getHeightBasedNearClipOverride();
        if (heightOverride != -1.0f) {
            nearClipPlane = heightOverride;
        }
        double fov = MC_RENDER.getFov(partialTicks);
        double aspectRatio = (double)MC_RENDER.getScreenWidth() / (double)MC_RENDER.getScreenHeight();
        return (float)((double)nearClipPlane / Math.sqrt(1.0 + MathUtil.pow2(Math.tan(fov / 180.0 * Math.PI / 2.0)) * (MathUtil.pow2(aspectRatio) + 1.0)));
    }

    public static int getFarClipPlaneDistanceInBlocks() {
        int lodChunkDist = Config.Client.Advanced.Graphics.Quality.lodChunkRenderDistanceRadius.get();
        int lodBlockDist = lodChunkDist * 16;
        return (int)((double)(lodBlockDist + 512) * Math.sqrt(2.0));
    }

    public static float getHeightBasedNearClipOverride() {
        int levelMaxHeight;
        int playerHeight;
        IClientLevelWrapper level = MC.getWrappedClientLevel();
        if (level != null && (playerHeight = MC.getPlayerBlockPos().getY()) > (levelMaxHeight = level.getMaxHeight()) + 1000) {
            return playerHeight - (levelMaxHeight + 1000);
        }
        return -1.0f;
    }

    public static boolean shouldLodsRender(ILevelWrapper levelWrapper) {
        if (!MC.playerExists()) {
            return false;
        }
        if (levelWrapper == null) {
            return false;
        }
        IDhClientWorld clientWorld = SharedApi.getIDhClientWorld();
        if (clientWorld == null) {
            return false;
        }
        IDhClientLevel level = clientWorld.getClientLevel(levelWrapper);
        if (level == null) {
            return false;
        }
        return MC_RENDER.getLightmapWrapper(levelWrapper) != null;
    }
}

