/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.world;

import com.seibel.distanthorizons.core.file.structure.LocalSaveStructure;
import com.seibel.distanthorizons.core.level.AbstractDhServerLevel;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.multiplayer.server.ServerPlayerState;
import com.seibel.distanthorizons.core.multiplayer.server.ServerPlayerStateManager;
import com.seibel.distanthorizons.core.world.AbstractDhWorld;
import com.seibel.distanthorizons.core.world.EWorldEnvironment;
import com.seibel.distanthorizons.core.world.IDhServerWorld;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.IServerPlayerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import java.util.HashMap;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDhServerWorld<TDhServerLevel extends AbstractDhServerLevel>
extends AbstractDhWorld
implements IDhServerWorld {
    protected final HashMap<ILevelWrapper, TDhServerLevel> dhLevelByLevelWrapper = new HashMap();
    public final LocalSaveStructure saveStructure = new LocalSaveStructure();
    private final ServerPlayerStateManager serverPlayerStateManager = new ServerPlayerStateManager();

    public AbstractDhServerWorld(EWorldEnvironment worldEnvironment) {
        super(worldEnvironment);
    }

    @Override
    public ServerPlayerStateManager getServerPlayerStateManager() {
        return this.serverPlayerStateManager;
    }

    @Override
    public void addPlayer(IServerPlayerWrapper serverPlayer) {
        ServerPlayerState playerState = this.serverPlayerStateManager.registerJoinedPlayer(serverPlayer);
        ((AbstractDhServerLevel)this.getLevel(serverPlayer.getLevel())).addPlayer(serverPlayer);
        for (AbstractDhServerLevel level : this.dhLevelByLevelWrapper.values().stream().distinct()::iterator) {
            level.registerNetworkHandlers(playerState);
        }
        this.serverPlayerStateManager.handlePluginMessagesFromQueue(playerState);
    }

    @Override
    public void removePlayer(IServerPlayerWrapper serverPlayer) {
        ((AbstractDhServerLevel)this.getLevel(serverPlayer.getLevel())).removePlayer(serverPlayer);
        this.serverPlayerStateManager.unregisterLeftPlayer(serverPlayer);
    }

    @Override
    public void changePlayerLevel(IServerPlayerWrapper player, IServerLevelWrapper originLevel, IServerLevelWrapper destinationLevel) {
        ((AbstractDhServerLevel)this.getLevel(destinationLevel)).addPlayer(player);
        ((AbstractDhServerLevel)this.getLevel(originLevel)).removePlayer(player);
    }

    public TDhServerLevel getLevel(@NotNull ILevelWrapper wrapper) {
        return (TDhServerLevel)((AbstractDhServerLevel)this.dhLevelByLevelWrapper.get(wrapper));
    }

    @Override
    public Iterable<? extends IDhLevel> getAllLoadedLevels() {
        return new HashSet<TDhServerLevel>(this.dhLevelByLevelWrapper.values());
    }

    @Override
    public int getLoadedLevelCount() {
        return this.dhLevelByLevelWrapper.size();
    }

    @Override
    public void serverTick() {
        this.dhLevelByLevelWrapper.values().forEach(AbstractDhServerLevel::serverTick);
    }

    @Override
    public void worldGenTick() {
        this.dhLevelByLevelWrapper.values().forEach(AbstractDhServerLevel::worldGenTick);
    }

    @Override
    public void close() {
        for (AbstractDhServerLevel level : this.dhLevelByLevelWrapper.values()) {
            LOGGER.info("Unloading level [" + level.getLevelWrapper().getDimensionName() + "].");
            IServerLevelWrapper serverLevelWrapper = level.getServerLevelWrapper();
            if (serverLevelWrapper != null) {
                serverLevelWrapper.onUnload();
            }
            level.close();
        }
        this.dhLevelByLevelWrapper.clear();
        LOGGER.info("Closed DhWorld of type [" + (Object)((Object)this.environment) + "].");
    }
}

