/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.world;

import com.seibel.distanthorizons.core.level.DhClientServerLevel;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.ThreadUtil;
import com.seibel.distanthorizons.core.util.objects.EventLoop;
import com.seibel.distanthorizons.core.world.AbstractDhServerWorld;
import com.seibel.distanthorizons.core.world.EWorldEnvironment;
import com.seibel.distanthorizons.core.world.IDhClientWorld;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;

public class DhClientServerWorld
extends AbstractDhServerWorld<DhClientServerLevel>
implements IDhClientWorld {
    private final Set<DhClientServerLevel> dhLevels = Collections.synchronizedSet(new HashSet());
    public ExecutorService dhTickerThread = ThreadUtil.makeSingleThreadPool("Client Server World Ticker Thread", 2);
    public EventLoop eventLoop = new EventLoop(this.dhTickerThread, this::_clientTick);

    public DhClientServerWorld() {
        super(EWorldEnvironment.Client_Server);
        LOGGER.info("Started DhWorld of type " + (Object)((Object)this.environment));
    }

    @Override
    public DhClientServerLevel getOrLoadLevel(@NotNull ILevelWrapper wrapper) {
        if (wrapper instanceof IServerLevelWrapper) {
            return this.dhLevelByLevelWrapper.computeIfAbsent(wrapper, levelWrapper -> {
                File levelFile = this.saveStructure.getLevelFolder((ILevelWrapper)levelWrapper);
                LodUtil.assertTrue(levelFile != null);
                DhClientServerLevel level = new DhClientServerLevel(this.saveStructure, (IServerLevelWrapper)levelWrapper, this.getServerPlayerStateManager());
                this.dhLevels.add(level);
                return level;
            });
        }
        return this.dhLevelByLevelWrapper.computeIfAbsent(wrapper, levelWrapper -> {
            DhClientServerLevel level;
            IClientLevelWrapper clientLevelWrapper = (IClientLevelWrapper)levelWrapper;
            IServerLevelWrapper serverLevelWrapper = clientLevelWrapper.tryGetServerSideWrapper();
            LodUtil.assertTrue(serverLevelWrapper != null);
            if (!clientLevelWrapper.getDimensionType().equals(serverLevelWrapper.getDimensionType())) {
                LodUtil.assertNotReach("tryGetServerSideWrapper returned a level for a different dimension. ClientLevelWrapper dim: " + clientLevelWrapper.getDimensionName() + " ServerLevelWrapper dim: " + serverLevelWrapper.getDimensionName());
            }
            if ((level = (DhClientServerLevel)this.dhLevelByLevelWrapper.get(serverLevelWrapper)) == null) {
                return null;
            }
            level.startRenderer(clientLevelWrapper);
            clientLevelWrapper.setParentLevel(level);
            return level;
        });
    }

    @Override
    public void unloadLevel(@NotNull ILevelWrapper wrapper) {
        if (this.dhLevelByLevelWrapper.containsKey(wrapper)) {
            if (wrapper instanceof IServerLevelWrapper) {
                LOGGER.info("Unloading level " + this.dhLevelByLevelWrapper.get(wrapper));
                wrapper.onUnload();
                DhClientServerLevel clientServerLevel = (DhClientServerLevel)this.dhLevelByLevelWrapper.remove(wrapper);
                clientServerLevel.close();
                this.dhLevels.remove(clientServerLevel);
            } else {
                ((DhClientServerLevel)this.dhLevelByLevelWrapper.remove(wrapper)).stopRenderer();
            }
        }
    }

    private void _clientTick() {
        this.dhLevels.forEach(DhClientServerLevel::clientTick);
    }

    @Override
    public void clientTick() {
        this.eventLoop.tick();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        Set<DhClientServerLevel> set = this.dhLevels;
        synchronized (set) {
            for (DhClientServerLevel level : this.dhLevels) {
                LOGGER.info("Unloading level " + level.getServerLevelWrapper().getDimensionName());
                IServerLevelWrapper serverLevelWrapper = level.getServerLevelWrapper();
                if (serverLevelWrapper != null) {
                    serverLevelWrapper.onUnload();
                }
                level.close();
            }
        }
        this.dhLevelByLevelWrapper.clear();
        this.eventLoop.close();
        LOGGER.info("Closed DhWorld of type " + (Object)((Object)this.environment));
    }
}

