/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.world;

import com.seibel.distanthorizons.core.level.DhServerLevel;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.world.AbstractDhServerWorld;
import com.seibel.distanthorizons.core.world.EWorldEnvironment;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class DhServerWorld
extends AbstractDhServerWorld<DhServerLevel> {
    public DhServerWorld() {
        super(EWorldEnvironment.Server_Only);
        LOGGER.info("Started [" + DhServerWorld.class.getSimpleName() + "] of type [" + (Object)((Object)this.environment) + "].");
    }

    @Override
    public DhServerLevel getOrLoadLevel(@NotNull ILevelWrapper wrapper) {
        if (!(wrapper instanceof IServerLevelWrapper)) {
            return null;
        }
        return this.dhLevelByLevelWrapper.computeIfAbsent(wrapper, serverLevelWrapper -> {
            File levelFile = this.saveStructure.getLevelFolder(wrapper);
            LodUtil.assertTrue(levelFile != null);
            return new DhServerLevel(this.saveStructure, (IServerLevelWrapper)serverLevelWrapper, this.getServerPlayerStateManager());
        });
    }

    @Override
    public void unloadLevel(@NotNull ILevelWrapper wrapper) {
        if (!(wrapper instanceof IServerLevelWrapper)) {
            return;
        }
        if (this.dhLevelByLevelWrapper.containsKey(wrapper)) {
            LOGGER.info("Unloading level {} ", this.dhLevelByLevelWrapper.get(wrapper));
            wrapper.onUnload();
            ((DhServerLevel)this.dhLevelByLevelWrapper.remove(wrapper)).close();
        }
    }
}

