/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiAfterDhInitEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeDhInitEvent;
import com.seibel.distanthorizons.core.api.internal.ClientApi;
import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.ConfigBase;
import com.seibel.distanthorizons.core.config.eventHandlers.presets.ThreadPresetConfigEventHandler;
import com.seibel.distanthorizons.core.config.types.AbstractConfigType;
import com.seibel.distanthorizons.core.config.types.ConfigEntry;
import com.seibel.distanthorizons.core.dependencyInjection.ModAccessorInjector;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.jar.ModJarInfo;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.network.messages.MessageRegistry;
import com.seibel.distanthorizons.core.network.messages.base.CodecCrashMessage;
import com.seibel.distanthorizons.core.util.objects.Pair;
import com.seibel.distanthorizons.core.world.DhServerWorld;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.IServerPlayerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IModAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IModChecker;
import com.seibel.distanthorizons.coreapi.DependencyInjection.ApiEventInjector;
import com.seibel.distanthorizons.coreapi.ModInfo;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.DependencySetup;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.minecraft.MinecraftServerWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.misc.ServerPlayerWrapper;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerPlayer;
import org.apache.logging.log4j.Logger;

public abstract class AbstractModInitializer {
    protected static final Logger LOGGER = DhLoggerBuilder.getLogger(MethodHandles.lookup().lookupClass().getSimpleName());
    private CommandDispatcher<CommandSourceStack> commandDispatcher;

    protected abstract void createInitialBindings();

    protected abstract IEventProxy createClientProxy();

    protected abstract IEventProxy createServerProxy(boolean var1);

    protected abstract void initializeModCompat();

    protected abstract void subscribeRegisterCommandsEvent(Consumer<CommandDispatcher<CommandSourceStack>> var1);

    protected abstract void subscribeClientStartedEvent(Runnable var1);

    protected abstract void subscribeServerStartingEvent(Consumer<MinecraftServer> var1);

    protected abstract void runDelayedSetup();

    public void onInitializeClient() {
        DependencySetup.createClientBindings();
        LOGGER.info("Initializing Distant Horizons client.");
        ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeDhInitEvent.class, null);
        this.startup();
        this.logBuildInfo();
        this.createClientProxy().registerEvents();
        this.createServerProxy(false).registerEvents();
        this.initializeModCompat();
        LOGGER.info("Distant Horizons client Initialized.");
        ApiEventInjector.INSTANCE.fireAllEvents(DhApiAfterDhInitEvent.class, null);
        this.initConfig();
        this.subscribeClientStartedEvent(this::postInit);
    }

    public void onInitializeServer() {
        DependencySetup.createServerBindings();
        LOGGER.info("Initializing Distant Horizons server.");
        ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeDhInitEvent.class, null);
        this.startup();
        this.logBuildInfo();
        ThreadPresetConfigEventHandler.INSTANCE.toString();
        this.createServerProxy(true).registerEvents();
        this.initializeModCompat();
        LOGGER.info("Distant Horizons server Initialized.");
        ApiEventInjector.INSTANCE.fireAllEvents(DhApiAfterDhInitEvent.class, null);
        this.subscribeRegisterCommandsEvent(dispatcher -> {
            this.commandDispatcher = dispatcher;
        });
        this.subscribeServerStartingEvent(server -> {
            MinecraftServerWrapper.INSTANCE.dedicatedServer = (DedicatedServer)server;
            this.initConfig();
            this.postInit();
            this.initCommands();
            LOGGER.info("Dedicated server initialized at " + String.valueOf(server.m_6237_()));
        });
    }

    private void startup() {
        DependencySetup.createSharedBindings();
        SharedApi.init();
        this.createInitialBindings();
        AbstractModInitializer.logModIncompatibilityWarnings();
    }

    private void logBuildInfo() {
        LOGGER.info("Distant Horizons, Version: 2.3.0-a-dev");
        if (ModInfo.IS_DEV_BUILD) {
            LOGGER.info("DH Branch: " + ModJarInfo.Git_Branch);
            LOGGER.info("DH Commit: " + ModJarInfo.Git_Commit);
            LOGGER.info("DH Jar Build Source: " + ModJarInfo.Build_Source);
        }
    }

    protected <T extends IModAccessor> void tryCreateModCompatAccessor(String modId, Class<? super T> accessorClass, Supplier<T> accessorConstructor) {
        IModChecker modChecker = SingletonInjector.INSTANCE.get(IModChecker.class);
        if (modChecker.isModLoaded(modId)) {
            ModAccessorInjector.INSTANCE.bind(accessorClass, (IModAccessor)accessorConstructor.get());
        }
    }

    private void initConfig() {
        ConfigBase.INSTANCE = new ConfigBase("distanthorizons", "DistantHorizons", Config.class, 2);
        Config.completeDelayedSetup();
    }

    private void postInit() {
        LOGGER.info("Post-Initializing Mod");
        this.runDelayedSetup();
        LOGGER.info("Mod Post-Initialized");
    }

    private void initCommands() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"dhconfig").requires(source -> source.m_6761_(4));
        for (AbstractConfigType<?, ?> type2 : ConfigBase.INSTANCE.entries) {
            ConfigEntry configEntry;
            if (!(type2 instanceof ConfigEntry) || (configEntry = (ConfigEntry)type2).getServersideShortName() == null) continue;
            Function<Function, Command> makeConfigUpdater = getter -> commandContext -> {
                Object value = getter.apply(commandContext);
                ((CommandSourceStack)commandContext.getSource()).m_288197_(() -> Component.m_237113_((String)("Changed the value of " + configEntry.getServersideShortName() + " to " + String.valueOf(value))), true);
                configEntry.set(value);
                return 1;
            };
            LiteralArgumentBuilder subcommand = (LiteralArgumentBuilder)Commands.m_82127_((String)configEntry.getServersideShortName()).executes(commandContext -> {
                ((CommandSourceStack)commandContext.getSource()).m_288197_(() -> Component.m_237113_((String)("Current value of " + configEntry.getServersideShortName() + " is " + String.valueOf(configEntry.get()))), true);
                return 1;
            });
            if (Enum.class.isAssignableFrom(configEntry.getType())) {
                for (Object choice : configEntry.getType().getEnumConstants()) {
                    subcommand.then(Commands.m_82127_((String)choice.toString()).executes(makeConfigUpdater.apply(c -> choice)));
                }
            } else {
                boolean setterAdded = false;
                for (Map.Entry pair : new HashMap<Class<?>, Pair<Supplier<ArgumentType<?>>, BiFunction<CommandContext<?>, String, ?>>>(){
                    {
                        this.put(Integer.class, new Pair<Supplier<ArgumentType>, BiFunction<CommandContext, String, Object>>(() -> IntegerArgumentType.integer((int)((Integer)configEntry.getMin()), (int)((Integer)configEntry.getMax())), IntegerArgumentType::getInteger));
                        this.put(Double.class, new Pair<Supplier<ArgumentType>, BiFunction<CommandContext, String, Object>>(() -> DoubleArgumentType.doubleArg((double)((Double)configEntry.getMin()), (double)((Double)configEntry.getMax())), DoubleArgumentType::getDouble));
                        this.put(Boolean.class, new Pair<Supplier<ArgumentType>, BiFunction<CommandContext, String, Object>>(BoolArgumentType::bool, BoolArgumentType::getBool));
                        this.put(String.class, new Pair<Supplier<ArgumentType>, BiFunction<CommandContext, String, Object>>(StringArgumentType::string, StringArgumentType::getString));
                    }
                }.entrySet()) {
                    if (!((Class)pair.getKey()).isAssignableFrom(configEntry.getType())) continue;
                    subcommand.then(Commands.m_82129_((String)"value", (ArgumentType)((ArgumentType)((Supplier)((Pair)pair.getValue()).first).get())).executes(makeConfigUpdater.apply(c -> ((BiFunction)((Pair)pair.getValue()).second).apply(c, "value"))));
                    setterAdded = true;
                    break;
                }
                if (!setterAdded) {
                    throw new RuntimeException("Config type of " + type2.getName() + " is not supported: " + configEntry.getType().getSimpleName());
                }
            }
            builder.then((ArgumentBuilder)subcommand);
        }
        this.commandDispatcher.register(builder);
        if (MessageRegistry.DEBUG_CODEC_CRASH_MESSAGE) {
            LiteralArgumentBuilder dhcrash = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"dhcrash").requires(source -> source.m_6761_(4))).then(Commands.m_82127_((String)"encode").executes(c -> {
                assert (SharedApi.getIDhServerWorld() != null);
                ((DhServerWorld)SharedApi.getIDhServerWorld()).getServerPlayerStateManager().getConnectedPlayer((IServerPlayerWrapper)ServerPlayerWrapper.getWrapper((ServerPlayer)Objects.requireNonNull(((CommandSourceStack)c.getSource()).m_230896_()))).networkSession.sendMessage(new CodecCrashMessage(CodecCrashMessage.ECrashPhase.ENCODE));
                return 1;
            }))).then(Commands.m_82127_((String)"decode").executes(c -> {
                assert (SharedApi.getIDhServerWorld() != null);
                ((DhServerWorld)SharedApi.getIDhServerWorld()).getServerPlayerStateManager().getConnectedPlayer((IServerPlayerWrapper)ServerPlayerWrapper.getWrapper((ServerPlayer)Objects.requireNonNull(((CommandSourceStack)c.getSource()).m_230896_()))).networkSession.sendMessage(new CodecCrashMessage(CodecCrashMessage.ECrashPhase.DECODE));
                return 1;
            }));
            this.commandDispatcher.register(dhcrash);
        }
    }

    private static void logModIncompatibilityWarnings() {
        boolean showChatWarnings = Config.Client.Advanced.Logging.showModCompatibilityWarningsOnStartup.get();
        IModChecker modChecker = SingletonInjector.INSTANCE.get(IModChecker.class);
        String startingString = "Partially Incompatible Distant Horizons mod detected: ";
        if (modChecker.isModLoaded("alexscaves")) {
            if (showChatWarnings) {
                String message = "\u00a76Distant Horizons: Alex's Cave detected.\u00a7r\nYou may have to change Alex's config for DH to render. ";
                ClientApi.INSTANCE.showChatMessageNextFrame(message);
            }
            LOGGER.warn(startingString + "[Alex's Caves] may require some config changes in order to render Distant Horizons correctly.");
        }
        if (modChecker.isModLoaded("wwoo")) {
            String wwooWarning = "LODs generated by DH may have grid lines between sections. Disabling either WWOO or DH's distant generator will fix the problem.";
            if (showChatWarnings) {
                String message = "\u00a76Distant Horizons: WWOO detected.\u00a7r\n" + wwooWarning;
                ClientApi.INSTANCE.showChatMessageNextFrame(message);
            }
            LOGGER.warn(startingString + "[WWOO] " + wwooWarning);
        }
    }

    public static interface IEventProxy {
        public void registerEvents();
    }
}

