/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.minecraft;

import com.mojang.blaze3d.platform.NativeImage;
import com.seibel.distanthorizons.api.enums.config.EDhApiLodShading;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftSharedWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IProfilerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.UUID;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.McObjectConverter;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.minecraft.ProfilerWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.world.ClientLevelWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.world.ServerLevelWrapper;
import net.minecraft.CrashReport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class MinecraftClientWrapper
implements IMinecraftClientWrapper,
IMinecraftSharedWrapper {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger(MethodHandles.lookup().lookupClass().getSimpleName());
    private static final Minecraft MINECRAFT = Minecraft.m_91087_();
    public static final MinecraftClientWrapper INSTANCE = new MinecraftClientWrapper();
    private NativeImage lightMap = null;
    private ProfilerWrapper profilerWrapper;

    private MinecraftClientWrapper() {
    }

    @Override
    public void clearFrameObjectCache() {
        this.lightMap = null;
    }

    @Override
    public float getShade(EDhDirection lodDirection) {
        EDhApiLodShading lodShading = Config.Client.Advanced.Graphics.AdvancedGraphics.lodShading.get();
        switch (lodShading) {
            default: {
                if (MinecraftClientWrapper.MINECRAFT.f_91073_ != null) {
                    Direction mcDir = McObjectConverter.Convert(lodDirection);
                    return MinecraftClientWrapper.MINECRAFT.f_91073_.m_7717_(mcDir, true);
                }
                return 0.0f;
            }
            case ENABLED: {
                switch (lodDirection) {
                    case DOWN: {
                        return 0.5f;
                    }
                    default: {
                        return 1.0f;
                    }
                    case NORTH: 
                    case SOUTH: {
                        return 0.8f;
                    }
                    case WEST: 
                    case EAST: 
                }
                return 0.6f;
            }
            case DISABLED: 
        }
        return 1.0f;
    }

    @Override
    public boolean hasSinglePlayerServer() {
        return MINECRAFT.m_91091_();
    }

    @Override
    public boolean clientConnectedToDedicatedServer() {
        return MINECRAFT.m_91089_() != null && !this.hasSinglePlayerServer();
    }

    @Override
    public boolean connectedToReplay() {
        return !MINECRAFT.m_91091_() && MINECRAFT.m_91089_() == null;
    }

    @Override
    public String getCurrentServerName() {
        if (this.connectedToReplay()) {
            return "REPLAY";
        }
        ServerData server = MINECRAFT.m_91089_();
        return server != null ? server.f_105362_ : "NULL";
    }

    @Override
    public String getCurrentServerIp() {
        if (this.connectedToReplay()) {
            return "";
        }
        ServerData server = MINECRAFT.m_91089_();
        return server != null ? server.f_105363_ : "NA";
    }

    @Override
    public String getCurrentServerVersion() {
        ServerData server = MINECRAFT.m_91089_();
        return server != null ? server.f_105368_.getString() : "UNKOWN";
    }

    public LocalPlayer getPlayer() {
        return MinecraftClientWrapper.MINECRAFT.f_91074_;
    }

    @Override
    public boolean playerExists() {
        return MinecraftClientWrapper.MINECRAFT.f_91074_ != null;
    }

    @Override
    public UUID getPlayerUUID() {
        return this.getPlayer().m_20148_();
    }

    @Override
    public DhBlockPos getPlayerBlockPos() {
        BlockPos playerPos = this.getPlayer().m_20183_();
        return new DhBlockPos(playerPos.m_123341_(), playerPos.m_123342_(), playerPos.m_123343_());
    }

    @Override
    public DhChunkPos getPlayerChunkPos() {
        ChunkPos playerPos = this.getPlayer().m_146902_();
        return new DhChunkPos(playerPos.f_45578_, playerPos.f_45579_);
    }

    @Override
    @Nullable
    public IClientLevelWrapper getWrappedClientLevel() {
        return this.getWrappedClientLevel(false);
    }

    @Override
    @Nullable
    public IClientLevelWrapper getWrappedClientLevel(boolean bypassLevelKeyManager) {
        ClientLevel level = MinecraftClientWrapper.MINECRAFT.f_91073_;
        if (level == null) {
            return null;
        }
        return ClientLevelWrapper.getWrapper(level, bypassLevelKeyManager);
    }

    @Override
    public IProfilerWrapper getProfiler() {
        if (this.profilerWrapper == null) {
            this.profilerWrapper = new ProfilerWrapper(MINECRAFT.m_91307_());
        } else if (MINECRAFT.m_91307_() != this.profilerWrapper.profiler) {
            this.profilerWrapper.profiler = MINECRAFT.m_91307_();
        }
        return this.profilerWrapper;
    }

    @Override
    public ArrayList<ILevelWrapper> getAllServerWorlds() {
        ArrayList<ILevelWrapper> worlds = new ArrayList<ILevelWrapper>();
        Iterable serverWorlds = MINECRAFT.m_91092_().m_129785_();
        for (ServerLevel world : serverWorlds) {
            worlds.add(ServerLevelWrapper.getWrapper(world));
        }
        return worlds;
    }

    @Override
    public void sendChatMessage(String string) {
        LocalPlayer player = this.getPlayer();
        if (player == null) {
            return;
        }
        player.m_213846_((Component)Component.m_237115_((String)string));
    }

    @Override
    public void crashMinecraft(String errorMessage, Throwable exception) {
        LOGGER.error("Distant Horizons had the following error: [" + errorMessage + "]. Crashing Minecraft...", exception);
        CrashReport report = new CrashReport(errorMessage, exception);
        Minecraft.m_91332_((CrashReport)report);
    }

    @Override
    public Object getOptionsObject() {
        return MinecraftClientWrapper.MINECRAFT.f_91066_;
    }

    @Override
    public boolean isDedicatedServer() {
        return false;
    }

    @Override
    public File getInstallationDirectory() {
        return MinecraftClientWrapper.MINECRAFT.f_91069_;
    }

    @Override
    public void executeOnRenderThread(Runnable runnable) {
        MINECRAFT.execute(runnable);
    }

    @Override
    public boolean isWorldNew() {
        throw new UnsupportedOperationException("Not Implemented");
    }
}

