/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesplus.block;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.block.FruitBlock;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.systems.fruit.Fruit;
import com.ferreusveritas.dynamictreesplus.block.CactusBranchBlock;
import com.ferreusveritas.dynamictreesplus.block.CactusFruitBlock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CactusFruit
extends Fruit {
    public static final TypedRegistry.EntryType<Fruit> TYPE = TypedRegistry.newType(CactusFruit::new);

    public CactusFruit(ResourceLocation registryName) {
        super(registryName);
    }

    protected FruitBlock createBlock(BlockBehaviour.Properties properties) {
        return new CactusFruitBlock(properties, this);
    }

    public void place(LevelAccessor world, BlockPos pos, @Nullable Float seasonValue) {
        BlockState state = this.getStateForAge(0);
        state = this.offsetBlockIfOnTop(world, pos, state);
        world.m_7731_(pos, state, 3);
    }

    public void placeDuringWorldGen(LevelAccessor world, BlockPos pos, @Nullable Float seasonValue) {
        BlockState state = this.getStateForAge(this.getAgeForWorldGen(world, pos, seasonValue));
        state = this.offsetBlockIfOnTop(world, pos, state);
        world.m_7731_(pos, state, 3);
    }

    private BlockState offsetBlockIfOnTop(LevelAccessor world, BlockPos pos, BlockState inState) {
        BlockState downState = world.m_8055_(pos.m_7495_());
        BranchBlock downBranch = TreeHelper.getBranch((BlockState)world.m_8055_(pos.m_7495_()));
        if (downBranch instanceof CactusBranchBlock && downState.m_61143_(CactusBranchBlock.ORIGIN) == Direction.DOWN) {
            return (BlockState)inState.m_61124_((Property)CactusFruitBlock.OFFSET, (Comparable)Boolean.valueOf(true));
        }
        return inState;
    }
}

