/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesplus.systems.mushroomlogic.shapekits;

import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictreesplus.block.mushroom.CapProperties;
import com.ferreusveritas.dynamictreesplus.block.mushroom.DynamicCapCenterBlock;
import com.ferreusveritas.dynamictreesplus.systems.mushroomlogic.MushroomShapeConfiguration;
import com.ferreusveritas.dynamictreesplus.systems.mushroomlogic.context.MushroomCapContext;
import com.ferreusveritas.dynamictreesplus.systems.mushroomlogic.shapekits.MushroomShapeKit;
import com.ferreusveritas.dynamictreesplus.tree.HugeMushroomSpecies;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class BellShape
extends MushroomShapeKit {
    public static final ConfigurationProperty<Integer> CURVE_POWER = ConfigurationProperty.integer((String)"curve_power");
    public static final ConfigurationProperty<Float> CURVE_HEIGHT_OFFSET = ConfigurationProperty.floatProperty((String)"curve_height_offset");
    public static final ConfigurationProperty<Float> MIN_AGE_CURVE_FACTOR = ConfigurationProperty.floatProperty((String)"min_age_curve_factor");
    public static final ConfigurationProperty<Float> MAX_AGE_CURVE_FACTOR = ConfigurationProperty.floatProperty((String)"max_age_curve_factor");
    public static final ConfigurationProperty<Float> CURVE_FACTOR_VARIATION = ConfigurationProperty.floatProperty((String)"curve_factor_variation");
    public static final ConfigurationProperty<Integer> POINTED_TIP_AGE = ConfigurationProperty.integer((String)"pointed_tip_max_age");

    public BellShape(ResourceLocation registryName) {
        super(registryName);
    }

    @NotNull
    public MushroomShapeConfiguration getDefaultConfiguration() {
        return (MushroomShapeConfiguration)((MushroomShapeConfiguration)((MushroomShapeConfiguration)((MushroomShapeConfiguration)((MushroomShapeConfiguration)((MushroomShapeConfiguration)((MushroomShapeConfiguration)((MushroomShapeConfiguration)((MushroomShapeConfiguration)this.defaultConfiguration).with(CHANCE_TO_AGE, Float.valueOf(0.75f))).with(MAX_CAP_AGE, 6)).with(CURVE_POWER, 3)).with(CURVE_HEIGHT_OFFSET, Float.valueOf(0.0f))).with(MIN_AGE_CURVE_FACTOR, Float.valueOf(2.0f))).with(MAX_AGE_CURVE_FACTOR, Float.valueOf(0.5f))).with(CURVE_FACTOR_VARIATION, Float.valueOf(0.1f))).with(POINTED_TIP_AGE, 0);
    }

    @Override
    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{CHANCE_TO_AGE, MAX_CAP_AGE, CURVE_POWER, CURVE_HEIGHT_OFFSET, MIN_AGE_CURVE_FACTOR, MAX_AGE_CURVE_FACTOR, CURVE_FACTOR_VARIATION, POINTED_TIP_AGE});
    }

    @Override
    public List<BlockPos> getShapeCluster(MushroomShapeConfiguration configuration, MushroomCapContext context) {
        return this.placeRing(configuration, context, ringAction.GET);
    }

    @Override
    public int getMaxCapAge(MushroomShapeConfiguration configuration) {
        return (Integer)configuration.get(MAX_CAP_AGE);
    }

    @Override
    public float getChanceToAge(MushroomShapeConfiguration configuration) {
        return ((Float)configuration.get(CHANCE_TO_AGE)).floatValue();
    }

    @Override
    public void generateMushroomCap(MushroomShapeConfiguration configuration, MushroomCapContext context) {
        this.placeRing(configuration, context, ringAction.PLACE);
    }

    @Override
    public void clearMushroomCap(MushroomShapeConfiguration configuration, MushroomCapContext context) {
        this.placeRing(configuration, context, ringAction.CLEAR);
    }

    private List<BlockPos> placeRing(MushroomShapeConfiguration configuration, MushroomCapContext context, ringAction action) {
        DynamicCapCenterBlock centerBlock = context.species().getCapProperties().getDynamicCapCenterBlock().orElse(null);
        LinkedList<BlockPos> ringPositions = new LinkedList<BlockPos>();
        if (centerBlock == null) {
            return ringPositions;
        }
        float height_offset = ((Float)configuration.get(CURVE_HEIGHT_OFFSET)).floatValue();
        int power = (Integer)configuration.get(CURVE_POWER);
        float fac = this.calculateFactor(configuration, context);
        int age = context.age();
        int y = 0;
        int radius = 1;
        for (int i = 1; i <= age; ++i) {
            boolean moveY;
            int nextY;
            int n = nextY = fac == 0.0f ? 0 : (int)Math.floor(Math.pow(fac * (float)radius, power) - (double)height_offset);
            boolean bl = i == 1 ? age <= (Integer)configuration.get(POINTED_TIP_AGE) : (moveY = nextY != y);
            if (moveY) {
                y += (int)Math.signum(fac);
            }
            BlockPos pos = context.pos().m_6625_(y);
            if (action == ringAction.CLEAR) {
                centerBlock.clearRing(context.level(), pos, radius);
            } else if (action == ringAction.PLACE) {
                if (!centerBlock.placeRing(context.level(), pos, radius, i, moveY, fac < 0.0f && i < age)) {
                    break;
                }
            } else if (action == ringAction.GET) {
                ringPositions.addAll(centerBlock.getRing(context.level(), pos, radius));
            }
            if (i < nextY) continue;
            ++radius;
        }
        ringPositions.add(context.pos());
        return ringPositions;
    }

    private float calculateFactor(MushroomShapeConfiguration configuration, MushroomCapContext context) {
        HugeMushroomSpecies species = context.species();
        CapProperties properties = species.getCapProperties();
        int age = context.age();
        if (age == 0) {
            return 0.0f;
        }
        float factorMin = ((Float)configuration.get(MIN_AGE_CURVE_FACTOR)).floatValue();
        float factorMax = ((Float)configuration.get(MAX_AGE_CURVE_FACTOR)).floatValue();
        float factorVariation = ((Float)configuration.get(CURVE_FACTOR_VARIATION)).floatValue();
        float rand = (float)CoordUtils.coordHashCode((BlockPos)new BlockPos(context.pos().m_123341_(), 0, context.pos().m_123343_()), (int)2) / 65535.0f;
        float var = rand * factorVariation * 2.0f - factorVariation;
        return (float)age / (float)properties.getMaxAge(species) * (factorMax - factorMin) + factorMin + var;
    }

    static enum ringAction {
        PLACE,
        CLEAR,
        GET;

    }
}

