/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesplus.systems.nodemapper;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.api.treedata.TreePart;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictreesplus.block.mushroom.DynamicCapCenterBlock;
import com.ferreusveritas.dynamictreesplus.tree.HugeMushroomSpecies;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import oshi.util.tuples.Pair;

public class MushroomInflatorNode
implements NodeInspector {
    private static final int minRadiusHeightDivider = 3;
    private float radius;
    private BlockPos last;
    private BlockPos highestTrunkBlock;
    private final List<Pair<BlockPos, Integer>> capAges;
    private final int generationRadius;
    private int lastCapBranchRadius;
    private final BlockPos rootPos;
    HugeMushroomSpecies species;

    public MushroomInflatorNode(HugeMushroomSpecies species, List<Pair<BlockPos, Integer>> capAges, int genRadius, BlockPos root) {
        this.species = species;
        this.last = BlockPos.f_121853_;
        this.highestTrunkBlock = null;
        this.capAges = capAges;
        this.generationRadius = genRadius;
        this.rootPos = root;
    }

    public boolean run(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
        BranchBlock branch = TreeHelper.getBranch((BlockState)state);
        if (branch != null) {
            this.radius = this.species.getFamily().getPrimaryThickness();
            if (this.highestTrunkBlock == null && !TreeHelper.isBranch((BlockState)level.m_8055_(pos.m_7494_()))) {
                this.highestTrunkBlock = pos;
            }
        }
        return false;
    }

    public boolean returnRun(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
        BranchBlock branch;
        BlockPos dist = pos.m_121996_((Vec3i)this.last);
        if (dist.m_123341_() * dist.m_123341_() + dist.m_123342_() * dist.m_123342_() + dist.m_123343_() * dist.m_123343_() != 1 && DynamicCapCenterBlock.canCapReplace(level.m_8055_(pos.m_7494_()))) {
            int height = pos.m_121996_((Vec3i)this.rootPos).m_123342_();
            int maxAge = Math.min(Math.min(Math.min(this.species.getCapProperties().getMaxAge(this.species), 8), height), this.generationRadius);
            int minAge = Math.max(0, height / 3);
            int capAge = minAge + CoordUtils.coordHashCode((BlockPos)new BlockPos(pos.m_123341_(), 0, pos.m_123343_()), (int)3) % (Math.abs(maxAge - minAge) + 1);
            this.lastCapBranchRadius = Math.min(this.species.getFamily().getPrimaryThickness() + capAge, this.species.getMaxBranchRadius());
            this.radius = this.lastCapBranchRadius;
            this.capAges.add((Pair<BlockPos, Integer>)new Pair((Object)pos.m_7494_(), (Object)capAge));
        }
        if ((branch = TreeHelper.getBranch((BlockState)state)) != null) {
            float areaAccum = this.radius * this.radius;
            boolean isTwig = true;
            for (Direction dir : Direction.values()) {
                if (dir.equals((Object)fromDir)) continue;
                BlockPos dPos = pos.m_121945_(dir);
                if (dPos.equals((Object)this.last)) {
                    isTwig = false;
                    continue;
                }
                BlockState deltaBlockState = level.m_8055_(dPos);
                TreePart treepart = TreeHelper.getTreePart((BlockState)deltaBlockState);
                if (!branch.isSameTree(treepart)) continue;
                int branchRadius = treepart.getRadius(deltaBlockState);
                areaAccum += (float)(branchRadius * branchRadius);
            }
            if (isTwig) {
                branch.setRadius(level, pos, (int)this.radius, null);
            } else {
                float secondaryThickness;
                this.radius = (float)Math.sqrt(areaAccum) + this.species.getTapering() * this.species.getWorldGenTaperingFactor();
                int maxRadius = this.species.getMaxBranchRadius();
                if (this.radius > (float)maxRadius) {
                    this.radius = maxRadius;
                }
                if (this.highestTrunkBlock != null) {
                    boolean isInTrunk;
                    int blockRadius = 8;
                    boolean bl = isInTrunk = pos.m_123341_() == this.highestTrunkBlock.m_123341_() && pos.m_123342_() <= this.highestTrunkBlock.m_123342_() && pos.m_123343_() == this.highestTrunkBlock.m_123343_();
                    if (this.radius > (float)blockRadius && !isInTrunk) {
                        this.radius = blockRadius;
                    }
                }
                if (this.radius < (secondaryThickness = (float)Math.min(this.lastCapBranchRadius + 1, this.species.getMaxBranchRadius()))) {
                    this.radius = secondaryThickness;
                }
                branch.setRadius(level, pos, (int)Math.floor(this.radius), null);
            }
            this.last = pos;
        }
        return false;
    }
}

