/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesplus.tree;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.entity.SpeciesBlockEntity;
import com.ferreusveritas.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.block.rooty.RootyBlock;
import com.ferreusveritas.dynamictrees.block.rooty.SoilHelper;
import com.ferreusveritas.dynamictrees.cell.LeafClusters;
import com.ferreusveritas.dynamictrees.data.DTBlockTags;
import com.ferreusveritas.dynamictrees.data.DTItemTags;
import com.ferreusveritas.dynamictrees.event.SpeciesPostGenerationEvent;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.resources.Resources;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostRotContext;
import com.ferreusveritas.dynamictrees.systems.nodemapper.CollectorNode;
import com.ferreusveritas.dynamictrees.systems.nodemapper.FindEndsNode;
import com.ferreusveritas.dynamictrees.systems.nodemapper.NetVolumeNode;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.BlockStates;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import com.ferreusveritas.dynamictrees.util.CommonVoxelShapes;
import com.ferreusveritas.dynamictrees.util.Optionals;
import com.ferreusveritas.dynamictrees.util.ResourceLocationUtils;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import com.ferreusveritas.dynamictrees.worldgen.GenerationContext;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import com.ferreusveritas.dynamictreesplus.block.mushroom.CapProperties;
import com.ferreusveritas.dynamictreesplus.block.mushroom.DynamicCapBlock;
import com.ferreusveritas.dynamictreesplus.block.mushroom.DynamicCapCenterBlock;
import com.ferreusveritas.dynamictreesplus.init.DTPRegistries;
import com.ferreusveritas.dynamictreesplus.systems.mushroomlogic.MushroomShapeConfiguration;
import com.ferreusveritas.dynamictreesplus.systems.mushroomlogic.context.MushroomCapContext;
import com.ferreusveritas.dynamictreesplus.systems.nodemapper.MushroomInflatorNode;
import com.ferreusveritas.dynamictreesplus.tree.HugeMushroomFamily;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function3;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.eventbus.api.Event;
import oshi.util.tuples.Pair;

public class HugeMushroomSpecies
extends Species {
    public static final TypedRegistry.EntryType<Species> TYPE = HugeMushroomSpecies.createDefaultMushroomType((Function3<ResourceLocation, Family, CapProperties, Species>)((Function3)HugeMushroomSpecies::new));
    protected CapProperties capProperties = CapProperties.NULL;
    protected MushroomShapeConfiguration mushroomShapeKit;
    protected boolean acceptAnySoil = true;
    protected int maxLightForPlanting = 12;

    public static TypedRegistry.EntryType<Species> createDefaultMushroomType(Function3<ResourceLocation, Family, CapProperties, Species> constructor) {
        return TypedRegistry.newType(HugeMushroomSpecies.createDefaultMushroomCodec(constructor));
    }

    public static Codec<Species> createDefaultMushroomCodec(Function3<ResourceLocation, Family, CapProperties, Species> constructor) {
        return RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf(Resources.RESOURCE_LOCATION.toString()).forGetter(RegistryEntry::getRegistryName), (App)Family.REGISTRY.getGetterCodec().fieldOf("family").forGetter(Species::getFamily), (App)CapProperties.REGISTRY.getGetterCodec().optionalFieldOf("cap_properties", (Object)CapProperties.NULL).forGetter(species -> species instanceof HugeMushroomSpecies ? ((HugeMushroomSpecies)((Object)((Object)species))).getCapProperties() : CapProperties.NULL)).apply((Applicative)instance, constructor));
    }

    public HugeMushroomSpecies(ResourceLocation name, Family family, CapProperties capProperties) {
        this(name, family, MushroomShapeConfiguration.getDefault(), capProperties);
    }

    public HugeMushroomSpecies(ResourceLocation name, Family family, MushroomShapeConfiguration shapeKit, CapProperties capProperties) {
        super(name, family, LeavesProperties.NULL);
        this.setCapProperties(capProperties.isValid() ? capProperties : (family instanceof HugeMushroomFamily ? ((HugeMushroomFamily)family).getCommonCap() : CapProperties.NULL));
        this.mushroomShapeKit = shapeKit;
    }

    public Species setPreReloadDefaults() {
        this.setTransformable(false);
        return this.setSaplingShape(CommonVoxelShapes.ROUND_MUSHROOM).setDefaultGrowingParameters().envFactor(Tags.Biomes.IS_DRY, 0.25f).envFactor(Tags.Biomes.IS_HOT, 0.75f).envFactor(Tags.Biomes.IS_COLD, 1.05f).setCanSaplingGrowNaturally(false).setGrowthLogicKit((GrowthLogicKit)DTPRegistries.STRAIGHT_LOGIC);
    }

    public void setAcceptAnySoil(boolean acceptAnySoil) {
        this.acceptAnySoil = acceptAnySoil;
    }

    public void setMaxLightForPlanting(int maxLightForPlanting) {
        this.maxLightForPlanting = maxLightForPlanting;
    }

    public int getMaxLightForPlanting() {
        return this.maxLightForPlanting;
    }

    protected boolean transitionToTree(Level level, BlockPos pos, Family family) {
        family.getBranch().ifPresent(branch -> branch.setRadius((LevelAccessor)level, pos, family.getPrimaryThickness(), null));
        level.m_46597_(pos.m_7494_(), this.getCapProperties().getDynamicCapState(true, 0));
        this.placeRootyDirtBlock((LevelAccessor)level, pos.m_7495_(), 15);
        if (this.doesRequireTileEntity((LevelAccessor)level, pos)) {
            SpeciesBlockEntity speciesBlockEntity = (SpeciesBlockEntity)DTRegistries.SPECIES_BLOCK_ENTITY.m_155264_(pos.m_7495_(), level.m_8055_(pos.m_7495_()));
            assert (speciesBlockEntity != null);
            level.m_151523_((BlockEntity)speciesBlockEntity);
            speciesBlockEntity.setSpecies((Species)this);
        }
        return true;
    }

    public Species.LogsAndSticks getLogsAndSticks(NetVolumeNode.Volume volume, boolean silkTouch, int fortuneLevel) {
        if (silkTouch) {
            return super.getLogsAndSticks(volume, true, fortuneLevel);
        }
        return new Species.LogsAndSticks(new LinkedList(), 0);
    }

    public Species setCapProperties(CapProperties capProperties) {
        this.capProperties = capProperties;
        capProperties.setFamily(this.getFamily());
        return this;
    }

    public CapProperties getCapProperties() {
        return this.capProperties;
    }

    public MushroomShapeConfiguration getMushroomShapeKit() {
        return this.mushroomShapeKit;
    }

    public void setMushroomShapeConfiguration(MushroomShapeConfiguration mushroomShapeKit) {
        this.mushroomShapeKit = mushroomShapeKit;
    }

    public Optional<DynamicCapCenterBlock> getCapCenterBlock() {
        return this.capProperties.getDynamicCapCenterBlock();
    }

    public Optional<DynamicCapBlock> getCapBlock() {
        return this.capProperties.getDynamicCapBlock();
    }

    public Optional<Block> getPrimitiveCap() {
        return Optionals.ofBlock((Block)this.capProperties.getPrimitiveCap().m_60734_());
    }

    public List<TagKey<Block>> defaultSaplingTags() {
        return Collections.singletonList(DTBlockTags.FUNGUS_CAPS);
    }

    public List<TagKey<Item>> defaultSeedTags() {
        return Collections.singletonList(DTItemTags.FUNGUS_CAPS);
    }

    public ResourceLocation getSaplingSmartModelLocation() {
        return DynamicTrees.location((String)("block/smartmodel/mushroom_" + (this.getSaplingShape() == CommonVoxelShapes.FLAT_MUSHROOM ? "flat" : "round")));
    }

    public boolean isAcceptableSoil(LevelReader level, BlockPos pos, BlockState soilBlockState) {
        return (SoilHelper.isSoilAcceptable((BlockState)soilBlockState, (int)this.soilTypeFlags) || level.m_45524_(pos.m_7494_(), 0) <= this.getMaxLightForPlanting()) && super.isAcceptableSoil(level, pos, soilBlockState);
    }

    public boolean isAcceptableSoil(BlockState soilBlockState) {
        if (this.acceptAnySoil) {
            Block soilBlock = soilBlockState.m_60734_();
            return (soilBlock instanceof RootyBlock || SoilHelper.isSoilRegistered((Block)soilBlock)) && !this.isWater(soilBlockState);
        }
        return super.isAcceptableSoil(soilBlockState);
    }

    public boolean isAcceptableSoilForWorldgen(LevelAccessor level, BlockPos pos, BlockState soilBlockState) {
        if (this.acceptAnySoil) {
            Block soilBlock = soilBlockState.m_60734_();
            return (soilBlock instanceof RootyBlock || SoilHelper.isSoilRegistered((Block)soilBlock)) && !this.isWater(soilBlockState);
        }
        return super.isAcceptableSoilForWorldgen(level, pos, soilBlockState);
    }

    public void addSaplingTextures(BiConsumer<String, ResourceLocation> textureConsumer, ResourceLocation leavesTextureLocation, ResourceLocation barkTextureLocation) {
        ResourceLocation capLocation = ResourceLocationUtils.surround((ResourceLocation)this.getRegistryName(), (String)"block/", (String)"_cap");
        textureConsumer.accept("stem", barkTextureLocation);
        textureConsumer.accept("cap", capLocation);
    }

    public float getChanceToAge() {
        return this.mushroomShapeKit.getChanceToAge();
    }

    public boolean leavesAreSolid() {
        return true;
    }

    public boolean canEncodeLeavesBlocks(BlockPos pos, BlockState state, Block block, BranchDestructionData data) {
        return this.capProperties.isPartOfCap(state);
    }

    public int encodeLeavesPos(BlockPos pos, BlockState state, Block block, BranchDestructionData data) {
        return (state.m_60734_() instanceof DynamicCapCenterBlock ? 0 : (Integer)state.m_61143_((Property)DynamicCapBlock.DISTANCE) << 24) | BranchDestructionData.encodeRelBlockPos((BlockPos)pos);
    }

    public int encodeLeavesBlocks(BlockPos pos, BlockState state, Block block, BranchDestructionData data) {
        if (block instanceof DynamicCapBlock) {
            boolean[] dirValues = DynamicCapBlock.getDirectionValues(state);
            int code = 0;
            for (int i = 0; i < 6; ++i) {
                if (!dirValues[i]) continue;
                code |= 1 << i + 1;
            }
            return code;
        }
        if (block instanceof DynamicCapCenterBlock) {
            int age = (Integer)state.m_61143_((Property)DynamicCapCenterBlock.AGE);
            int code = 1;
            return code |= age << 1;
        }
        return 0;
    }

    @Nullable
    public HashMap<BlockPos, BlockState> getFellingLeavesClusters(BranchDestructionData destructionData) {
        HashMap<BlockPos, BlockState> map = new HashMap<BlockPos, BlockState>();
        for (int j = 0; j < destructionData.getNumLeaves(); ++j) {
            int posCoded = destructionData.destroyedLeaves[j];
            int blockCoded = destructionData.destroyedLeavesBlockIndex[j];
            boolean isCenter = (blockCoded & 1) == 1;
            BlockState state = this.capProperties.getDynamicCapState(isCenter);
            if (isCenter) {
                int age = blockCoded >> 1;
                state = (BlockState)state.m_61124_((Property)DynamicCapCenterBlock.AGE, (Comparable)Integer.valueOf(age));
            } else {
                boolean[] sides = new boolean[6];
                for (int i = 0; i < 6; ++i) {
                    sides[i] = (blockCoded >> i + 1 & 1) == 1;
                }
                state = DynamicCapBlock.setDirectionValues(state, sides);
            }
            BlockPos pos = BranchDestructionData.decodeRelPos((int)posCoded);
            map.put(pos, state);
        }
        return map;
    }

    public MushroomInflatorNode getNodeInflator(List<Pair<BlockPos, Integer>> capAges, int radius, BlockPos rootPos) {
        return new MushroomInflatorNode(this, capAges, radius, rootPos);
    }

    public JoCode getJoCode(String joCodeString) {
        return new JoCode(joCodeString){

            public void generate(GenerationContext context) {
                LevelAccessor level = context.level();
                Species species = context.species();
                if (!(species instanceof HugeMushroomSpecies)) {
                    return;
                }
                HugeMushroomSpecies species2 = (HugeMushroomSpecies)species;
                int radius = context.radius();
                boolean worldGen = context.safeBounds() != SafeChunkBounds.ANY;
                this.setFacing(context.facing());
                BlockPos rootPos = species2.preGeneration(level, context.rootPos(), radius, context.facing(), context.safeBounds(), this);
                if (rootPos == BlockPos.f_121853_) {
                    return;
                }
                BlockState initialDirtState = level.m_8055_(rootPos);
                species2.placeRootyDirtBlock(level, rootPos, 0);
                this.generateFork(level, species2, 0, rootPos, false);
                BlockPos treePos = rootPos.m_7494_();
                BlockState treeState = level.m_8055_(treePos);
                BranchBlock firstBranch = TreeHelper.getBranch((BlockState)treeState);
                if (firstBranch == null) {
                    level.m_7731_(rootPos, initialDirtState, this.careful ? 3 : 2);
                    return;
                }
                LinkedList<Pair<BlockPos, Integer>> capAges = new LinkedList<Pair<BlockPos, Integer>>();
                MushroomInflatorNode inflator = species2.getNodeInflator(capAges, radius, rootPos);
                FindEndsNode endFinder = new FindEndsNode();
                MapSignal signal = new MapSignal(new NodeInspector[]{inflator, endFinder});
                signal.destroyLoopedNodes = this.careful;
                firstBranch.analyse(treeState, level, treePos, Direction.DOWN, signal);
                if (signal.foundRoot || signal.overflow) {
                    this.tryGenerateAgain(context, worldGen, treePos, treeState, endFinder);
                    return;
                }
                List endPoints = endFinder.getEnds();
                this.generateMushroomCap(context, species2, capAges);
                if (species2.handleRot(level, endPoints, rootPos, treePos, 0, context.safeBounds())) {
                    return;
                }
                species2.postGeneration(new PostGenerationContext(context, endPoints, initialDirtState));
                MinecraftForge.EVENT_BUS.post((Event)new SpeciesPostGenerationEvent(level, (Species)species2, rootPos, endPoints, context.safeBounds(), initialDirtState));
            }

            private void generateMushroomCap(GenerationContext context, HugeMushroomSpecies species, List<Pair<BlockPos, Integer>> capAges) {
                LevelAccessor level = context.level();
                for (Pair<BlockPos, Integer> posAge : capAges) {
                    int age = Math.min((Integer)posAge.getB(), species.getMushroomShapeKit().getMaxCapAge());
                    BlockPos centerPos = (BlockPos)posAge.getA();
                    level.m_7731_(centerPos, HugeMushroomSpecies.this.capProperties.getDynamicCapState(true, age), 2);
                    species.getMushroomShapeKit().generateMushroomCap(new MushroomCapContext(level, centerPos, species, age));
                }
            }

            protected void cleanupFrankentree(LevelAccessor level, BlockPos treePos, BlockState treeState, List<BlockPos> endPoints, SafeChunkBounds safeBounds) {
                HashSet blocksToDestroy = new HashSet();
                BranchBlock branch = TreeHelper.getBranch((BlockState)treeState);
                MapSignal signal = new MapSignal(new NodeInspector[]{new CollectorNode(blocksToDestroy)});
                signal.destroyLoopedNodes = false;
                signal.trackVisited = true;
                assert (branch != null);
                branch.analyse(treeState, level, treePos, null, signal);
                BranchBlock.destroyMode = DynamicTrees.DestroyMode.IGNORE;
                for (BlockPos pos : blocksToDestroy) {
                    BlockState branchState;
                    Optional branchBlock;
                    if (!safeBounds.inBounds(pos, false) || (branchBlock = TreeHelper.getBranchOpt((BlockState)(branchState = level.m_8055_(pos)))).isEmpty()) continue;
                    int radius = ((BranchBlock)branchBlock.get()).getRadius(branchState);
                    Family family = ((BranchBlock)branchBlock.get()).getFamily();
                    Species species = family.getCommonSpecies();
                    if (family.getPrimaryThickness() == radius) {
                        species.getLeavesProperties().ifValid(leavesProperties -> {
                            SimpleVoxmap leafCluster = leavesProperties.getCellKit().getLeafCluster();
                            if (leafCluster != LeafClusters.NULL_MAP) {
                                for (SimpleVoxmap.Cell cell : leafCluster.getAllNonZeroCells()) {
                                    BlockState leavesState;
                                    BlockPos delPos = pos.m_121955_((Vec3i)cell.getPos());
                                    if (!safeBounds.inBounds(delPos, false) || !TreeHelper.isLeaves((BlockState)(leavesState = level.m_8055_(delPos)))) continue;
                                    DynamicLeavesBlock leavesBlock = (DynamicLeavesBlock)leavesState.m_60734_();
                                    if (leavesProperties.getFamily() != leavesBlock.getProperties(leavesState).getFamily()) continue;
                                    level.m_7731_(delPos, BlockStates.AIR, 2);
                                }
                            }
                        });
                    }
                    level.m_7731_(pos, BlockStates.AIR, 2);
                }
                BranchBlock.destroyMode = DynamicTrees.DestroyMode.HARVEST;
            }
        };
    }

    public boolean rot(LevelAccessor level, BlockPos pos, int neighborCount, int radius, int fertility, Random random, boolean rapid, boolean growLeaves) {
        if (rapid || (Integer)DTConfigs.MAX_BRANCH_ROT_RADIUS.get() != 0 && radius <= (Integer)DTConfigs.MAX_BRANCH_ROT_RADIUS.get()) {
            BranchBlock branch = TreeHelper.getBranch((BlockState)level.m_8055_(pos));
            if (branch != null) {
                branch.rot(level, pos);
            }
            this.postRot(new PostRotContext(level, pos, (Species)this, radius, neighborCount, fertility, rapid));
            return true;
        }
        return false;
    }

    public SoundEvent getFallingTreeStartSound(float treeVolume, boolean hasLeaves) {
        return (SoundEvent)DTRegistries.FALLING_TREE_FUNGUS_START.get();
    }

    public SoundEvent getFallingTreeEndSound(float treeVolume, boolean hasLeaves) {
        return (SoundEvent)DTRegistries.FALLING_TREE_FUNGUS_END.get();
    }

    public SoundEvent getFallingBranchEndSound(float treeVolume, boolean hasLeaves, boolean fellOnWater) {
        return hasLeaves ? (SoundEvent)DTRegistries.FALLING_TREE_FUNGUS_SMALL_END.get() : (SoundEvent)DTRegistries.FALLING_TREE_SMALL_END_BARE.get();
    }

    public float getFallingTreePitch(float treeVolume) {
        return 2.0f / (1.0f + treeVolume * 0.1f);
    }
}

