/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.data;

import com.ferreusveritas.dynamictrees.data.provider.DTDataProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.data.DataProvider;

public interface Generator<P extends DataProvider & DTDataProvider, I> {
    default public void generate(P provider, I input) {
        Dependencies dependencies = this.gatherDependencies(input);
        if (this.verifyInput(input) && this.verifyDependencies(dependencies)) {
            this.generate(provider, input, dependencies);
        }
    }

    public void generate(P var1, I var2, Dependencies var3);

    public Dependencies gatherDependencies(I var1);

    default public boolean verifyInput(I input) {
        return true;
    }

    default public boolean verifyDependencies(Dependencies dependencies) {
        return dependencies.allRequiredPresent();
    }

    public static class Dependencies {
        private final Map<DependencyKey<?>, Optional<?>> dependencies = new HashMap();

        public <T> Dependencies appendValue(DependencyKey<T> key, @Nullable T value) {
            return this.append(key, Optional.ofNullable(value));
        }

        public <T> Dependencies append(DependencyKey<T> key, Optional<T> optional) {
            this.dependencies.put(key, optional);
            return this;
        }

        public <T> T get(DependencyKey<T> key) {
            if (key.isOptional()) {
                throw new IllegalArgumentException("Tried to get plain value for optional dependency with key \"" + key.getName() + "\".");
            }
            return this.getOptional(key).get();
        }

        public <T> Optional<T> getOptional(DependencyKey<T> key) {
            Optional<?> optional = this.dependencies.get(key);
            if (optional == null) {
                throw new IllegalStateException("Tried to obtain absent dependency from key \"" + key.getName() + "\"");
            }
            return optional;
        }

        public boolean allRequiredPresent() {
            return this.dependencies.entrySet().stream().filter(entry -> !((DependencyKey)entry.getKey()).isOptional()).map(Map.Entry::getValue).allMatch(Optional::isPresent);
        }
    }

    public static class DependencyKey<T> {
        private final String name;
        private final boolean optional;

        public DependencyKey(String name) {
            this(name, false);
        }

        public DependencyKey(String name, boolean optional) {
            this.name = name;
            this.optional = optional;
        }

        public String getName() {
            return this.name;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            DependencyKey that = (DependencyKey)other;
            return this.optional == that.optional && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.optional);
        }
    }
}

