/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.resource.loading;

import com.ferreusveritas.dynamictrees.api.applier.ApplierRegistryEvent;
import com.ferreusveritas.dynamictrees.api.resource.loading.AbstractResourceLoader;
import com.ferreusveritas.dynamictrees.api.resource.loading.ApplierResourceLoader;
import com.ferreusveritas.dynamictrees.api.resource.loading.preparation.ResourcePreparer;
import com.ferreusveritas.dynamictrees.deserialisation.PropertyAppliers;
import java.util.function.Function;

public abstract class StagedApplierResourceLoader<I, R>
extends AbstractResourceLoader<I>
implements ApplierResourceLoader<I> {
    protected final PropertyAppliers<R, I> loadAppliers;
    protected final PropertyAppliers<R, I> gatherDataAppliers;
    protected final PropertyAppliers<R, I> setupAppliers;
    protected final PropertyAppliers<R, I> reloadAppliers;
    protected final PropertyAppliers<R, I> commonAppliers;
    protected final String appliersIdentifier;

    public StagedApplierResourceLoader(ResourcePreparer<I> resourcePreparer, Class<R> resourceType, Function<Class<R>, PropertyAppliers<R, I>> appliersConstructor, String appliersIdentifier) {
        super(resourcePreparer);
        this.loadAppliers = appliersConstructor.apply(resourceType);
        this.gatherDataAppliers = appliersConstructor.apply(resourceType);
        this.setupAppliers = appliersConstructor.apply(resourceType);
        this.reloadAppliers = appliersConstructor.apply(resourceType);
        this.commonAppliers = appliersConstructor.apply(resourceType);
        this.appliersIdentifier = appliersIdentifier;
    }

    @Override
    public void registerAppliers() {
        ApplierResourceLoader.postApplierEvent(new ApplierRegistryEvent.Load<R, I>(this.loadAppliers, this.appliersIdentifier));
        ApplierResourceLoader.postApplierEvent(new ApplierRegistryEvent.GatherData<R, I>(this.gatherDataAppliers, this.appliersIdentifier));
        ApplierResourceLoader.postApplierEvent(new ApplierRegistryEvent.Setup<R, I>(this.setupAppliers, this.appliersIdentifier));
        ApplierResourceLoader.postApplierEvent(new ApplierRegistryEvent.Reload<R, I>(this.reloadAppliers, this.appliersIdentifier));
        ApplierResourceLoader.postApplierEvent(new ApplierRegistryEvent.Common<R, I>(this.commonAppliers, this.appliersIdentifier));
    }
}

