/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.worldgen;

import com.ferreusveritas.dynamictrees.worldgen.OverworldGroundFinder;
import com.ferreusveritas.dynamictrees.worldgen.SubterraneanGroundFinder;
import com.ferreusveritas.dynamictrees.worldgen.SurfaceGroundFinder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;

@FunctionalInterface
public interface GroundFinder {
    public static final GroundFinder OVERWORLD = new OverworldGroundFinder();
    public static final GroundFinder SURFACE = new SurfaceGroundFinder();
    public static final GroundFinder SUBTERRANEAN = new SubterraneanGroundFinder();
    public static final Map<ResourceKey<Level>, GroundFinder> GROUND_FINDERS = new HashMap<ResourceKey<Level>, GroundFinder>();

    public List<BlockPos> findGround(LevelAccessor var1, BlockPos var2, @Nullable Heightmap.Types var3);

    public static void registerGroundFinder(ResourceKey<Level> dimension, GroundFinder groundFinder) {
        GROUND_FINDERS.put(dimension, groundFinder);
    }

    public static GroundFinder getGroundFinder(Level level) {
        return GROUND_FINDERS.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), k -> level.m_6042_().f_63856_() ? SUBTERRANEAN : OVERWORLD);
    }
}

