/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.block;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;

public class DynamicSaplingBlock
extends Block
implements BonemealableBlock,
IPlantable {
    protected Species species;

    public DynamicSaplingBlock(Species species) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60910_().m_278166_(PushReaction.DESTROY).m_60966_().m_60918_(SoundType.f_56740_).m_60977_().m_60955_());
        this.species = species;
    }

    public Species getSpecies() {
        return this.species;
    }

    public boolean m_7370_(@Nonnull LevelReader level, @Nonnull BlockPos pos, @Nonnull BlockState state, boolean isClient) {
        return this.getSpecies().canSaplingConsumeBoneMeal(level, pos);
    }

    public boolean m_214167_(@Nonnull Level level, @Nonnull RandomSource rand, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        return this.getSpecies().canSaplingGrowAfterBoneMeal(level, rand, pos);
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return this.getSpecies().saplingFireSpread();
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return this.getSpecies().saplingFlammability();
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (this.getSpecies().canSaplingGrowNaturally((Level)level, pos)) {
            this.m_214148_(level, rand, pos, state);
        }
    }

    public static boolean canSaplingStay(LevelReader level, Species species, BlockPos pos) {
        for (Direction dir : CoordUtils.HORIZONTALS) {
            BlockState blockState = level.m_8055_(pos.m_121945_(dir));
            Block block = blockState.m_60734_();
            if (!TreeHelper.isBranch(block) && !(block instanceof DynamicSaplingBlock)) continue;
            return false;
        }
        return level.m_46859_(pos.m_7494_()) && species.isAcceptableSoil(level, pos.m_7495_(), level.m_8055_(pos.m_7495_()));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return DynamicSaplingBlock.canSaplingStay(level, this.getSpecies(), pos);
    }

    public void m_214148_(@Nonnull ServerLevel level, @Nonnull RandomSource rand, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        if (this.m_7898_(state, (LevelReader)level, pos)) {
            Species species = this.getSpecies().selfOrLocationOverride((BlockGetter)level, pos);
            if (species.canSaplingGrow((LevelReader)level, pos)) {
                species.transitionToTree((Level)level, pos);
            }
        } else {
            this.dropBlock((Level)level, state, pos);
        }
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return this.getSpecies().getSaplingSound();
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            this.dropBlock(level, state, pos);
        }
    }

    protected void dropBlock(Level level, BlockState state, BlockPos pos) {
        level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, this.getSpecies().getSeedStack(1)));
        level.m_7471_(pos, false);
    }

    @Nonnull
    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return this.getSpecies().getSeedStack(1);
    }

    @Nonnull
    public List<ItemStack> m_49635_(@Nonnull BlockState state, @Nonnull LootParams.Builder builder) {
        if (builder.m_287258_().m_7654_().m_278653_().m_278789_(LootDataType.f_278413_, this.m_60589_()) != null) {
            return super.m_49635_(state, builder);
        }
        return (Boolean)DTConfigs.DYNAMIC_SAPLING_DROPS.get() != false ? Collections.singletonList(this.getSpecies().getSeedStack(1)) : Collections.emptyList();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return this.getSpecies().getSeedStack(1);
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getSpecies().getSaplingShape();
    }

    public BlockState getPlant(BlockGetter level, BlockPos pos) {
        return this.m_49966_();
    }
}

