/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.block;

import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;

public interface GrowableBlock {
    public void performMatureAction(LevelAccessor var1, BlockPos var2, BlockState var3);

    default public void drop(LevelAccessor level, BlockPos pos, BlockState state) {
        level.m_46961_(pos, true);
    }

    default public void rot(LevelAccessor level, BlockPos pos, BlockState state) {
        level.m_46961_(pos, false);
    }

    public boolean isSupported(LevelReader var1, BlockPos var2, BlockState var3);

    public static enum MatureAction {
        DEFAULT((block, info) -> block.performMatureAction(info.level, info.pos, info.state)),
        DROP((block, info) -> block.drop(info.level, info.pos, info.state)),
        ROT((block, info) -> block.rot(info.level, info.pos, info.state));

        private final BiConsumer<GrowableBlock, Info> action;

        private MatureAction(BiConsumer<GrowableBlock, Info> action) {
            this.action = action;
        }

        public void perform(GrowableBlock block, Info blockInfo) {
            this.action.accept(block, blockInfo);
        }
    }

    public static class Info {
        private final LevelAccessor level;
        private final BlockPos pos;
        private final BlockState state;

        public Info(LevelAccessor level, BlockPos pos, BlockState state) {
            this.level = level;
            this.pos = pos;
            this.state = state;
        }
    }
}

