/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.block.branch;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.cell.Cell;
import com.ferreusveritas.dynamictrees.api.cell.CellNull;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.TreePart;
import com.ferreusveritas.dynamictrees.block.OffsetablePodBlock;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.branch.TrunkShellBlock;
import com.ferreusveritas.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.cell.MetadataCell;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionSelectionContext;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BasicBranchBlock
extends BranchBlock
implements SimpleWaterloggedBlock {
    protected static final IntegerProperty RADIUS = IntegerProperty.m_61631_((String)"radius", (int)1, (int)8);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected final BlockState[] branchStates;
    private int flammability = 5;
    private int fireSpreadSpeed = 5;
    private final int maxRadiusForWaterLogging = 7;

    public BasicBranchBlock(ResourceLocation name, MapColor mapColor) {
        this(name, BlockBehaviour.Properties.m_284310_().m_284180_(mapColor), RADIUS, 8);
    }

    public BasicBranchBlock(ResourceLocation name, BlockBehaviour.Properties properties) {
        this(name, properties, RADIUS, 8);
    }

    public BasicBranchBlock(ResourceLocation name, BlockBehaviour.Properties properties, IntegerProperty radiusProperty, int maxRadius) {
        super(name, properties);
        this.branchStates = this.createBranchStates(radiusProperty, maxRadius);
    }

    public BlockState[] createBranchStates(IntegerProperty radiusProperty, int maxRadius) {
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)radiusProperty, (Comparable)Integer.valueOf(1))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        BlockState[] branchStates = new BlockState[maxRadius + 1];
        branchStates[0] = Blocks.f_50016_.m_49966_();
        for (int radius = 1; radius <= maxRadius; ++radius) {
            branchStates[radius] = (BlockState)this.m_49966_().m_61124_((Property)radiusProperty, (Comparable)Integer.valueOf(radius));
        }
        return branchStates;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{RADIUS}).m_61104_(new Property[]{WATERLOGGED});
    }

    @Override
    public int branchSupport(BlockState state, BlockGetter level, BranchBlock branch, BlockPos pos, Direction dir, int radius) {
        return this.isSameTree(branch) ? BasicBranchBlock.setSupport(1, 1) : 0;
    }

    @Override
    public boolean canFall() {
        return true;
    }

    @Override
    public boolean checkForRot(LevelAccessor level, BlockPos pos, Species species, int fertility, int radius, RandomSource rand, float chance, boolean rapid) {
        if (!rapid && (chance == 0.0f || rand.m_188501_() > chance)) {
            return false;
        }
        int neigh = 0;
        for (Direction dir : Direction.values()) {
            BlockPos deltaPos = pos.m_121945_(dir);
            BlockState deltaBlockState = level.m_8055_(deltaPos);
            if (BasicBranchBlock.getBranchSupport(neigh += TreeHelper.getTreePart(deltaBlockState).branchSupport(deltaBlockState, (BlockGetter)level, this, deltaPos, dir, radius)) < 1 || BasicBranchBlock.getLeavesSupport(neigh) < 2) continue;
            return false;
        }
        boolean didRot = species.rot(level, pos, neigh & 0xF, radius, fertility, rand, rapid, fertility > 0);
        if (rapid && didRot) {
            for (Direction dir : Direction.values()) {
                BlockPos neighPos = pos.m_121945_(dir);
                BlockState neighState = level.m_8055_(neighPos);
                if (neighState.m_60734_() != this) continue;
                this.checkForRot(level, neighPos, species, fertility, this.getRadius(neighState), rand, 1.0f, true);
            }
        }
        return didRot;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_6044_(BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        if (this.getRadius(state) > 7) {
            return false;
        }
        return super.m_6044_(level, pos, state, fluid);
    }

    @Override
    public float getHardness(BlockState state, BlockGetter level, BlockPos pos) {
        int radius = this.getRadius(level.m_8055_(pos));
        float hardness = this.getFamily().getPrimitiveLog().orElse(Blocks.f_50016_).m_49966_().m_60800_(level, pos) * (float)(radius * radius) / 64.0f * 8.0f;
        return (float)Math.min((double)hardness, (Double)DTConfigs.MAX_TREE_HARDNESS.get());
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        int radius = this.getRadius(level.m_8055_(pos));
        return this.fireSpreadSpeed * radius / 8;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return this.flammability;
    }

    public BasicBranchBlock setFlammability(int flammability) {
        this.flammability = flammability;
        return this;
    }

    public BasicBranchBlock setFireSpreadSpeed(int fireSpreadSpeed) {
        this.fireSpreadSpeed = fireSpreadSpeed;
        return this;
    }

    @Override
    public Cell getHydrationCell(BlockGetter level, BlockPos pos, BlockState state, Direction dir, LeavesProperties leavesProperties) {
        Family thisTree = this.getFamily();
        if (leavesProperties.getFamily() == thisTree) {
            int radiusAndMeta = thisTree.getRadiusForCellKit(level, pos, state, dir, this);
            int radius = MetadataCell.getRadius(radiusAndMeta);
            int metadata = MetadataCell.getMeta(radiusAndMeta);
            return leavesProperties.getCellKit().getCellForBranch(radius, metadata);
        }
        return CellNull.NULL_CELL;
    }

    @Override
    public int getRadius(BlockState state) {
        return this.isSameTree(state) ? (Integer)state.m_61143_((Property)RADIUS) : 0;
    }

    @Override
    public int setRadius(LevelAccessor level, BlockPos pos, int radius, @Nullable Direction originDir, int flags) {
        destroyMode = DynamicTrees.DestroyMode.SET_RADIUS;
        boolean replacingWater = level.m_8055_(pos).m_60819_() == Fluids.f_76193_.m_76068_(false);
        boolean setWaterlogged = replacingWater && radius <= 7;
        level.m_7731_(pos, (BlockState)this.getStateForRadius(radius).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(setWaterlogged)), flags);
        destroyMode = DynamicTrees.DestroyMode.SLOPPY;
        return radius;
    }

    @Override
    public BlockState getStateForRadius(int radius) {
        return this.branchStates[Mth.m_14045_((int)radius, (int)1, (int)this.getMaxRadius())];
    }

    @Override
    public int probabilityForBlock(BlockState state, BlockGetter level, BlockPos pos, BranchBlock from) {
        return this.isSameTree(from) ? this.getRadius(state) + 2 : 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GrowSignal growIntoAir(Level level, BlockPos pos, GrowSignal signal, int fromRadius) {
        Species species = signal.getSpecies();
        DynamicLeavesBlock leaves = species.getLeavesBlock().orElse(null);
        if (leaves != null) {
            if (fromRadius != this.getFamily().getPrimaryThickness()) return leaves.branchOut(level, pos, signal);
            signal.success = leaves.growLeavesIfLocationIsSuitable((LevelAccessor)level, species.getLeavesProperties(), pos, 0);
            return signal;
        } else {
            if (BasicBranchBlock.isNextToBranch(level, pos, signal.dir.m_122424_())) {
                signal.success = false;
                return signal;
            }
            this.setRadius((LevelAccessor)level, pos, this.getFamily().getPrimaryThickness(), null);
            signal.radius = this.getFamily().getSecondaryThickness();
            signal.success = true;
        }
        return signal;
    }

    @Override
    public GrowSignal growSignal(Level level, BlockPos pos, GrowSignal signal) {
        if (!signal.step()) {
            return signal;
        }
        BlockState currBlockState = level.m_8055_(pos);
        Species species = signal.getSpecies();
        boolean inTrunk = signal.isInTrunk();
        Direction originDir = signal.dir.m_122424_();
        Direction targetDir = species.getGrowthLogicKit().selectNewDirection(new DirectionSelectionContext(level, pos, species, this, signal));
        signal.doTurn(targetDir);
        BlockPos deltaPos = pos.m_121945_(targetDir);
        BlockState deltaState = level.m_8055_(deltaPos);
        Direction[] treepart = TreeHelper.getTreePart(deltaState);
        if (treepart != TreeHelper.NULL_TREE_PART) {
            signal = treepart.growSignal(level, deltaPos, signal);
        } else if (level.m_46859_(deltaPos) || deltaState.m_60734_() instanceof TrunkShellBlock) {
            signal = this.growIntoAir(level, deltaPos, signal, this.getRadius(currBlockState));
        }
        float areaAccum = signal.radius * signal.radius;
        boolean theresPods = false;
        for (Direction dir : Direction.values()) {
            if (dir.equals((Object)originDir) || dir.equals((Object)targetDir)) continue;
            BlockPos deltaPos2 = pos.m_121945_(dir);
            BlockState blockState = level.m_8055_(deltaPos2);
            TreePart treepart2 = TreeHelper.getTreePart(blockState);
            if (this.isSameTree(treepart2)) {
                int branchRadius = treepart2.getRadius(blockState);
                areaAccum += (float)(branchRadius * branchRadius);
            }
            if (!(blockState.m_60734_() instanceof OffsetablePodBlock)) continue;
            theresPods = true;
        }
        if (!signal.choked) {
            int flags;
            int maxRadius = inTrunk ? species.getMaxBranchRadius() : Math.min(species.getMaxBranchRadius(), 8);
            signal.radius = Mth.m_14036_((float)((float)Math.sqrt(areaAccum) + species.getTapering()), (float)this.getRadius(currBlockState), (float)maxRadius);
            int targetRadius = (int)Math.floor(signal.radius);
            int setRad = this.setRadius((LevelAccessor)level, pos, targetRadius, originDir, flags = theresPods ? 3 : 2);
            if (setRad < targetRadius) {
                signal.choked = true;
            }
        }
        return signal;
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return (Boolean)DTConfigs.ENABLE_BRANCH_CLIMBING.get() != false && entity instanceof Player && this.getFamily().branchIsLadder() && (!state.m_61138_((Property)WATERLOGGED) || (Boolean)state.m_61143_((Property)WATERLOGGED) == false);
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int thisRadiusInt = this.getRadius(state);
        double radius = (double)thisRadiusInt / 16.0;
        VoxelShape core = Shapes.m_83048_((double)(0.5 - radius), (double)(0.5 - radius), (double)(0.5 - radius), (double)(0.5 + radius), (double)(0.5 + radius), (double)(0.5 + radius));
        for (Direction dir : Direction.values()) {
            int sideRadiusInt = Math.min(this.getSideConnectionRadius(level, pos, thisRadiusInt, dir), thisRadiusInt);
            double sideRadius = (float)sideRadiusInt / 16.0f;
            if (!(sideRadius > 0.0)) continue;
            double gap = 0.5 - sideRadius;
            AABB aabb = new AABB(0.5 - sideRadius, 0.5 - sideRadius, 0.5 - sideRadius, 0.5 + sideRadius, 0.5 + sideRadius, 0.5 + sideRadius);
            aabb = aabb.m_82363_((double)dir.m_122429_() * gap, (double)dir.m_122430_() * gap, (double)dir.m_122431_() * gap);
            core = Shapes.m_83110_((VoxelShape)core, (VoxelShape)Shapes.m_83064_((AABB)aabb));
        }
        return core;
    }

    @Override
    public int getRadiusForConnection(BlockState state, BlockGetter level, BlockPos pos, BranchBlock from, Direction side, int fromRadius) {
        return this.getRadius(state);
    }

    protected int getSideConnectionRadius(BlockGetter level, BlockPos pos, int radius, Direction side) {
        BlockPos deltaPos = pos.m_121945_(side);
        BlockState blockState = CoordUtils.getStateSafe(level, deltaPos);
        return blockState == null ? 0 : TreeHelper.getTreePart(blockState).getRadiusForConnection(blockState, level, deltaPos, this, side, radius);
    }

    protected int getMaxSignalDepth() {
        return this.getFamily().getMaxSignalDepth();
    }

    @Override
    public MapSignal analyse(BlockState blockState, LevelAccessor level, BlockPos pos, @Nullable Direction fromDir, MapSignal signal) {
        if (signal.overflow || signal.trackVisited && signal.doTrackingVisited(pos)) {
            return signal;
        }
        if (signal.depth++ < this.getMaxSignalDepth()) {
            signal.run(blockState, level, pos, fromDir);
            for (Direction dir : Direction.values()) {
                BlockPos deltaPos;
                BlockState deltaState;
                TreePart treePart;
                if (dir == fromDir || !(treePart = TreeHelper.getTreePart(deltaState = level.m_8055_(deltaPos = pos.m_121945_(dir)))).shouldAnalyse(deltaState, (BlockGetter)level, deltaPos)) continue;
                signal = treePart.analyse(deltaState, level, deltaPos, dir.m_122424_(), signal);
                if (!signal.foundRoot || signal.localRootDir != null || fromDir != null) continue;
                signal.localRootDir = dir;
            }
            signal.returnRun(blockState, level, pos, fromDir);
        } else {
            BlockState state = level.m_8055_(pos);
            if (signal.destroyLoopedNodes && state.m_60734_() instanceof BranchBlock) {
                BranchBlock branch = (BranchBlock)state.m_60734_();
                branch.breakDeliberate(level, pos, DynamicTrees.DestroyMode.OVERFLOW);
            }
            signal.overflow = true;
        }
        --signal.depth;
        return signal;
    }

    @Override
    public BlockState getStateForDecay(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean waterlogged = state.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false;
        return waterlogged ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
    }
}

