/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.block.branch;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.FutureBreakable;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.TreePart;
import com.ferreusveritas.dynamictrees.block.BlockWithDynamicHardness;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.data.provider.DTLootTableProvider;
import com.ferreusveritas.dynamictrees.entity.FallingTreeEntity;
import com.ferreusveritas.dynamictrees.event.FutureBreak;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.systems.nodemapper.DestroyerNode;
import com.ferreusveritas.dynamictrees.systems.nodemapper.NetVolumeNode;
import com.ferreusveritas.dynamictrees.systems.nodemapper.SpeciesNode;
import com.ferreusveritas.dynamictrees.systems.nodemapper.StateNode;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.BlockBounds;
import com.ferreusveritas.dynamictrees.util.BlockStates;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import com.ferreusveritas.dynamictrees.util.Connections;
import com.ferreusveritas.dynamictrees.util.EntityUtils;
import com.ferreusveritas.dynamictrees.util.ItemUtils;
import com.ferreusveritas.dynamictrees.util.LootTableSupplier;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolActions;

public abstract class BranchBlock
extends BlockWithDynamicHardness
implements TreePart,
FutureBreakable {
    public static final int MAX_RADIUS = 8;
    public static final String NAME_SUFFIX = "_branch";
    public static DynamicTrees.DestroyMode destroyMode = DynamicTrees.DestroyMode.SLOPPY;
    private Family family = Family.NULL_FAMILY;
    private ItemStack[] primitiveLogDrops = new ItemStack[0];
    private boolean canBeStripped;
    private final LootTableSupplier lootTableSupplier;

    public BranchBlock(ResourceLocation name) {
        this(name, BlockBehaviour.Properties.m_284310_().m_278166_(PushReaction.BLOCK));
    }

    public BranchBlock(ResourceLocation name, BlockBehaviour.Properties properties) {
        super(properties);
        this.lootTableSupplier = new LootTableSupplier("trees/branches/", name);
    }

    public BranchBlock setCanBeStripped(boolean truth) {
        this.canBeStripped = truth;
        return this;
    }

    public void setFamily(Family tree) {
        this.family = tree;
    }

    public Family getFamily() {
        return this.family;
    }

    @Override
    public Family getFamily(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getFamily();
    }

    public boolean isSameTree(TreePart treepart) {
        return this.isSameTree(TreeHelper.getBranch(treepart));
    }

    public boolean isSameTree(BlockState state) {
        return TreeHelper.getBranchOpt(state).map(branch -> this.getFamily() == branch.getFamily()).orElse(false);
    }

    public boolean isSameTree(@Nullable BranchBlock branch) {
        return branch != null && this.getFamily() == branch.getFamily();
    }

    public Optional<Block> getPrimitiveLog() {
        return this.isStrippedBranch() ? this.family.getPrimitiveStrippedLog() : this.family.getPrimitiveLog();
    }

    public boolean isStrippedBranch() {
        return this.getFamily().getStrippedBranch().map(other -> other == this).orElse(false);
    }

    @Override
    public abstract int branchSupport(BlockState var1, BlockGetter var2, BranchBlock var3, BlockPos var4, Direction var5, int var6);

    public abstract boolean checkForRot(LevelAccessor var1, BlockPos var2, Species var3, int var4, int var5, RandomSource var6, float var7, boolean var8);

    public static int setSupport(int branches, int leaves) {
        return (branches & 0xF) << 4 | leaves & 0xF;
    }

    public static int getBranchSupport(int support) {
        return support >> 4 & 0xF;
    }

    public static int getLeavesSupport(int support) {
        return support & 0xF;
    }

    public static boolean isNextToBranch(Level level, BlockPos pos, Direction originDir) {
        for (Direction dir : Direction.values()) {
            if (dir.equals((Object)originDir) || !TreeHelper.isBranch(level.m_8055_(pos.m_121945_(dir)))) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack heldItem = player.m_21120_(hand);
        return TreeHelper.getTreePart(state).getFamily(state, (BlockGetter)level, pos).onTreeActivated(new Family.TreeActivationContext(level, TreeHelper.findRootNode(level, pos), pos, state, player, hand, heldItem, hitResult)) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public boolean canBeStripped(BlockState state, Level level, BlockPos pos, Player player, ItemStack heldItem) {
        int stripRadius = this.getFamily().getMinRadiusForStripping();
        return stripRadius != 0 && stripRadius <= this.getRadius(state) && this.canBeStripped && heldItem.canPerformAction(ToolActions.AXE_STRIP);
    }

    public void stripBranch(BlockState state, Level level, BlockPos pos, Player player, ItemStack heldItem) {
        int radius = this.getRadius(state);
        this.damageAxe((LivingEntity)player, heldItem, radius / 2, new NetVolumeNode.Volume(radius * radius * 64 / 2), false);
        this.stripBranch(state, (LevelAccessor)level, pos, radius);
    }

    public void stripBranch(BlockState state, LevelAccessor level, BlockPos pos) {
        this.stripBranch(state, level, pos, this.getRadius(state));
    }

    public void stripBranch(BlockState state, LevelAccessor level, BlockPos pos, int radius) {
        this.getFamily().getStrippedBranch().ifPresent(strippedBranch -> strippedBranch.setRadius(level, pos, Math.max(1, radius - (this.getFamily().reduceRadiusWhenStripping() ? 1 : 0)), null, 3));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return this.getFamily().getBranchItem().map(ItemStack::new).orElse(ItemStack.f_41583_);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public BlockState getStateForDecay(BlockState state, LevelAccessor level, BlockPos pos) {
        return Blocks.f_50016_.m_49966_();
    }

    public Connections getConnectionData(@Nonnull BlockAndTintGetter level, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        Connections connections = new Connections();
        if (state.m_60734_() != this) {
            return connections;
        }
        int coreRadius = this.getRadius(state);
        for (Direction dir : Direction.values()) {
            BlockPos deltaPos = pos.m_121945_(dir);
            BlockState neighborBlockState = level.m_8055_(deltaPos);
            int sideRadius = TreeHelper.getTreePart(neighborBlockState).getRadiusForConnection(neighborBlockState, (BlockGetter)level, deltaPos, this, dir, coreRadius);
            connections.setRadius(dir, Mth.m_14045_((int)sideRadius, (int)0, (int)coreRadius));
        }
        return connections;
    }

    public boolean connectToLeaves(BlockGetter blockAccess, BlockPos leavesPos, Direction branchConnectionDir, int branchRadius) {
        return true;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    public int getRadius(BlockState state) {
        return 1;
    }

    public abstract int setRadius(LevelAccessor var1, BlockPos var2, int var3, @Nullable Direction var4, int var5);

    public int setRadius(LevelAccessor level, BlockPos pos, int radius, @Nullable Direction originDir) {
        return this.setRadius(level, pos, radius, originDir, 2);
    }

    public abstract BlockState getStateForRadius(int var1);

    public int getMaxRadius() {
        return 8;
    }

    @Override
    public boolean shouldAnalyse(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public BranchDestructionData destroyBranchFromNode(Level level, BlockPos cutPos, Direction toolDir, boolean wholeTree, @Nullable LivingEntity entity) {
        BlockState blockState = level.m_8055_(cutPos);
        SpeciesNode speciesNode = new SpeciesNode();
        MapSignal signal = this.analyse(blockState, (LevelAccessor)level, cutPos, null, new MapSignal(speciesNode));
        Species species = speciesNode.getSpecies();
        StateNode stateMapper = new StateNode(cutPos);
        this.analyse(blockState, (LevelAccessor)level, cutPos, wholeTree ? null : signal.localRootDir, new MapSignal(stateMapper));
        NetVolumeNode volumeSum = new NetVolumeNode();
        DestroyerNode destroyer = new DestroyerNode(species).setPlayer(entity instanceof Player ? (Player)entity : null);
        destroyMode = DynamicTrees.DestroyMode.HARVEST;
        this.analyse(blockState, (LevelAccessor)level, cutPos, wholeTree ? null : signal.localRootDir, new MapSignal(volumeSum, destroyer));
        destroyMode = DynamicTrees.DestroyMode.SLOPPY;
        List<Object> endPoints = destroyer.getEnds();
        HashMap<BlockPos, BlockState> destroyedLeaves = new HashMap<BlockPos, BlockState>();
        ArrayList<ItemStackPos> leavesDropsList = new ArrayList<ItemStackPos>();
        if (species != Species.NULL_SPECIES) {
            this.destroyLeaves(level, cutPos, species, entity == null ? ItemStack.f_41583_ : entity.m_21205_(), endPoints, destroyedLeaves, leavesDropsList);
        }
        endPoints = endPoints.stream().map(p -> p.m_121996_((Vec3i)cutPos)).collect(Collectors.toList());
        int trunkHeight = 1;
        BlockPos iter = new BlockPos(0, 1, 0);
        while (stateMapper.getBranchConnectionMap().containsKey(iter)) {
            ++trunkHeight;
            iter = iter.m_7494_();
        }
        Direction cutDir = signal.localRootDir;
        if (cutDir == null) {
            cutDir = Direction.DOWN;
        }
        return new BranchDestructionData(species, stateMapper.getBranchConnectionMap(), destroyedLeaves, leavesDropsList, endPoints, volumeSum.getVolume(), cutPos, cutDir, toolDir, trunkHeight);
    }

    public void rot(LevelAccessor level, BlockPos pos) {
        this.breakDeliberate(level, pos, DynamicTrees.DestroyMode.ROT);
    }

    public void destroyLeaves(Level level, BlockPos cutPos, Species species, ItemStack tool, List<BlockPos> endPoints, Map<BlockPos, BlockState> destroyedLeaves, List<ItemStackPos> drops) {
        if (level.f_46443_ || endPoints.isEmpty()) {
            return;
        }
        BlockBounds bounds = this.getFamily().expandLeavesBlockBounds(new BlockBounds(endPoints));
        SimpleVoxmap leafMap = new SimpleVoxmap(bounds);
        for (BlockPos endPos : endPoints) {
            for (BlockPos leafPos : this.getFamily().expandLeavesBlockBounds(new BlockBounds(endPos))) {
                leafMap.setVoxel(leafPos, (byte)1);
            }
            leafMap.setVoxel(endPos, (byte)0);
        }
        Family family = species.getFamily();
        BranchBlock familyBranch = family.getBranch().get();
        int primaryThickness = family.getPrimaryThickness();
        for (BlockPos findPos : this.getFamily().expandLeavesBlockBounds(bounds)) {
            BlockState findState = level.m_8055_(findPos);
            if (familyBranch.getRadius(findState) != primaryThickness) continue;
            Iterable<BlockPos.MutableBlockPos> leaves = species.getLeavesProperties().getCellKit().getLeafCluster().getAllNonZero();
            for (BlockPos.MutableBlockPos leafPos : leaves) {
                leafMap.setVoxel(findPos.m_123341_() + leafPos.m_123341_(), findPos.m_123342_() + leafPos.m_123342_(), findPos.m_123343_() + leafPos.m_123343_(), (byte)0);
            }
        }
        ArrayList<ItemStack> dropList = new ArrayList<ItemStack>();
        for (SimpleVoxmap.Cell cell : leafMap.getAllNonZeroCells()) {
            BlockPos.MutableBlockPos pos = cell.getPos();
            BlockState state = level.m_8055_((BlockPos)pos);
            if (!family.isCompatibleGenericLeaves(species, state, (LevelAccessor)level, (BlockPos)pos)) continue;
            dropList.clear();
            LeavesProperties leaves = Optional.ofNullable(TreeHelper.getLeaves(state)).map(block -> block.getProperties(state)).orElse(LeavesProperties.NULL);
            dropList.addAll(leaves.getDrops(level, (BlockPos)pos, tool, species));
            BlockPos imPos = pos.m_7949_();
            BlockPos relPos = imPos.m_121996_((Vec3i)cutPos);
            level.m_7731_(imPos, BlockStates.AIR, 3);
            destroyedLeaves.put(relPos, state);
            dropList.forEach(i -> drops.add(new ItemStackPos((ItemStack)i, relPos)));
        }
    }

    public boolean canFall() {
        return false;
    }

    public boolean shouldGenerateBranchDrops() {
        return this.getPrimitiveLog().isPresent();
    }

    public ResourceLocation getLootTableName() {
        return this.lootTableSupplier.getName();
    }

    public LootTable getLootTable(LootDataManager lootTables, Species species) {
        return this.lootTableSupplier.get(lootTables, species);
    }

    public LootTable.Builder createBranchDrops() {
        return DTLootTableProvider.BlockLoot.createBranchDrops(this.getPrimitiveLog().get(), this.family.getStick(1).m_41720_());
    }

    public float getPrimitiveLogs(float volumeIn, List<ItemStack> drops) {
        int numLogs = (int)volumeIn;
        for (ItemStack stack : this.primitiveLogDrops) {
            for (int num = numLogs * stack.m_41613_(); num > 0; num -= stack.m_41741_()) {
                ItemStack drop = stack.m_41777_();
                drop.m_41764_(Math.min(num, stack.m_41741_()));
                drops.add(drop);
            }
        }
        return volumeIn - (float)numLogs;
    }

    public BranchBlock setPrimitiveLogDrops(ItemStack ... drops) {
        this.primitiveLogDrops = drops;
        return this;
    }

    @Override
    public void futureBreak(BlockState state, Level level, BlockPos cutPos, LivingEntity entity) {
        double reachDistance = entity instanceof Player ? entity.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_() : 5.0;
        BlockHitResult ragTraceResult = EntityUtils.playerRayTrace(entity, reachDistance, 1.0f);
        Direction toolDir = ragTraceResult != null ? (entity.m_6144_() ? ragTraceResult.m_82434_().m_122424_() : ragTraceResult.m_82434_()) : Direction.DOWN;
        level.m_5898_(null, 2001, cutPos, BranchBlock.m_49956_((BlockState)state));
        BranchDestructionData destroyData = this.destroyBranchFromNode(level, cutPos, toolDir, false, entity);
        ItemStack heldItem = entity.m_21205_();
        int fortune = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44987_, (ItemStack)heldItem);
        float fortuneFactor = 1.0f + 0.25f * (float)fortune;
        NetVolumeNode.Volume woodVolume = destroyData.woodVolume;
        woodVolume.multiplyVolume(fortuneFactor);
        List<ItemStack> woodItems = destroyData.species.getBranchesDrops(level, woodVolume, heldItem);
        float chance = 1.0f;
        List<ItemStack> woodDropList = woodItems.stream().filter(i -> level.f_46441_.m_188501_() <= 1.0f).collect(Collectors.toList());
        FallingTreeEntity.dropTree(level, destroyData, woodDropList, FallingTreeEntity.DestroyType.HARVEST);
        this.damageAxe(entity, heldItem, this.getRadius(state), woodVolume, true);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        return this.removedByEntity(state, level, pos, (LivingEntity)player);
    }

    public boolean removedByEntity(BlockState state, Level level, BlockPos cutPos, LivingEntity entity) {
        FutureBreak.add(new FutureBreak(state, level, cutPos, entity, 0));
        return false;
    }

    protected void sloppyBreak(Level level, BlockPos cutPos, FallingTreeEntity.DestroyType destroyType) {
        BranchDestructionData destroyData = this.destroyBranchFromNode(level, cutPos, Direction.DOWN, false, null);
        List<ItemStack> woodDropList = destroyData.species.getBranchesDrops(level, destroyData.woodVolume);
        if (!((Boolean)DTConfigs.SLOPPY_BREAK_DROPS.get()).booleanValue()) {
            destroyData.leavesDrops.clear();
            woodDropList.clear();
        }
        FallingTreeEntity.dropTree(level, destroyData, woodDropList, destroyType);
    }

    public void damageAxe(LivingEntity entity, @Nullable ItemStack heldItem, int radius, NetVolumeNode.Volume woodVolume, boolean forBlockBreak) {
        ItemUtils.damageAxe(entity, heldItem, radius, woodVolume, forBlockBreak);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean flag) {
        BlockPos offPos;
        if (level.f_46443_ || destroyMode != DynamicTrees.DestroyMode.SLOPPY) {
            super.m_6810_(state, level, pos, newState, flag);
            return;
        }
        BlockState toBlockState = level.m_8055_(pos);
        Block toBlock = toBlockState.m_60734_();
        if (toBlock instanceof BranchBlock) {
            return;
        }
        boolean foundFire = toBlockState.m_204336_(BlockTags.f_13076_);
        if (!foundFire) {
            for (Direction offset : Direction.values()) {
                offPos = pos.m_121955_(offset.m_122436_());
                if (!level.m_8055_(offPos).m_204336_(BlockTags.f_13076_)) continue;
                foundFire = true;
                break;
            }
        }
        if (foundFire) {
            level.m_7731_(pos, state, 0);
            this.sloppyBreak(level, pos, FallingTreeEntity.DestroyType.FIRE);
            this.setBlockStateIgnored(level, pos, BlockStates.AIR, 2);
            return;
        }
        if (toBlock == Blocks.f_50016_) {
            level.m_7731_(pos, state, 0);
            this.sloppyBreak(level, pos, FallingTreeEntity.DestroyType.VOID);
            this.setBlockStateIgnored(level, pos, BlockStates.AIR, 2);
            return;
        }
        if (level.m_7702_(pos) == null) {
            level.m_7731_(pos, state, 0);
            this.sloppyBreak(level, pos, FallingTreeEntity.DestroyType.VOID);
            this.setBlockStateIgnored(level, pos, toBlockState, 2);
            return;
        }
        for (Direction dir : Direction.values()) {
            offPos = pos.m_121945_(dir);
            BlockState offState = level.m_8055_(offPos);
            if (!(offState.m_60734_() instanceof BranchBlock)) continue;
            this.sloppyBreak(level, offPos, FallingTreeEntity.DestroyType.VOID);
        }
        super.m_6810_(state, level, pos, newState, flag);
    }

    public void setBlockStateIgnored(Level level, BlockPos pos, BlockState state, int flags) {
        destroyMode = DynamicTrees.DestroyMode.IGNORE;
        level.m_7731_(pos, state, flags);
        destroyMode = DynamicTrees.DestroyMode.SLOPPY;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
    }

    public void breakDeliberate(LevelAccessor level, BlockPos pos, DynamicTrees.DestroyMode mode) {
        destroyMode = mode;
        FluidState state = level.m_6425_(pos);
        if (state.m_76178_()) {
            level.m_7471_(pos, false);
        } else {
            level.m_7731_(pos, state.m_76188_(), 3);
        }
        destroyMode = DynamicTrees.DestroyMode.SLOPPY;
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        NetVolumeNode.Volume woodVolume;
        List<ItemStack> woodDropList;
        Species species = TreeHelper.getExactSpecies(level, pos);
        BranchDestructionData destroyData = this.destroyBranchFromNode(level, pos, Direction.DOWN, false, null);
        FallingTreeEntity treeEntity = FallingTreeEntity.dropTree(level, destroyData, woodDropList = species.getBranchesDrops(level, woodVolume = destroyData.woodVolume, ItemStack.f_41583_, Float.valueOf(explosion.f_46017_)), FallingTreeEntity.DestroyType.BLAST);
        if (treeEntity != null) {
            Vec3 expPos = explosion.getPosition();
            double distance = Math.sqrt(treeEntity.m_20275_(expPos.f_82479_, expPos.f_82480_, expPos.f_82481_));
            if (distance / (double)explosion.f_46017_ <= 1.0 && distance != 0.0) {
                treeEntity.m_5997_((treeEntity.m_20185_() - expPos.f_82479_) / distance, (treeEntity.m_20186_() - expPos.f_82480_) / distance, (treeEntity.m_20189_() - expPos.f_82481_) / distance);
            }
        }
        this.m_7592_(level, pos, explosion);
    }

    @Override
    public final TreePart.TreePartType getTreePartType() {
        return TreePart.TreePartType.BRANCH;
    }

    public static class ItemStackPos {
        public final ItemStack stack;
        public final BlockPos pos;

        public ItemStackPos(ItemStack stack, BlockPos pos) {
            this.stack = stack;
            this.pos = pos;
        }
    }
}

