/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.block.leaves;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.data.Generator;
import com.ferreusveritas.dynamictrees.api.data.PalmLeavesStateGenerator;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.data.provider.DTBlockStateProvider;
import com.ferreusveritas.dynamictrees.data.provider.DTLootTableProvider;
import com.ferreusveritas.dynamictrees.data.provider.PalmLeavesLoaderBuilder;
import com.ferreusveritas.dynamictrees.loot.DTLootParameterSets;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.MutableLazyValue;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class PalmLeavesProperties
extends LeavesProperties {
    public static final TypedRegistry.EntryType<LeavesProperties> TYPE = TypedRegistry.newType(PalmLeavesProperties::new);
    protected final MutableLazyValue<Generator<DTBlockStateProvider, LeavesProperties>> palmStateGenerator = MutableLazyValue.supplied(PalmLeavesStateGenerator::new);
    public static final String FROND = "frond";
    public static final String CORE_TOP = "core_top";
    public static final String CORE_BOTTOM = "core_bottom";
    ResourceLocation frondLoader = DynamicTrees.location("large_palm_fronds");

    public PalmLeavesProperties(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected DynamicLeavesBlock createDynamicLeaves(BlockBehaviour.Properties properties) {
        return new DynamicPalmLeavesBlock(this, properties);
    }

    @Override
    public void generateStateData(DTBlockStateProvider provider) {
        this.palmStateGenerator.get().generate(provider, this);
    }

    public String getFrondsModelName() {
        return "block/palm_leaves/" + this.getRegistryName().m_135815_() + "_frond";
    }

    public String getCoreTopModelName() {
        return "block/palm_leaves/" + this.getRegistryName().m_135815_() + "_core_top";
    }

    public String getCoreBottomModelName() {
        return "block/palm_leaves/" + this.getRegistryName().m_135815_() + "_core_bottom";
    }

    public void addFrondTextures(BiConsumer<String, ResourceLocation> textureConsumer, ResourceLocation leavesTextureLocation) {
        ResourceLocation leavesLoc = this.getTexturePath(FROND).orElse(leavesTextureLocation);
        textureConsumer.accept(FROND, leavesLoc);
    }

    public void addCoreTextures(BiConsumer<String, ResourceLocation> textureConsumer, ResourceLocation coreTextureLocation) {
        ResourceLocation coreLoc = this.getTexturePath(CORE_BOTTOM).orElse(coreTextureLocation);
        textureConsumer.accept(CORE_BOTTOM, coreLoc);
    }

    public void setFrondLoader(ResourceLocation frondLoader) {
        this.frondLoader = frondLoader;
    }

    public BiFunction<BlockModelBuilder, ExistingFileHelper, PalmLeavesLoaderBuilder> getFrondsLoaderConstructor() {
        return (b, e) -> PalmLeavesLoaderBuilder.fronds(this.frondLoader, b, e);
    }

    public ResourceLocation getCoreTopSmartModelLocation() {
        if (this.modelOverrides.containsKey(CORE_TOP)) {
            return (ResourceLocation)this.modelOverrides.get(CORE_TOP);
        }
        return DynamicTrees.location("block/smartmodel/palm/core_top");
    }

    public ResourceLocation getCoreBottomSmartModelLocation() {
        if (this.modelOverrides.containsKey(CORE_BOTTOM)) {
            return (ResourceLocation)this.modelOverrides.get(CORE_BOTTOM);
        }
        return DynamicTrees.location("block/smartmodel/palm/core_bottom");
    }

    @Override
    public LootTable.Builder createBlockDrops() {
        if (this.primitiveLeaves != null && this.getPrimitiveLeavesBlock().isPresent()) {
            return DTLootTableProvider.BlockLoot.createPalmLeavesBlockDrops(this.primitiveLeaves.m_60734_(), this.seedDropChances);
        }
        return DTLootTableProvider.BlockLoot.createPalmLeavesDrops(this.seedDropChances, LootContextParamSets.f_81421_);
    }

    @Override
    public LootTable.Builder createDrops() {
        return DTLootTableProvider.BlockLoot.createPalmLeavesDrops(this.seedDropChances, DTLootParameterSets.LEAVES);
    }

    public static class DynamicPalmLeavesBlock
    extends DynamicLeavesBlock {
        public static final IntegerProperty DIRECTION = IntegerProperty.m_61631_((String)"direction", (int)0, (int)8);
        public static final CoordUtils.Surround[][] hydroSurroundMap = new CoordUtils.Surround[][]{new CoordUtils.Surround[0], {CoordUtils.Surround.NE, CoordUtils.Surround.SE, CoordUtils.Surround.SW, CoordUtils.Surround.NW}, {CoordUtils.Surround.N, CoordUtils.Surround.E, CoordUtils.Surround.S, CoordUtils.Surround.W}, new CoordUtils.Surround[0], new CoordUtils.Surround[0], new CoordUtils.Surround[0], new CoordUtils.Surround[0], new CoordUtils.Surround[0]};

        @Override
        public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
            int dist;
            if (state.m_60734_() == this && ((dist = ((Integer)state.m_61143_((Property)f_54418_)).intValue()) == 1 || dist == 2) && (Integer)state.m_61143_((Property)DIRECTION) == 0) {
                level.m_46597_(pos, Blocks.f_50016_.m_49966_());
                return;
            }
            super.m_213898_(state, level, pos, rand);
        }

        public DynamicPalmLeavesBlock(LeavesProperties leavesProperties, BlockBehaviour.Properties properties) {
            super(leavesProperties, properties);
            this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)DIRECTION, (Comparable)Integer.valueOf(0)));
        }

        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
            builder.m_61104_(new Property[]{DIRECTION});
        }

        public static BlockState getDirectionState(BlockState state, CoordUtils.Surround surround) {
            if (state == null) {
                return null;
            }
            return (BlockState)state.m_61124_((Property)DIRECTION, (Comparable)Integer.valueOf(surround == null ? 0 : surround.ordinal() + 1));
        }

        @Override
        public int getRadiusForConnection(BlockState state, BlockGetter level, BlockPos pos, BranchBlock from, Direction side, int fromRadius) {
            return side == Direction.UP && from.getFamily().isCompatibleDynamicLeaves(Species.NULL_SPECIES, state, level, pos) ? fromRadius : 0;
        }

        @Override
        public int branchSupport(BlockState state, BlockGetter level, BranchBlock branch, BlockPos pos, Direction dir, int radius) {
            return branch.getFamily() == this.getFamily(state, level, pos) ? BranchBlock.setSupport(0, 1) : 0;
        }

        @Override
        public boolean appearanceChangesWithHydro(int oldHydro, int newHydro) {
            return true;
        }

        @Override
        public BlockState getLeavesBlockStateForPlacement(LevelAccessor level, BlockPos pos, BlockState leavesStateWithHydro, int oldHydro, boolean worldGen) {
            for (CoordUtils.Surround surround : CoordUtils.Surround.values()) {
                BlockState offstate = level.m_8055_(pos.m_121955_(surround.getOffset()));
                if (offstate.m_60734_() != this || (Integer)offstate.m_61143_((Property)f_54418_) != 3) continue;
                return DynamicPalmLeavesBlock.getDirectionState(leavesStateWithHydro, surround);
            }
            return leavesStateWithHydro;
        }

        public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
            AABB base = super.m_7952_(state, level, pos).m_83215_();
            base.m_82377_(1.0, 0.0, 1.0);
            base.m_82377_(-1.0, 0.0, -1.0);
            return Shapes.m_83064_((AABB)base);
        }
    }
}

