/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.client;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;

@OnlyIn(value=Dist.CLIENT)
public class QuadManipulator {
    public static final Direction[] everyFace = new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, null};

    public static List<BakedQuad> getQuads(BakedModel modelIn, BlockState stateIn, ModelData modelData) {
        return QuadManipulator.getQuads(modelIn, stateIn, Vec3.f_82478_, everyFace, RandomSource.m_216327_(), modelData);
    }

    public static List<BakedQuad> getQuads(BakedModel modelIn, BlockState stateIn, Direction[] sides, ModelData modelData) {
        return QuadManipulator.getQuads(modelIn, stateIn, Vec3.f_82478_, sides, RandomSource.m_216327_(), modelData);
    }

    public static List<BakedQuad> getQuads(BakedModel modelIn, BlockState stateIn, RandomSource rand, ModelData modelData) {
        return QuadManipulator.getQuads(modelIn, stateIn, Vec3.f_82478_, everyFace, rand, modelData);
    }

    public static List<BakedQuad> getQuads(BakedModel modelIn, BlockState stateIn, Vec3 offset, RandomSource rand, ModelData modelData) {
        return QuadManipulator.getQuads(modelIn, stateIn, offset, everyFace, rand, modelData);
    }

    public static List<BakedQuad> getQuads(BakedModel modelIn, BlockState stateIn, Vec3 offset, ModelData modelData) {
        return QuadManipulator.getQuads(modelIn, stateIn, offset, everyFace, RandomSource.m_216327_(), modelData);
    }

    public static List<BakedQuad> getQuads(BakedModel modelIn, BlockState stateIn, Vec3 offset, Direction[] sides, ModelData modelData) {
        return QuadManipulator.getQuads(modelIn, stateIn, offset, sides, RandomSource.m_216327_(), modelData);
    }

    public static List<BakedQuad> getQuads(BakedModel modelIn, BlockState stateIn, Vec3 offset, Direction[] sides, RandomSource rand, ModelData modelData) {
        ArrayList<BakedQuad> outQuads = new ArrayList<BakedQuad>();
        if (stateIn != null) {
            for (Direction dir : sides) {
                outQuads.addAll(modelIn.getQuads(stateIn, dir, rand, modelData, null));
            }
        }
        return offset.equals((Object)Vec3.f_82478_) ? outQuads : QuadManipulator.moveQuads(outQuads, offset);
    }

    public static List<BakedQuad> moveQuads(List<BakedQuad> inQuads, Vec3 offset) {
        ArrayList<BakedQuad> outQuads = new ArrayList<BakedQuad>();
        for (BakedQuad inQuad : inQuads) {
            BakedQuad quadCopy = new BakedQuad((int[])inQuad.m_111303_().clone(), inQuad.m_111305_(), inQuad.m_111306_(), inQuad.m_173410_(), inQuad.m_111307_());
            int[] vertexData = quadCopy.m_111303_();
            block1: for (int i = 0; i < vertexData.length; i += DefaultVertexFormat.f_85811_.m_86017_()) {
                int pos = 0;
                for (VertexFormatElement vfe : DefaultVertexFormat.f_85811_.m_86023_()) {
                    if (vfe.m_86048_() == VertexFormatElement.Usage.POSITION) {
                        float x = Float.intBitsToFloat(vertexData[i + pos + 0]);
                        float y = Float.intBitsToFloat(vertexData[i + pos + 1]);
                        float z = Float.intBitsToFloat(vertexData[i + pos + 2]);
                        x = (float)((double)x + offset.f_82479_);
                        y = (float)((double)y + offset.f_82480_);
                        z = (float)((double)z + offset.f_82481_);
                        vertexData[i + pos + 0] = Float.floatToIntBits(x);
                        vertexData[i + pos + 1] = Float.floatToIntBits(y);
                        vertexData[i + pos + 2] = Float.floatToIntBits(z);
                        continue block1;
                    }
                    pos += vfe.m_86050_() / 4;
                }
            }
            outQuads.add(quadCopy);
        }
        outQuads.trimToSize();
        return outQuads;
    }

    public static BakedModel getModelForState(BlockState state) {
        BakedModel model = null;
        try {
            model = QuadManipulator.getModel(state);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return model;
    }

    public static ModelManager getModelManager() {
        return Minecraft.m_91087_().m_91304_();
    }

    public static BakedModel getModel(BlockState state) {
        return Minecraft.m_91087_().m_91289_().m_110910_(state);
    }

    public static ResourceLocation getModelTexture(BakedModel model, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, BlockState state, Direction dir) {
        float[] uvs = QuadManipulator.getSpriteUVFromBlockState(state, dir);
        if (uvs != null) {
            ArrayList<TextureAtlasSprite> sprites = new ArrayList<TextureAtlasSprite>();
            float closest = Float.POSITIVE_INFINITY;
            ResourceLocation closestTex = new ResourceLocation("missingno");
            if (model != null) {
                ResourceLocation tex = model.getParticleIcon(ModelData.EMPTY).m_245424_().m_246162_();
                TextureAtlasSprite tas = bakedTextureGetter.apply(tex);
                float u = tas.m_118367_(8.0);
                float v = tas.m_118393_(8.0);
                sprites.add(tas);
                float du = u - uvs[0];
                float dv = v - uvs[1];
                float distSq = du * du + dv * dv;
                if (distSq < closest) {
                    closest = distSq;
                    closestTex = tex;
                }
            }
            return closestTex;
        }
        return null;
    }

    public static float[] getSpriteUVFromBlockState(BlockState state, Direction side) {
        BakedModel bakedModel = QuadManipulator.getModelManager().m_119430_().m_110893_(state);
        ArrayList quads = new ArrayList();
        RandomSource random = RandomSource.m_216327_();
        quads.addAll(bakedModel.getQuads(state, side, random, ModelData.EMPTY, null));
        quads.addAll(bakedModel.getQuads(state, null, random, ModelData.EMPTY, null));
        Optional<BakedQuad> quad = quads.stream().filter(q -> q.m_111306_() == side).findFirst();
        if (quad.isPresent()) {
            float u = 0.0f;
            float v = 0.0f;
            int[] vertexData = quad.get().m_111303_();
            int numVertices = 0;
            for (int i = 0; i < vertexData.length; i += DefaultVertexFormat.f_85811_.m_86017_()) {
                int pos = 0;
                for (VertexFormatElement vfe : DefaultVertexFormat.f_85811_.m_86023_()) {
                    if (vfe.m_86048_() == VertexFormatElement.Usage.UV) {
                        u += Float.intBitsToFloat(vertexData[i + pos + 0]);
                        v += Float.intBitsToFloat(vertexData[i + pos + 1]);
                    }
                    pos += vfe.m_86050_() / 4;
                }
                ++numVertices;
            }
            return new float[]{u / (float)numVertices, v / (float)numVertices};
        }
        System.err.println("Warning: Could not get \"" + side + "\" side quads from blockstate: " + state);
        return null;
    }
}

