/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.data.provider;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.data.provider.DTDataProvider;
import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.init.DTTrees;
import com.ferreusveritas.dynamictrees.worldgen.CaveRootedTreeFeature;
import com.ferreusveritas.dynamictrees.worldgen.CaveRootedTreePlacement;
import com.ferreusveritas.dynamictrees.worldgen.DTFeatures;
import com.ferreusveritas.dynamictrees.worldgen.DynamicTreeFeature;
import com.ferreusveritas.dynamictrees.worldgen.feature.DTReplaceNyliumFungiBlockStateProvider;
import com.ferreusveritas.dynamictrees.worldgen.structure.VillageTreeReplacement;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.NetherFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NetherForestVegetationConfig;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.DataPackRegistriesHooks;

public class DTDatapackBuiltinEntriesProvider
extends DatapackBuiltinEntriesProvider
implements DTDataProvider {
    public DTDatapackBuiltinEntriesProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, Set<String> modIds) {
        super(output, (CompletableFuture)registries.thenApply(p -> DTDatapackBuiltinEntriesProvider.constructRegistries(p, DTDatapackBuiltinEntriesProvider.getBuilder(p))), modIds);
    }

    private static HolderLookup.Provider constructRegistries(HolderLookup.Provider original, RegistrySetBuilder datapackEntriesBuilder) {
        try {
            Field ownerField = ObfuscationReflectionHelper.findField(Holder.Reference.class, (String)"owner");
            Object holderOwner = ownerField.get(original.m_255025_(Registries.f_256952_).m_255043_(Biomes.f_48159_));
            Class<?> compositeOwnerClass = Class.forName("net.minecraft.core.RegistrySetBuilder$CompositeOwner");
            Field ownersField = ObfuscationReflectionHelper.findField(compositeOwnerClass, (String)"owners");
            Set owners = (Set)ownersField.get(holderOwner);
            HashSet builderKeys = new HashSet(datapackEntriesBuilder.getEntryKeys());
            DataPackRegistriesHooks.getDataPackRegistriesWithDimensions().filter(data -> !builderKeys.contains(data.f_243794_())).forEach(data -> datapackEntriesBuilder.m_254916_(data.f_243794_(), context -> {}));
            HolderLookup.Provider provider = datapackEntriesBuilder.m_254929_((RegistryAccess)RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_), original);
            Object newHolderOwner = ownerField.get(provider.m_255025_(Registries.f_256911_).m_255043_(DTFeatures.DYNAMIC_TREE_CONFIGURED_FEATURE));
            owners.addAll((Set)ownersField.get(newHolderOwner));
            return provider;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static RegistrySetBuilder getBuilder(HolderLookup.Provider vanillaProvider) {
        return new RegistrySetBuilder().m_254916_(Registries.f_256948_, context -> DTDatapackBuiltinEntriesProvider.bootstrapTemplatePools(vanillaProvider, (BootstapContext<StructureTemplatePool>)context)).m_254916_(Registries.f_256911_, context -> DTDatapackBuiltinEntriesProvider.bootstrapConfiguredFeatures(vanillaProvider, context)).m_254916_(Registries.f_256988_, DTDatapackBuiltinEntriesProvider::bootstrapPlacedFeatures);
    }

    private static void bootstrapTemplatePools(HolderLookup.Provider vanillaProvider, BootstapContext<StructureTemplatePool> context) {
        VillageTreeReplacement.replaceTreesFromVanillaVillages(vanillaProvider, context);
    }

    private static void bootstrapConfiguredFeatures(HolderLookup.Provider vanillaProvider, BootstapContext<ConfiguredFeature<?, ?>> context) {
        context.m_255272_(DTFeatures.DYNAMIC_TREE_CONFIGURED_FEATURE, (Object)new ConfiguredFeature((Feature)((DynamicTreeFeature)((Object)DTRegistries.DYNAMIC_TREE_FEATURE.get())), (FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
        context.m_255272_(DTFeatures.CAVE_ROOTED_TREE_CONFIGURED_FEATURE, (Object)new ConfiguredFeature((Feature)((CaveRootedTreeFeature)((Object)DTRegistries.CAVE_ROOTED_TREE_FEATURE.get())), (FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
        DTDatapackBuiltinEntriesProvider.replaceNyliumFungiFeatures(vanillaProvider, context);
    }

    private static void bootstrapPlacedFeatures(BootstapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.m_255420_(Registries.f_256911_);
        context.m_255272_(DTFeatures.DYNAMIC_TREE_PLACED_FEATURE, (Object)new PlacedFeature((Holder)configuredFeatures.m_255043_(DTFeatures.DYNAMIC_TREE_CONFIGURED_FEATURE), List.of()));
        context.m_255272_(DTFeatures.CAVE_ROOTED_TREE_PLACED_FEATURE, (Object)new PlacedFeature((Holder)configuredFeatures.m_255043_(DTFeatures.CAVE_ROOTED_TREE_CONFIGURED_FEATURE), List.of(CaveRootedTreePlacement.INSTANCE, PlacementUtils.f_195360_, EnvironmentScanPlacement.m_191657_((Direction)Direction.UP, (BlockPredicate)BlockPredicate.m_190432_(), (BlockPredicate)BlockPredicate.f_190393_, (int)12), RandomOffsetPlacement.m_191877_((IntProvider)ConstantInt.m_146483_((int)-1)), BiomeFilter.m_191561_())));
    }

    private static void replaceNyliumFungiFeatures(HolderLookup.Provider vanillaProvider, BootstapContext<ConfiguredFeature<?, ?>> context) {
        TreeRegistry.findSpecies(DTTrees.CRIMSON).getSapling().ifPresent(crimsonSapling -> TreeRegistry.findSpecies(DTTrees.WARPED).getSapling().ifPresent(warpedSapling -> {
            HolderLookup.RegistryLookup configuredFeatures = (HolderLookup.RegistryLookup)vanillaProvider.m_254861_(Registries.f_256911_).orElseThrow();
            List.of(NetherFeatures.f_195036_, NetherFeatures.f_195037_, NetherFeatures.f_195039_, NetherFeatures.f_195040_).forEach(key -> DTDatapackBuiltinEntriesProvider.replaceFeature(context, configuredFeatures, key, crimsonSapling, warpedSapling));
        }));
    }

    private static void replaceFeature(BootstapContext<ConfiguredFeature<?, ?>> context, HolderLookup.RegistryLookup<ConfiguredFeature<?, ?>> configuredFeatures, ResourceKey<ConfiguredFeature<?, ?>> key, Block crimsonSapling, Block warpedSapling) {
        ConfiguredFeature feature = (ConfiguredFeature)configuredFeatures.m_255043_(key).m_203334_();
        NetherForestVegetationConfig config = (NetherForestVegetationConfig)feature.f_65378_();
        WeightedStateProvider stateProvider = (WeightedStateProvider)config.f_67540_;
        NetherForestVegetationConfig newConfig = new NetherForestVegetationConfig(DTDatapackBuiltinEntriesProvider.replaceBlockStates(stateProvider, crimsonSapling, warpedSapling), config.f_191259_, config.f_191260_);
        context.m_255272_(key, (Object)new ConfiguredFeature(Feature.f_65744_, (FeatureConfiguration)newConfig));
    }

    private static BlockStateProvider replaceBlockStates(WeightedStateProvider stateProvider, Block crimsonSapling, Block warpedSapling) {
        SimpleWeightedRandomList.Builder listBuilder = SimpleWeightedRandomList.m_146263_();
        for (WeightedEntry.Wrapper entry : stateProvider.f_68809_.m_146338_()) {
            BlockState blockState = (BlockState)entry.m_146310_();
            if (blockState.m_60713_(Blocks.f_50700_)) {
                blockState = crimsonSapling.m_49966_();
            } else if (blockState.m_60713_(Blocks.f_50691_)) {
                blockState = warpedSapling.m_49966_();
            }
            listBuilder.m_146271_((Object)blockState, entry.m_142631_().m_146281_());
        }
        return new DTReplaceNyliumFungiBlockStateProvider((BlockStateProvider)new WeightedStateProvider(listBuilder), (BlockStateProvider)stateProvider);
    }
}

