/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.deserialisation;

import com.electronwill.nightconfig.core.EnumGetMethod;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.deserialisation.result.Result;
import com.google.gson.JsonElement;

public final class EnumDeserialiser<T extends Enum<T>>
implements JsonDeserialiser<T> {
    private final Class<T> enumType;

    public EnumDeserialiser(Class<T> enumType) {
        this.enumType = enumType;
    }

    @Override
    public Result<T, JsonElement> deserialise(JsonElement jsonElement) {
        return JsonDeserialisers.STRING.deserialise(jsonElement).map(enumStr -> EnumGetMethod.NAME_IGNORECASE.get(enumStr, this.enumType), "Couldn't get enum " + this.enumType + " from value '{previous_value}'.");
    }
}

