/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.entity.animation;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.branch.TrunkShellBlock;
import com.ferreusveritas.dynamictrees.entity.FallingTreeEntity;
import com.ferreusveritas.dynamictrees.entity.animation.AnimationHandler;
import com.ferreusveritas.dynamictrees.entity.animation.DataAnimationHandler;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PhysicsAnimationHandler
implements AnimationHandler {
    @Override
    public String getName() {
        return "physics";
    }

    HandlerData getData(FallingTreeEntity entity) {
        return entity.dataAnimationHandler instanceof HandlerData ? (HandlerData)entity.dataAnimationHandler : new HandlerData();
    }

    protected void playEndSound(FallingTreeEntity entity, boolean onWater) {
        if (!this.getData((FallingTreeEntity)entity).endSoundPlayed && !entity.m_9236_().m_5776_()) {
            SoundInstance fallingInstance = this.getData((FallingTreeEntity)entity).fallingSoundInstance;
            if (fallingInstance != null) {
                Minecraft.m_91087_().m_91106_().m_120399_(fallingInstance);
            }
            Species species = entity.getSpecies();
            SoundEvent sound = species.getFallingBranchEndSound(entity.getVolume(), entity.hasLeaves(), onWater);
            entity.m_5496_(sound, species.getFallingBranchPitch(entity.getVolume()), 1.0f);
            this.getData((FallingTreeEntity)entity).endSoundPlayed = true;
        }
    }

    @Override
    public void initMotion(FallingTreeEntity entity) {
        entity.dataAnimationHandler = new HandlerData();
        BlockPos cutPos = entity.getDestroyData().cutPos;
        long seed = entity.m_9236_().f_46441_.m_188505_();
        RandomSource random = RandomSource.m_216335_((long)(seed ^ ((long)cutPos.m_123341_() << 32 | (long)cutPos.m_123343_())));
        float mass = entity.getDestroyData().woodVolume.getVolume();
        float inertialMass = Mth.m_14036_((float)mass, (float)1.0f, (float)3.0f);
        entity.m_20334_(entity.m_20184_().f_82479_ / (double)inertialMass, entity.m_20184_().f_82480_ / (double)inertialMass, entity.m_20184_().f_82481_ / (double)inertialMass);
        this.getData((FallingTreeEntity)entity).rotPit = (random.m_188501_() - 0.5f) * 4.0f / inertialMass;
        this.getData((FallingTreeEntity)entity).rotYaw = (random.m_188501_() - 0.5f) * 4.0f / inertialMass;
        double motionToAdd = (double)entity.getDestroyData().cutDir.m_122424_().m_122429_() * 0.1;
        entity.m_20256_(entity.m_20184_().m_82520_(motionToAdd, motionToAdd, motionToAdd));
        FallingTreeEntity.standardDropLeavesPayLoad(entity);
    }

    @Override
    public void handleMotion(FallingTreeEntity entity) {
        if (entity.landed) {
            return;
        }
        entity.m_20334_(entity.m_20184_().f_82479_, entity.m_20184_().f_82480_ - (double)0.03f, entity.m_20184_().f_82481_);
        entity.m_20334_(entity.m_20184_().f_82479_ * (double)0.98f, entity.m_20184_().f_82480_ * (double)0.98f, entity.m_20184_().f_82481_ * (double)0.98f);
        this.getData((FallingTreeEntity)entity).rotYaw *= 0.98f;
        this.getData((FallingTreeEntity)entity).rotPit *= 0.98f;
        entity.m_6034_(entity.m_20185_() + entity.m_20184_().f_82479_, entity.m_20186_() + entity.m_20184_().f_82480_, entity.m_20189_() + entity.m_20184_().f_82481_);
        entity.m_146926_(Mth.m_14177_((float)(entity.m_146909_() + this.getData((FallingTreeEntity)entity).rotPit)));
        entity.m_146922_(Mth.m_14177_((float)(entity.m_146908_() + this.getData((FallingTreeEntity)entity).rotYaw)));
        int radius = 8;
        if (entity.getDestroyData().getNumBranches() <= 0) {
            return;
        }
        BlockState state = entity.getDestroyData().getBranchBlockState(0);
        if (TreeHelper.isBranch(state)) {
            radius = ((BranchBlock)state.m_60734_()).getRadius(state);
        }
        Level level = entity.m_9236_();
        AABB fallBox = new AABB(entity.m_20185_() - (double)radius, entity.m_20186_(), entity.m_20189_() - (double)radius, entity.m_20185_() + (double)radius, entity.m_20186_() + 1.0, entity.m_20189_() + (double)radius);
        BlockPos pos = BlockPos.m_274561_((double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_());
        BlockState collState = level.m_8055_(pos);
        if (!(TreeHelper.isLeaves(collState) || TreeHelper.isBranch(collState) || collState.m_60734_() instanceof TrunkShellBlock)) {
            if (collState.m_60734_() instanceof LiquidBlock) {
                this.playEndSound(entity, true);
                entity.m_20256_(entity.m_20184_().m_82520_(0.0, (double)0.03f, 0.0));
                entity.m_20256_(entity.m_20184_().m_82542_((double)0.8f, (double)0.8f, (double)0.8f));
                this.getData((FallingTreeEntity)entity).rotYaw *= 0.8f;
                this.getData((FallingTreeEntity)entity).rotPit *= 0.8f;
                entity.m_20256_(entity.m_20184_().m_82520_(0.0, 0.01, 0.0));
                entity.onFire = false;
            } else {
                VoxelShape shape = collState.m_60816_((BlockGetter)level, pos);
                AABB collBox = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
                if (!shape.m_83281_()) {
                    collBox = collState.m_60816_((BlockGetter)level, pos).m_83215_();
                }
                if (fallBox.m_82381_(collBox = collBox.m_82338_(pos))) {
                    this.playEndSound(entity, false);
                    entity.m_20334_(entity.m_20184_().f_82479_, 0.0, entity.m_20184_().f_82481_);
                    entity.m_6034_(entity.m_20185_(), collBox.f_82292_, entity.m_20189_());
                    entity.f_19855_ = entity.m_20186_();
                    entity.landed = true;
                    entity.m_6853_(true);
                    if (entity.onFire && entity.m_9236_().m_46859_(pos.m_7494_())) {
                        entity.m_9236_().m_46597_(pos.m_7494_(), Blocks.f_50083_.m_49966_());
                    }
                }
            }
        }
    }

    @Override
    public void dropPayload(FallingTreeEntity entity) {
        Level level = entity.m_9236_();
        entity.getPayload().forEach(i -> Block.m_49840_((Level)level, (BlockPos)BlockPos.m_274561_((double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_()), (ItemStack)i));
        entity.getDestroyData().leavesDrops.forEach(bis -> Block.m_49840_((Level)level, (BlockPos)entity.getDestroyData().cutPos.m_121955_((Vec3i)bis.pos), (ItemStack)bis.stack));
    }

    @Override
    public boolean shouldDie(FallingTreeEntity entity) {
        boolean dead;
        boolean bl = dead = entity.landed || entity.f_19797_ > 120;
        if (dead) {
            entity.cleanupRootyDirt();
        }
        return dead;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderTransform(FallingTreeEntity entity, float entityYaw, float partialTick, PoseStack poseStack) {
        float yaw = Mth.m_14177_((float)MathHelper.angleDegreesInterpolate(entity.f_19859_, entity.m_146908_(), partialTick));
        float pit = Mth.m_14177_((float)MathHelper.angleDegreesInterpolate(entity.f_19860_, entity.m_146909_(), partialTick));
        Vec3 mc = entity.getMassCenter();
        poseStack.m_85837_(mc.f_82479_, mc.f_82480_, mc.f_82481_);
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pit));
        poseStack.m_85837_(-mc.f_82479_ - 0.5, -mc.f_82480_, -mc.f_82481_ - 0.5);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRender(FallingTreeEntity entity) {
        return true;
    }

    static class HandlerData
    extends DataAnimationHandler {
        float rotYaw = 0.0f;
        float rotPit = 0.0f;
        boolean endSoundPlayed = false;
        SoundInstance fallingSoundInstance;

        HandlerData() {
        }
    }
}

