/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.growthlogic;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public class AzaleaLogic
extends GrowthLogicKit {
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public AzaleaLogic(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        int[] probMap = context.probMap();
        Direction originDir = context.signal().dir.m_122424_();
        for (Direction dir : Direction.values()) {
            if (dir == originDir) continue;
            BlockPos deltaPos = context.pos().m_121945_(dir);
            BlockState deltaBlockState = context.level().m_8055_(deltaPos);
            int n = dir.m_122411_();
            probMap[n] = probMap[n] + TreeHelper.getTreePart(deltaBlockState).probabilityForBlock(deltaBlockState, (BlockGetter)context.level(), deltaPos, context.branch());
        }
        GrowSignal signal = context.signal();
        int deltaY = Math.abs(signal.delta.m_123342_());
        int distFromTrunk = Math.max(Math.abs(signal.delta.m_123341_()), Math.abs(signal.delta.m_123343_()));
        float horizontalMultiplier = signal.isInTrunk() ? 1.0f : 1.0f / (float)distFromTrunk;
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            int n = dir.m_122411_();
            probMap[n] = (int)((float)probMap[n] * ((float)deltaY * horizontalMultiplier));
        }
        if (!signal.isInTrunk()) {
            if (originDir != Direction.UP) {
                int n = Direction.UP.m_122411_();
                probMap[n] = probMap[n] + distFromTrunk * 2;
            }
            probMap[Direction.DOWN.m_122411_()] = 0;
        } else {
            int n = Direction.UP.m_122411_();
            probMap[n] = probMap[n] * 2;
        }
        int i = 2;
        while (i < 6) {
            int n = i++;
            probMap[n] = (int)((double)probMap[n] * 0.5);
        }
        int n = AzaleaLogic.getDirectionBias(signal.rootPos).m_122411_();
        probMap[n] = probMap[n] * 8;
        return probMap;
    }

    private static Direction getDirectionBias(BlockPos rootPos) {
        return HORIZONTALS[CoordUtils.coordHashCode(rootPos, 0) % 4];
    }
}

