/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.loot.condition;

import com.ferreusveritas.dynamictrees.loot.condition.SeasonalSeedDropChance;
import com.ferreusveritas.dynamictrees.loot.condition.SpeciesMatches;
import com.ferreusveritas.dynamictrees.loot.condition.VoluntarySeedDropChance;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public final class DTLootConditions {
    public static final DeferredRegister<LootItemConditionType> LOOT_CONDITION_TYPES = DeferredRegister.create((ResourceKey)Registries.f_256976_, (String)"dynamictrees");
    public static final RegistryObject<LootItemConditionType> SPECIES_MATCHES = DTLootConditions.register("species_matches", SpeciesMatches.Serializer::new);
    public static final RegistryObject<LootItemConditionType> SEASONAL_SEED_DROP_CHANCE = DTLootConditions.register("seasonal_seed_drop_chance", SeasonalSeedDropChance.Serializer::new);
    public static final RegistryObject<LootItemConditionType> VOLUNTARY_SEED_DROP_CHANCE = DTLootConditions.register("voluntary_seed_drop_chance", VoluntarySeedDropChance.Serializer::new);

    private static RegistryObject<LootItemConditionType> register(String name, Supplier<Serializer<? extends LootItemCondition>> serializerFactory) {
        return LOOT_CONDITION_TYPES.register(name, () -> new LootItemConditionType((Serializer)serializerFactory.get()));
    }
}

