/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.loot.condition;

import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.loot.DTLootContextParams;
import com.ferreusveritas.dynamictrees.loot.condition.DTLootConditions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public final class SeasonalSeedDropChance
implements LootItemCondition {
    private static final SeasonalSeedDropChance INSTANCE = new SeasonalSeedDropChance();

    private SeasonalSeedDropChance() {
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)DTLootConditions.SEASONAL_SEED_DROP_CHANCE.get();
    }

    public boolean test(LootContext context) {
        Float seasonalSeedDropFactor = (Float)context.m_78953_(DTLootContextParams.SEASONAL_SEED_DROP_FACTOR);
        assert (seasonalSeedDropFactor != null);
        float adjustedSeasonalSeedDropFactor = Math.min(seasonalSeedDropFactor.floatValue() + 0.15f, 1.0f);
        return (Double)DTConfigs.SEED_DROP_RATE.get() * (double)adjustedSeasonalSeedDropFactor > (double)context.m_230907_().m_188501_();
    }

    public static LootItemCondition.Builder seasonalSeedDropChance() {
        return () -> INSTANCE;
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<SeasonalSeedDropChance> {
        public void serialize(JsonObject json, SeasonalSeedDropChance value, JsonSerializationContext context) {
        }

        public SeasonalSeedDropChance deserialize(JsonObject json, JsonDeserializationContext context) {
            return INSTANCE;
        }
    }
}

