/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.loot.condition;

import com.ferreusveritas.dynamictrees.loot.DTLootContextParams;
import com.ferreusveritas.dynamictrees.loot.condition.DTLootConditions;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public final class SpeciesMatches
implements LootItemCondition {
    private final String regex;

    public SpeciesMatches(String regex) {
        this.regex = regex;
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)DTLootConditions.SPECIES_MATCHES.get();
    }

    public boolean test(LootContext context) {
        Species species = (Species)context.m_78953_(DTLootContextParams.SPECIES);
        assert (species != null);
        return String.valueOf(species.getRegistryName()).matches(this.regex);
    }

    public static LootItemCondition.Builder speciesMatches(String regex) {
        return () -> new SpeciesMatches(regex);
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<SpeciesMatches> {
        public void serialize(JsonObject json, SpeciesMatches value, JsonSerializationContext context) {
            json.addProperty("name", String.valueOf(value.regex));
        }

        public SpeciesMatches deserialize(JsonObject json, JsonDeserializationContext context) {
            return new SpeciesMatches(GsonHelper.m_13906_((JsonObject)json, (String)"name"));
        }
    }
}

