/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.models.baked;

import com.ferreusveritas.dynamictrees.block.entity.PottedSaplingBlockEntity;
import com.ferreusveritas.dynamictrees.client.QuadManipulator;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class BakedModelBlockBonsaiPot
implements IDynamicBakedModel {
    protected BakedModel basePotModel;
    protected Map<Species, List<BakedQuad>> cachedSaplingQuads = new HashMap<Species, List<BakedQuad>>();

    public BakedModelBlockBonsaiPot(BakedModel basePotModel) {
        this.basePotModel = basePotModel;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (side != null || state == null || !extraData.has(PottedSaplingBlockEntity.SPECIES) || !extraData.has(PottedSaplingBlockEntity.POT_MIMIC)) {
            return quads;
        }
        Species species = (Species)extraData.get(PottedSaplingBlockEntity.SPECIES);
        BlockState potState = (BlockState)extraData.get(PottedSaplingBlockEntity.POT_MIMIC);
        if (species == null || potState == null || !species.isValid() || !species.getSapling().isPresent()) {
            return quads;
        }
        BlockState saplingState = species.getSapling().get().m_49966_();
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        BakedModel potModel = dispatcher.m_110910_(potState);
        BakedModel saplingModel = dispatcher.m_110910_(saplingState);
        quads.addAll(potModel.getQuads(potState, side, rand, extraData, renderType));
        quads.addAll(this.cachedSaplingQuads.computeIfAbsent(species, s -> QuadManipulator.getQuads(saplingModel, saplingState, new Vec3(0.0, 0.25, 0.0), rand, extraData)));
        return quads;
    }

    public boolean m_7541_() {
        return this.basePotModel.m_7541_();
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7521_() {
        return true;
    }

    public boolean m_7547_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.basePotModel.m_6160_();
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

